package com.xebialabs.deployit.core.rest.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable = SerializableTask.class, tagName = "task")
public class TaskSelectorWriter implements Converter {
    @Override
    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        if (source instanceof ArchivedTask) {
            new ArchivedTaskWriter().marshal(source, writer, context);
        } else if (source instanceof TaskWithBlock) {
            new TaskWithBlockWriter().marshal(source, writer, context);
        } else if (source instanceof TaskState) {
            new TaskWriter().marshal(source, writer, context);
        }
    }

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        throw new UnsupportedOperationException("Core will not deserialize tasks");
    }

    @Override
    public boolean canConvert(final Class type) {
        return SerializableTask.class.isAssignableFrom(type);
    }
}
