package com.xebialabs.deployit.core.rest.json;

import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.xltype.serialization.json.InspectionJsonConverter;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class InspectionJsonReaderWriter implements MessageBodyWriter<Inspection>, MessageBodyReader<Inspection> {
    private final ReaderPostProcessor postProcessor;

    @Autowired
    public InspectionJsonReaderWriter(ReaderPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    private boolean isAssignableFromInspection(Class<?> type) {
        return Inspection.class.isAssignableFrom(type);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return isAssignableFromInspection(type);
    }

    @Override
    public Inspection readFrom(Class<Inspection> type, Type genericType, Annotation[] annotations, MediaType mediaType,
                               MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
            throws IOException, WebApplicationException {
        String json = IOUtils.toString(entityStream, StandardCharsets.UTF_8);
        return postProcessor.apply(context -> {
            PasswordEncryptingCiConverter converter = new PasswordEncryptingCiConverter();
            context.register(converter);
            return new InspectionJsonConverter(converter).toInspection(json);
        });
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return isAssignableFromInspection(type);
    }

    @Override
    public long getSize(Inspection inspection, Class<?> type, Type genericType, Annotation[] annotations,
                        MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Inspection inspection, Class<?> type, Type genericType, Annotation[] annotations,
                        MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream)
            throws IOException, WebApplicationException {
        String json = new InspectionJsonConverter(new PasswordEncryptingCiConverter()).toJson(inspection);
        entityStream.write(json.getBytes(StandardCharsets.UTF_8));
    }
}
