/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.converter.HoconDurationConverter$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SatelliteRepository;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\t\u0012\u0001yA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\tC\u0003G\u0001\u0011\u0005q\tC\u0004]\u0001\t\u0007I\u0011A/\t\r!\u0004\u0001\u0015!\u0003_\u0011%)\b\u00011AA\u0002\u0013\u0005a\u000fC\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0001BCA\r\u0001\u0001\u0007\t\u0011)Q\u0005o\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!a$\u0001\t\u0003\n\t\nC\u0004\u0002D\u0002!\t%!2\u0003)M\u000bG/\u001a7mSR,7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\t\u00112#A\u0002ba&T!\u0001F\u000b\u0002\tI,7\u000f\u001e\u0006\u0003-]\tAaY8sK*\u0011\u0001$G\u0001\tI\u0016\u0004Hn\\=ji*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0005\u0001})C\u0006\u0005\u0002!G5\t\u0011E\u0003\u0002#'\u000591/Z2ve\u0016$\u0017B\u0001\u0013\"\u0005]\t%m\u001d;sC\u000e$8+Z2ve\u0016$'+Z:pkJ\u001cW\r\u0005\u0002'U5\tqE\u0003\u0002\u0013Q)\u0011\u0011fF\u0001\u0007K:<\u0017N\\3\n\u0005-:#\u0001E*bi\u0016dG.\u001b;f'\u0016\u0014h/[2f!\ti#'D\u0001/\u0015\ty\u0003'A\u0003tY\u001a$$NC\u00012\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001a/\u0005\u001daunZ4j]\u001e\f1c]1uK2d\u0017\u000e^3SKB|7/\u001b;pef\u0004\"AN\u001d\u000e\u0003]R!\u0001O\f\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002;o\t\u00192+\u0019;fY2LG/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t\u0002/Y4j]\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}*\u0012aB:feZL7-Z\u0005\u0003\u0003z\u0012\u0011\u0003U1hS:\fG/[8o'\u0016\u0014h/[2f\u0003E\u0011X\r]8tSR|'/_*feZL7-\u001a\t\u0003m\u0011K!!R\u001c\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0011*[E\n\u0005\u0002J\u00015\t\u0011\u0003C\u00035\t\u0001\u0007Q\u0007C\u0003<\t\u0001\u0007A\bC\u0003C\t\u0001\u00071\t\u000b\u0002\u0005\u001dB\u0011qJW\u0007\u0002!*\u0011\u0011KU\u0001\u000bC:tw\u000e^1uS>t'BA*U\u0003\u001d1\u0017m\u0019;pefT!!\u0016,\u0002\u000b\t,\u0017M\\:\u000b\u0005]C\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003e\u000b1a\u001c:h\u0013\tY\u0006KA\u0005BkR|w/\u001b:fI\u0006A!/Z:q_:\u001cX-F\u0001_!\tyf-D\u0001a\u0015\t\t'-A\u0002ta&T!a\u00193\u0002\u0011I,7\u000f^3bgfT!!\u001a-\u0002\u000b)\u0014wn]:\n\u0005\u001d\u0004'\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017!\u0003:fgB|gn]3!Q\t1!\u000e\u0005\u0002lg6\tAN\u0003\u0002\u0017[*\u0011an\\\u0001\u0003eNT!\u0001]9\u0002\u0005]\u001c(\"\u0001:\u0002\u000b)\fg/\u0019=\n\u0005Qd'aB\"p]R,\u0007\u0010^\u0001\u0017I\u00164\u0017-\u001e7u!&tw\rV5nK>,H\u000f\u0015:paV\tq\u000fE\u0002y\u0003\u0007q!!_@\u0011\u0005ilX\"A>\u000b\u0005ql\u0012A\u0002\u001fs_>$hHC\u0001\u007f\u0003\u0015\u00198-\u00197b\u0013\r\t\t!`\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005Q0\u0001\u000eeK\u001a\fW\u000f\u001c;QS:<G+[7f_V$\bK]8q?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005U\u0001\u0003BA\b\u0003#i\u0011!`\u0005\u0004\u0003'i(\u0001B+oSRD\u0001\"a\u0006\t\u0003\u0003\u0005\ra^\u0001\u0004q\u0012\n\u0014a\u00063fM\u0006,H\u000e\u001e)j]\u001e$\u0016.\\3pkR\u0004&o\u001c9!Q\u001dI\u0011QDA\u0012\u0003K\u00012aTA\u0010\u0013\r\t\t\u0003\u0015\u0002\u0006-\u0006dW/Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003O\t1\u0006J>eKBdw.\u001f\u0018tCR,G\u000e\\5uK:\"\u0018.\\3pkRt\u0013N\u001c4puE\u0002\u0004e]3d_:$7/`\u0001\u0013I\u00164\u0017-\u001e7u!&tw\rV5nK>,H/\u0006\u0002\u0002.A!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005]R0\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u000f\u00022\tqa)\u001b8ji\u0016$UO]1uS>t\u0017aB4fi&sgm\u001c\u000b\u0005\u0003\u0003\ni\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9eJ\u0001\u0004IR|\u0017\u0002BA&\u0003\u000b\u0012QbU1uK2d\u0017\u000e^3J]\u001a|\u0007BBA(\u0017\u0001\u0007q/\u0001\u0003dS&#\u0017\u0001C4fi&sgm\\:\u0015\t\u0005U\u0013q\u000f\t\u0007\u0003/\n\t(!\u0011\u000f\t\u0005e\u00131\u000e\b\u0005\u00037\n9G\u0004\u0003\u0002^\u0005\u0015d\u0002BA0\u0003Gr1A_A1\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\tA\u0012$C\u0002\u0002j]\t\u0011\u0002\u001d:pm&\u001c\u0018n\u001c8\n\t\u00055\u0014qN\u0001\ba\u0006\u001c7.Y4f\u0015\r\tIgF\u0005\u0005\u0003g\n)HA\u0003K\u0019&\u001cHO\u0003\u0003\u0002n\u0005=\u0004bBA=\u0019\u0001\u0007\u00111P\u0001\u0004S\u0012\u001c\b#BA,\u0003c:\u0018\u0001E1sKBcWoZ5ogNKhnY3e)\u0011\t\t)!$\u0011\r\u0005=\u00111QAD\u0013\r\t)) \u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0011\u0011R\u0005\u0004\u0003\u0017k(a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u001fj\u0001\u0019A<\u0002\u00131L7\u000f\u001e%pgR\u001cHCCAJ\u0003S\u000bY+a,\u0002:B1\u0011QSAP\u0003Gk!!a&\u000b\t\u0005e\u00151T\u0001\u0005kRLGN\u0003\u0002\u0002\u001e\u0006!!.\u0019<b\u0013\u0011\t\t+a&\u0003\t1K7\u000f\u001e\t\u0005\u0003\u0007\n)+\u0003\u0003\u0002(\u0006\u0015#aE\"p]\u001aLw-\u001e:bi&|g.\u0013;f[&#\u0007BBA(\u001d\u0001\u0007q\u000f\u0003\u0004\u0002.:\u0001\ra^\u0001\u0005]\u0006lW\rC\u0004\u00022:\u0001\r!a-\u0002\rA\fw-\u001b8h!\u0011\t\u0019%!.\n\t\u0005]\u0016Q\t\u0002\u0007!\u0006<\u0017N\\4\t\u000f\u0005mf\u00021\u0001\u0002>\u0006)qN\u001d3feB!\u00111IA`\u0013\u0011\t\t-!\u0012\u0003\u0011=\u0013H-\u001a:j]\u001e\f!bY8v]RDun\u001d;t)\u0019\t9-a5\u0002VB!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006m\u0015\u0001\u00027b]\u001eLA!!5\u0002L\n9\u0011J\u001c;fO\u0016\u0014\bBBA(\u001f\u0001\u0007q\u000f\u0003\u0004\u0002.>\u0001\ra\u001e\u0015\u0004\u0001\u0005e\u0007\u0003BAn\u0003Cl!!!8\u000b\u0007\u0005}g+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a9\u0002^\n91+\u001a:wS\u000e,\u0007")
public class SatelliteServiceImpl
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final SatelliteRepository satelliteRepository;
    private final PaginationService paginationService;
    private final RepositoryService repositoryService;
    @Context
    private final HttpResponse response;
    @Value(value="${deploy.satellite.timeout.info:10 seconds}")
    private String defaultPingTimeoutProp;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteServiceImpl satelliteServiceImpl = this;
        synchronized (satelliteServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public String defaultPingTimeoutProp() {
        return this.defaultPingTimeoutProp;
    }

    public void defaultPingTimeoutProp_$eq(String x$1) {
        this.defaultPingTimeoutProp = x$1;
    }

    private FiniteDuration defaultPingTimeout() {
        return HoconDurationConverter$.MODULE$.convert(this.defaultPingTimeoutProp());
    }

    public SatelliteInfo getInfo(String ciId) {
        ActorRef x$3;
        Timeout x$2;
        SatelliteInfoChecker.Get x$1;
        ActorSystem actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        ExecutionContextExecutor dispatcher = actorSystem.dispatcher();
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = TaskActorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(checker);
        Future future = AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), actorSystem))), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)).recover((PartialFunction)new Serializable(this, satellite){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServiceImpl $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Operation failed on satellite ").append($this.satellite$1.getAddress()).append(" (").append(A1.getMessage()).append(")").toString());
                SatelliteInfo satelliteInfo = new SatelliteInfo();
                return (B1)satelliteInfo;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteServiceImpl$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)dispatcher);
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout()));
        if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
            Option<Object> option = this.arePluginsSynced(ci.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    public List<SatelliteInfo> getInfos(List<String> ids) {
        ExecutionContextExecutor dispatcher = TaskActorSystem$.MODULE$.actorSystem().dispatcher();
        Buffer getInfoFutures = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ids).asScala().map((Function1 & Serializable)ciId -> Future$.MODULE$.apply((Function0 & Serializable)() -> this.getInfo((String)ciId), (ExecutionContext)dispatcher));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)getInfoFutures, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)dispatcher), (Duration)package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(3), this.defaultPingTimeout()))).toList()).asJava();
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Some some;
        ActorSystem actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, actorSystem);
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception error) {
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(51).append("Plugin sync check operation failed on satellite ").append(satellite.getAddress()).append(" (").append(error.getMessage()).append(")").toString());
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> this.countHosts(ciId, name), paging);
        return this.satelliteRepository.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.satelliteRepository.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteServiceImpl(SatelliteRepository satelliteRepository, PaginationService paginationService, RepositoryService repositoryService) {
        this.satelliteRepository = satelliteRepository;
        this.paginationService = paginationService;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        this.response = null;
    }
}

