/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.util;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.settings.GeneralSettings;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class GeneralSettingsUtils$ {
    public static final GeneralSettingsUtils$ MODULE$ = new GeneralSettingsUtils$();
    private static final int MAX_LOGO_FILE_SIZE_BYTES = 0x100000;

    private int MAX_LOGO_FILE_SIZE_BYTES() {
        return MAX_LOGO_FILE_SIZE_BYTES;
    }

    public void validate(GeneralSettings generalSetting) {
        this.validateLogoFile(generalSetting.logoFile());
    }

    private void validateLogoFile(String logoFile) {
        block0: {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(logoFile))) break block0;
            this.validateLogoFileSize(logoFile);
            this.validateLogoFileType(logoFile);
        }
    }

    private void validateLogoFileSize(String logoFile) {
        int paddingCount;
        int characterCount = logoFile.length();
        int sizeInBytes = 3 * (characterCount / 4) - (paddingCount = StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(logoFile.substring(characterCount - 2, characterCount)), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)GeneralSettingsUtils$.$anonfun$validateLogoFileSize$1(BoxesRunTime.unboxToChar((Object)c)))));
        Checks.checkTrue((sizeInBytes <= this.MAX_LOGO_FILE_SIZE_BYTES() ? 1 : 0) != 0, (String)"Logo file is too large. Maximum size is 1 MB", (Object[])new Object[0]);
    }

    private void validateLogoFileType(String logoFile) {
        Checks.checkTrue((boolean)logoFile.substring("data:".length()).startsWith("image/"), (String)"Logo file must be of an image file type.", (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$validateLogoFileSize$1(char c) {
        return c == '=';
    }

    private GeneralSettingsUtils$() {
    }
}

