/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.converter.HoconDurationConverter$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SatelliteRepository;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u000b\u0016\u0001\tB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"Aa\t\u0001B\u0001B\u0003%q\tC\u0003K\u0001\u0011\u00051\nC\u0004a\u0001\t\u0007I\u0011A1\t\r1\u0004\u0001\u0015!\u0003c\u0011%I\b\u00011AA\u0002\u0013\u0005!\u0010C\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\u0002\u0005M\u0001BCA\u0011\u0001\u0001\u0007\t\u0011)Q\u0005w\"9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002\"CA#\u0001\t\u0007I1AA$\u0011!\tI\u0006\u0001Q\u0001\n\u0005%\u0003\"CA.\u0001\t\u0007I1AA/\u0011!\t9\u0007\u0001Q\u0001\n\u0005}\u0003bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003{\u0002A\u0011IA@\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!a/\u0001\t\u0003\ni\fC\u0004\u0002p\u0002!\t%!=\u0003)M\u000bG/\u001a7mSR,7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\t1r#A\u0002ba&T!\u0001G\r\u0002\tI,7\u000f\u001e\u0006\u00035m\tAaY8sK*\u0011A$H\u0001\tI\u0016\u0004Hn\\=ji*\u0011adH\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001I\u0001\u0004G>l7\u0001A\n\u0005\u0001\rJ\u0003\u0007\u0005\u0002%O5\tQE\u0003\u0002'/\u000591/Z2ve\u0016$\u0017B\u0001\u0015&\u0005]\t%m\u001d;sC\u000e$8+Z2ve\u0016$'+Z:pkJ\u001cW\r\u0005\u0002+]5\t1F\u0003\u0002\u0017Y)\u0011QfG\u0001\u0007K:<\u0017N\\3\n\u0005=Z#\u0001E*bi\u0016dG.\u001b;f'\u0016\u0014h/[2f!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\f1c]1uK2d\u0017\u000e^3SKB|7/\u001b;pef\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u000e\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002?w\t\u00192+\u0019;fY2LG/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t\u0002/Y4j]\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rK\u0012aB:feZL7-Z\u0005\u0003\u000b\n\u0013\u0011\u0003U1hS:\fG/[8o'\u0016\u0014h/[2f\u0003E\u0011X\r]8tSR|'/_*feZL7-\u001a\t\u0003u!K!!S\u001e\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0019:{\u0005\u000b\u0005\u0002N\u00015\tQ\u0003C\u00039\t\u0001\u0007\u0011\bC\u0003@\t\u0001\u0007\u0001\tC\u0003G\t\u0001\u0007q\t\u000b\u0002\u0005%B\u00111KX\u0007\u0002)*\u0011QKV\u0001\u000bC:tw\u000e^1uS>t'BA,Y\u0003\u001d1\u0017m\u0019;pefT!!\u0017.\u0002\u000b\t,\u0017M\\:\u000b\u0005mc\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003u\u000b1a\u001c:h\u0013\tyFKA\u0005BkR|w/\u001b:fI\u0006A!/Z:q_:\u001cX-F\u0001c!\t\u0019'.D\u0001e\u0015\t)g-A\u0002ta&T!a\u001a5\u0002\u0011I,7\u000f^3bgfT!!\u001b/\u0002\u000b)\u0014wn]:\n\u0005-$'\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017!\u0003:fgB|gn]3!Q\t1a\u000e\u0005\u0002po6\t\u0001O\u0003\u0002\u001bc*\u0011!o]\u0001\u0003eNT!\u0001^;\u0002\u0005]\u001c(\"\u0001<\u0002\u000b)\fg/\u0019=\n\u0005a\u0004(aB\"p]R,\u0007\u0010^\u0001\u0017I\u00164\u0017-\u001e7u!&tw\rV5nK>,H\u000f\u0015:paV\t1\u0010E\u0002}\u0003\u0017q1!`A\u0004!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u0011\u0002\rq\u0012xn\u001c;?\u0015\t\t)!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0005\r\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twM\u0003\u0003\u0002\n\u0005\r\u0011A\u00073fM\u0006,H\u000e\u001e)j]\u001e$\u0016.\\3pkR\u0004&o\u001c9`I\u0015\fH\u0003BA\u000b\u0003;\u0001B!a\u0006\u0002\u001a5\u0011\u00111A\u0005\u0005\u00037\t\u0019A\u0001\u0003V]&$\b\u0002CA\u0010\u0011\u0005\u0005\t\u0019A>\u0002\u0007a$\u0013'A\feK\u001a\fW\u000f\u001c;QS:<G+[7f_V$\bK]8qA!:\u0011\"!\n\u0002,\u00055\u0002cA*\u0002(%\u0019\u0011\u0011\u0006+\u0003\u000bY\u000bG.^3\u0002\u000bY\fG.^3\"\u0005\u0005=\u0012a\u000b\u0013|I\u0016\u0004Hn\\=/g\u0006$X\r\u001c7ji\u0016tC/[7f_V$h&\u001b8g_j\n\u0004\u0007I:fG>tGm]?\u0002%\u0011,g-Y;miBKgn\u001a+j[\u0016|W\u000f^\u000b\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0005ekJ\fG/[8o\u0015\u0011\ty$a\u0001\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002D\u0005e\"A\u0004$j]&$X\rR;sCRLwN\\\u0001\fC\u000e$xN]*zgR,W.\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!B1di>\u0014(BAA*\u0003\u0011\t7n[1\n\t\u0005]\u0013Q\n\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0007bGR|'oU=ti\u0016l\u0007%\u0001\u0006eSN\u0004\u0018\r^2iKJ,\"!a\u0018\u0011\t\u0005\u0005\u00141M\u0007\u0003\u0003{IA!!\u001a\u0002>\tAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\u0002\u0017\u0011L7\u000f]1uG\",'\u000fI\u0001\bO\u0016$\u0018J\u001c4p)\u0011\ti'!\u001f\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d,\u0003\r!Go\\\u0005\u0005\u0003o\n\tHA\u0007TCR,G\u000e\\5uK&sgm\u001c\u0005\u0007\u0003wz\u0001\u0019A>\u0002\t\rL\u0017\nZ\u0001\tO\u0016$\u0018J\u001c4pgR!\u0011\u0011QAR!\u0019\t\u0019)!(\u0002n9!\u0011QQAL\u001d\u0011\t9)a%\u000f\t\u0005%\u0015\u0011\u0013\b\u0005\u0003\u0017\u000byID\u0002\u007f\u0003\u001bK\u0011\u0001I\u0005\u0003=}I!\u0001H\u000f\n\u0007\u0005U5$A\u0005qe>4\u0018n]5p]&!\u0011\u0011TAN\u0003\u001d\u0001\u0018mY6bO\u0016T1!!&\u001c\u0013\u0011\ty*!)\u0003\u000b)c\u0015n\u001d;\u000b\t\u0005e\u00151\u0014\u0005\b\u0003K\u0003\u0002\u0019AAT\u0003\rIGm\u001d\t\u0006\u0003\u0007\u000bij_\u0001\u0011CJ,\u0007\u000b\\;hS:\u001c8+\u001f8dK\u0012$B!!,\u0002:B1\u0011qCAX\u0003gKA!!-\u0002\u0004\t1q\n\u001d;j_:\u0004B!a\u0006\u00026&!\u0011qWA\u0002\u0005\u001d\u0011un\u001c7fC:Da!a\u001f\u0012\u0001\u0004Y\u0018!\u00037jgRDun\u001d;t))\ty,!6\u0002X\u0006m\u0017Q\u001d\t\u0007\u0003\u0003\fY-a4\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\fA!\u001e;jY*\u0011\u0011\u0011Z\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002N\u0006\r'\u0001\u0002'jgR\u0004B!a\u001c\u0002R&!\u00111[A9\u0005M\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\%e\u0011\u0019\tYH\u0005a\u0001w\"1\u0011\u0011\u001c\nA\u0002m\fAA\\1nK\"9\u0011Q\u001c\nA\u0002\u0005}\u0017A\u00029bO&tw\r\u0005\u0003\u0002p\u0005\u0005\u0018\u0002BAr\u0003c\u0012a\u0001U1hS:<\u0007bBAt%\u0001\u0007\u0011\u0011^\u0001\u0006_J$WM\u001d\t\u0005\u0003_\nY/\u0003\u0003\u0002n\u0006E$\u0001C(sI\u0016\u0014\u0018N\\4\u0002\u0015\r|WO\u001c;I_N$8\u000f\u0006\u0004\u0002t\u0006}(\u0011\u0001\t\u0005\u0003k\fY0\u0004\u0002\u0002x*!\u0011\u0011`Ad\u0003\u0011a\u0017M\\4\n\t\u0005u\u0018q\u001f\u0002\b\u0013:$XmZ3s\u0011\u0019\tYh\u0005a\u0001w\"1\u0011\u0011\\\nA\u0002mD3\u0001\u0001B\u0003!\u0011\u00119A!\u0004\u000e\u0005\t%!b\u0001B\u00065\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t=!\u0011\u0002\u0002\b'\u0016\u0014h/[2f\u0001")
public class SatelliteServiceImpl
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final SatelliteRepository satelliteRepository;
    private final PaginationService paginationService;
    private final RepositoryService repositoryService;
    @Context
    private final HttpResponse response;
    @Value(value="${deploy.satellite.timeout.info:10 seconds}")
    private String defaultPingTimeoutProp;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor dispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteServiceImpl satelliteServiceImpl = this;
        synchronized (satelliteServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public String defaultPingTimeoutProp() {
        return this.defaultPingTimeoutProp;
    }

    public void defaultPingTimeoutProp_$eq(String x$1) {
        this.defaultPingTimeoutProp = x$1;
    }

    private FiniteDuration defaultPingTimeout() {
        return HoconDurationConverter$.MODULE$.convert(this.defaultPingTimeoutProp());
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    public SatelliteInfo getInfo(String ciId) {
        ActorRef x$3;
        Timeout x$2;
        SatelliteInfoChecker.Get x$1;
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = TaskActorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(checker);
        Future future = AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), this.actorSystem()))), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)).recover((PartialFunction)new Serializable(this, satellite){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServiceImpl $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Operation failed on satellite ").append($this.satellite$1.getAddress()).append(" (").append(A1.getMessage()).append(")").toString());
                SatelliteInfo satelliteInfo = new SatelliteInfo();
                return (B1)satelliteInfo;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteServiceImpl$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)this.dispatcher());
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout()));
        if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
            Option<Object> option = this.arePluginsSynced(ci.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    public List<SatelliteInfo> getInfos(List<String> ids) {
        Buffer getInfoFutures = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ids).asScala().map((Function1 & Serializable)ciId -> Future$.MODULE$.apply((Function0 & Serializable)() -> this.getInfo((String)ciId), (ExecutionContext)this.dispatcher()));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)getInfoFutures, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.dispatcher()), (Duration)package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(3), this.defaultPingTimeout()))).toList()).asJava();
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Some some;
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, this.actorSystem());
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception error) {
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(51).append("Plugin sync check operation failed on satellite ").append(satellite.getAddress()).append(" (").append(error.getMessage()).append(")").toString());
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> this.countHosts(ciId, name), paging);
        return this.satelliteRepository.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.satelliteRepository.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteServiceImpl(SatelliteRepository satelliteRepository, PaginationService paginationService, RepositoryService repositoryService) {
        this.satelliteRepository = satelliteRepository;
        this.paginationService = paginationService;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        this.response = null;
        this.actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        this.dispatcher = this.actorSystem().dispatcher();
    }
}

