package com.xebialabs.deployit.provision
package resolver.placeholder

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary

import scala.jdk.CollectionConverters._

abstract class PlaceholderResolver {

  def resolve(value: AnyRef, pd: Option[PropertyKind] = None, ignoreContextPlaceholders: Boolean = false): AnyRef = pd match {
    case Some(PropertyKind.STRING) | None =>
      scanPlaceholdersAndReplace(value.toString, ignoreContextPlaceholders)
    case Some(PropertyKind.LIST_OF_STRING) =>
      new JArrayList[String](
        value
          .asInstanceOf[JList[String]]
          .asScala
          .map(x => scanPlaceholdersAndReplace(x, ignoreContextPlaceholders))
          .asJava
      )
    case Some(PropertyKind.SET_OF_STRING) =>
      new JHashSet[String](
        value
          .asInstanceOf[JSet[String]]
          .asScala
          .map(x => scanPlaceholdersAndReplace(x, ignoreContextPlaceholders))
          .asJava
      )
    case Some(PropertyKind.MAP_STRING_STRING) =>
      new JHashMap[String, String](
        value
          .asInstanceOf[JMap[String, String]]
          .asScala
          .map { case (k, v) => scanPlaceholdersAndReplace(k) -> scanPlaceholdersAndReplace(v, ignoreContextPlaceholders) }
          .asJava
      )
    case _ =>
      value
  }

  def scanPlaceholdersAndReplace(propertyValue: String, ignoreContextPlaceholders: Boolean = false, delimiters: String = defaultDelimiter): String
}

object PlaceholderResolver {
  def apply(dictionary: ConsolidatedDictionary, sourceDeployed: Option[DeployedType] = None): MustachePlaceholderResolver = {
    new MustachePlaceholderResolver(dictionary, sourceDeployed)
  }
}
