package com.xebialabs.deployit.provision.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Environment
import com.xebialabs.deployit.provision.RefMap
import com.xebialabs.deployit.provision.steps.ReferenceService
import com.xebialabs.deployit.repository.sql.base._
import com.xebialabs.deployit.repository.{ChangeSet, RepositoryServiceHolder, SearchParameters, SqlRepositoryService}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class SqlReferenceService extends ReferenceService {
  private val repositoryService = RepositoryServiceHolder.getRepositoryService

  override def findCiReferences(changeSet: ChangeSet): RefMap = {

    repositoryService match {
      case sqlRepo: SqlRepositoryService =>

        val envParameters = new SearchParameters()
        envParameters.setType(Type.valueOf(classOf[Environment]))

        changeSet.getDeleteCiIds.asScala.filter(sqlRepo.exists).flatMap { id =>
          val childrenParameters = new SearchParameters()
          childrenParameters.setAncestor(id)
          Map(idToPath(id) -> (sqlRepo.findReferencesTo(id, envParameters).asScala.map(ci => idToPath(ci.getId)).toList
            ++ sqlRepo.list(childrenParameters).asScala.map(ci => idToPath(ci.getId)).toList))
        }.toMap

      case _ => Map()
    }
  }
}
