package ai.digital.deploy.profiling

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.ServerLaunchOptions
import com.xebialabs.deployit.spring.profile.DynamicActiveProfile

object ApplicationProfiler {
  final val PROFILING = "profiling"
}

class ApplicationProfiler  extends DynamicActiveProfile {
  override val profileNames: Array[String] =
    Array(ApplicationProfiler.PROFILING)

  /**
   * Always returns false as the server configuration has nothing to do with spring profiles
   *
   * @param serverConfiguration
   * @return
   */
  override def configPropertyCallback(serverConfiguration: ServerConfiguration): Boolean = false


  override def launchOptionsCallback(launchOptions: ServerLaunchOptions): Boolean = {
    Option(launchOptions).exists(!_.isProfilingEnabled)
  }
}
