package ai.digital.deploy.task.status.queue

import ai.digital.deploy.task.status.TaskPathStatusStoreHolder
import com.xebialabs.deployit.core.events.{TaskPathStatusEvent, TaskStateChangeEvent}
import com.xebialabs.deployit.engine.spi.execution.{BlockExecutionStateEvent, NonRemotableExecutionStateListener, StepExecutionStateEvent, TaskExecutionStateEvent}
import grizzled.slf4j.Logging

class TaskPathStatusListener extends NonRemotableExecutionStateListener with Logging {
  override def stepStateChanged(event: StepExecutionStateEvent): Unit = {
    TaskPathStatusStoreHolder.getTaskPathStatusJmsBean.sendChangeSetEvent(
      TaskPathStatusEvent(event.task().getId, event.step().getMetadata().get("blockPath"), event.currentState().toString))
  }

  override def taskStateChanged(event: TaskExecutionStateEvent): Unit = {
    TaskPathStatusStoreHolder.getTaskPathStatusJmsBean.sendTaskStateChangeEvent(
      TaskStateChangeEvent(event.task().getId, event.currentState().name(), event.previousState().name()))
  }

  override def blockStateChanged(event: BlockExecutionStateEvent): Unit = {
    TaskPathStatusStoreHolder.getTaskPathStatusJmsBean.sendChangeSetEvent(
      TaskPathStatusEvent(event.task().getId, event.block().getId, event.currentState().toString))
  }
}
