package ai.digital.deploy.task.status.queue

import com.xebialabs.deployit.core.events.TaskPathStatusEvent
import com.xebialabs.deployit.engine.spi.execution.{BlockExecutionStateEvent, NonRemotableExecutionStateListener, StepExecutionStateEvent, TaskExecutionStateEvent}
import grizzled.slf4j.Logging

import ai.digital.deploy.task.status.TaskPathStatusStoreHolder

class TaskPathStatusListener extends NonRemotableExecutionStateListener with Logging {
  override def stepStateChanged(event: StepExecutionStateEvent): Unit = {
    TaskPathStatusStoreHolder.getTaskPathStatusJmsBean.sendChangeSetEvent(
      TaskPathStatusEvent(event.task().getId, event.step().getMetadata().get("blockPath"), event.currentState().toString))
  }

  override def taskStateChanged(event: TaskExecutionStateEvent): Unit = {}

  override def blockStateChanged(event: BlockExecutionStateEvent): Unit = {
    TaskPathStatusStoreHolder.getTaskPathStatusJmsBean.sendChangeSetEvent(
      TaskPathStatusEvent(event.task().getId, event.block().getId, event.currentState().toString))
  }
}
