package ai.digital.deploy.task.steplog.queue

import ai.digital.deploy.task.steplog.TaskStepLogStoreHolder
import com.xebialabs.deployit.core.events.TaskStepLogEvent
import com.xebialabs.deployit.engine.tasker.Block.logger
import org.springframework.stereotype.Component
import org.springframework.context.annotation.Bean
import org.springframework.context.event.ApplicationEventMulticaster
import org.springframework.context.event.SimpleApplicationEventMulticaster
import org.springframework.core.task.SimpleAsyncTaskExecutor
import org.springframework.scheduling.support.TaskUtils
import org.springframework.context.event.EventListener
import org.springframework.scheduling.annotation.Async

@Component
class TaskStepLogListener {

  @Bean(name = Array("applicationEventMulticaster")) def applicationEventMulticaster: ApplicationEventMulticaster = {
    val eventMulticaster = new SimpleApplicationEventMulticaster
    eventMulticaster.setTaskExecutor(new SimpleAsyncTaskExecutor)
    eventMulticaster.setErrorHandler(TaskUtils.LOG_AND_SUPPRESS_ERROR_HANDLER)
    eventMulticaster
  }

  @Async
  @EventListener
  def handleStepLogEvent(event: TaskStepLogEvent): Unit = {
    logger.debug(s"Received Application TaskStepLogEvent " +
      s"taskId: ${event.taskId} " +
      s"path: ${event.stepPath} " +
      s"logLine: ${event.lineNumber} " +
      s"logLevel: ${event.logLevel} " +
      s"log: ${event.log}")
    TaskStepLogStoreHolder.getTaskStepLogJmsBean.sendStepLogEvent(
      TaskStepLogEvent(event.taskId, event.stepPath, event.lineNumber, event.logLevel, event.attempt, event.log))
  }
}
