package ai.digital.deploy.task.status.queue

import com.xebialabs.deployit.core.events.{TaskPathStatusDeleteEvent, TaskPathStatusEvent}
import com.xebialabs.xldeploy.jms.adapter.TaskPathStatusQueueNameResolver
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import org.springframework.stereotype.Component

import ai.digital.deploy.task.status._

@Component
@Autowired
class TaskPathStatusProducer(@Qualifier("taskPathStatusJmsTemplate") jmsTemplate: JmsTemplate,
                             taskPathStatusQueueNameResolver: TaskPathStatusQueueNameResolver) extends TaskPathStatusStore {

  TaskPathStatusStoreHolder.taskPathStatusStore.set(this)

  override def sendChangeSetEvent(event: TaskPathStatusEvent): Unit =
    jmsTemplate.convertAndSend(taskPathStatusQueueNameResolver.getTaskPathStatusQueueName, event)

  override def sendDeleteEvent(event: TaskPathStatusDeleteEvent): Unit =
    jmsTemplate.convertAndSend(taskPathStatusQueueNameResolver.getTaskPathStatusQueueName, event)
}
