/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.SortedSet;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.dbdoc.DBDocUtil;
import liquibase.util.StringUtil;

public class HTMLListWriter {
    private File outputDir;
    private String directory;
    private String filename;
    private String title;

    public HTMLListWriter(String title, String filename, String subdir, File outputDir) {
        this.title = title;
        this.outputDir = outputDir;
        this.filename = filename;
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        this.directory = subdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHTML(SortedSet objects) throws IOException {
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDir, this.filename)), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());){
            ((Writer)fileWriter).append("<HTML>\n<HEAD><meta charset=\"utf-8\"/>\n<TITLE>\n");
            ((Writer)fileWriter).append(this.title);
            ((Writer)fileWriter).append("\n</TITLE>\n<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">\n</HEAD>\n<BODY BGCOLOR=\"white\">\n<FONT size=\"+1\" CLASS=\"FrameHeadingFont\">\n<B>");
            ((Writer)fileWriter).append(this.title);
            ((Writer)fileWriter).append("</B></FONT>\n<BR>\n<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\"><TR>\n<TD NOWRAP><FONT CLASS=\"FrameItemFont\">");
            for (Object object : objects) {
                ((Writer)fileWriter).append("<A HREF=\"");
                ((Writer)fileWriter).append(this.directory);
                ((Writer)fileWriter).append("/");
                ((Writer)fileWriter).append(DBDocUtil.toFileName(object.toString().endsWith(".xml") ? object.toString() : object.toString().toLowerCase()));
                ((Writer)fileWriter).append(this.getTargetExtension());
                ((Writer)fileWriter).append("\" target=\"objectFrame\">");
                ((Writer)fileWriter).append(StringUtil.escapeHtml(object.toString()));
                ((Writer)fileWriter).append("</A><BR>\n");
            }
            ((Writer)fileWriter).append("</FONT></TD>\n</TR>\n</TABLE>\n\n</BODY>\n</HTML>");
        }
    }

    public String getTargetExtension() {
        return ".html";
    }
}

