/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeIdIterator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.query.QueryObjectModelImpl;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateIterator;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModel;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchManager
implements SynchronousEventListener {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchManager.class);
    private static final String NS_FN_PREFIX = "fn";
    public static final String NS_FN_URI = "http://www.w3.org/2005/xpath-functions";
    private static final String NS_FN_OLD_PREFIX = "fn_old";
    public static final String NS_FN_OLD_URI = "http://www.w3.org/2004/10/xpath-functions";
    private static final String NS_XS_PREFIX = "xs";
    public static final String NS_XS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String PARAM_QUERY_IMPL = "queryClass";
    private static final String PARAM_IDLE_TIME = "idleTime";
    private static final String DEFAULT_QUERY_IMPL_CLASS = QueryImpl.class.getName();
    private final SearchConfig config;
    private final NodeTypeRegistry ntReg;
    private final ItemStateManager itemMgr;
    private final PersistenceManager pm;
    private final FileSystem fs;
    private final NodeId rootNodeId;
    private QueryHandler handler;
    private final QueryHandler parentHandler;
    private final NamespaceRegistryImpl nsReg;
    private final NodeId excludedNodeId;
    private Path excludePath;
    private final String queryImplClassName;

    public SearchManager(SearchConfig config, NamespaceRegistryImpl nsReg, NodeTypeRegistry ntReg, ItemStateManager itemMgr, PersistenceManager pm, NodeId rootNodeId, SearchManager parentMgr, NodeId excludedNodeId) throws RepositoryException {
        this.fs = config.getFileSystem();
        this.config = config;
        this.ntReg = ntReg;
        this.nsReg = nsReg;
        this.itemMgr = itemMgr;
        this.pm = pm;
        this.rootNodeId = rootNodeId;
        this.parentHandler = parentMgr != null ? parentMgr.handler : null;
        this.excludedNodeId = excludedNodeId;
        this.safeRegisterNamespace(NS_XS_PREFIX, NS_XS_URI);
        try {
            if (nsReg.getPrefix(NS_FN_OLD_URI).equals(NS_FN_PREFIX)) {
                String prefix = NS_FN_OLD_PREFIX;
                try {
                    int i = 2;
                    while (true) {
                        nsReg.getURI(prefix);
                        prefix = NS_FN_OLD_PREFIX + i;
                        ++i;
                    }
                }
                catch (NamespaceException e) {
                    nsReg.registerNamespace(prefix, NS_FN_OLD_URI);
                }
            }
        }
        catch (NamespaceException e) {
            this.safeRegisterNamespace(NS_FN_OLD_PREFIX, NS_FN_OLD_URI);
        }
        this.safeRegisterNamespace(NS_FN_PREFIX, NS_FN_URI);
        Properties params = config.getParameters();
        this.queryImplClassName = params.getProperty(PARAM_QUERY_IMPL, DEFAULT_QUERY_IMPL_CLASS);
        if (params.containsKey(PARAM_IDLE_TIME)) {
            String msg = "Parameter 'idleTime' is not supported anymore. Please use 'maxIdleTime' in the repository configuration.";
            log.warn(msg);
        }
        if (excludedNodeId != null) {
            HierarchyManagerImpl hmgr = new HierarchyManagerImpl(rootNodeId, itemMgr);
            this.excludePath = hmgr.getPath(excludedNodeId);
        }
        this.initializeQueryHandler();
    }

    private void safeRegisterNamespace(String prefixHint, String uri) throws NamespaceException, RepositoryException {
        try {
            this.nsReg.getPrefix(uri);
        }
        catch (NamespaceException e1) {
            String prefix = prefixHint;
            try {
                int suffix = 2;
                while (true) {
                    this.nsReg.getURI(prefix);
                    prefix = prefixHint + suffix;
                    ++suffix;
                }
            }
            catch (NamespaceException e2) {
                this.nsReg.registerNamespace(prefix, uri);
            }
        }
    }

    public void close() {
        try {
            this.shutdownQueryHandler();
            if (this.fs != null) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            log.error("Exception closing QueryHandler.", (Throwable)e);
        }
        catch (FileSystemException e) {
            log.error("Exception closing FileSystem.", (Throwable)e);
        }
    }

    public Query createQuery(SessionImpl session, ItemManager itemMgr, String statement, String language) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, itemMgr, this.handler, statement, language);
        return query;
    }

    public QueryObjectModel createQueryObjectModel(SessionImpl session, QueryObjectModelTree qomTree, String langugage) throws InvalidQueryException, RepositoryException {
        QueryObjectModelImpl qom = new QueryObjectModelImpl();
        qom.init(session, session.getItemManager(), this.handler, qomTree, langugage);
        return qom;
    }

    public Query createQuery(SessionImpl session, ItemManager itemMgr, Node node) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, itemMgr, this.handler, node);
        return query;
    }

    private boolean isExcluded(EventImpl event) {
        try {
            return this.excludePath != null && this.excludePath.isAncestorOf(event.getQPath());
        }
        catch (MalformedPathException ex) {
            log.error("Error filtering events.", (Throwable)((Object)ex));
            return false;
        }
        catch (RepositoryException ex) {
            log.error("Error filtering events.", (Throwable)ex);
            return false;
        }
    }

    public QueryHandler getQueryHandler() {
        return this.handler;
    }

    public void onEvent(EventIterator events) {
        log.debug("onEvent: indexing started");
        long time = System.currentTimeMillis();
        final HashSet<NodeId> removedNodes = new HashSet<NodeId>();
        final HashMap<NodeId, EventImpl> addedNodes = new HashMap<NodeId, EventImpl>();
        ArrayList<EventImpl> propEvents = new ArrayList<EventImpl>();
        while (events.hasNext()) {
            EventImpl e = (EventImpl)events.nextEvent();
            if (this.isExcluded(e)) continue;
            long type = e.getType();
            if (type == 1L) {
                addedNodes.put(e.getChildId(), e);
                if (!e.isExternal()) continue;
                removedNodes.add(e.getChildId());
                continue;
            }
            if (type == 2L) {
                removedNodes.add(e.getChildId());
                continue;
            }
            propEvents.add(e);
        }
        for (int i = 0; i < propEvents.size(); ++i) {
            EventImpl e = (EventImpl)propEvents.get(i);
            NodeId nodeId = e.getParentId();
            if (e.getType() == 4) {
                if (addedNodes.put(nodeId, e) != null) continue;
                removedNodes.add(nodeId);
                continue;
            }
            if (e.getType() == 16) {
                addedNodes.put(nodeId, e);
                removedNodes.add(nodeId);
                continue;
            }
            addedNodes.put(nodeId, e);
            removedNodes.add(nodeId);
        }
        NodeStateIterator addedStates = new NodeStateIterator(){
            private final Iterator iter;
            {
                this.iter = addedNodes.keySet().iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.nextNodeState();
            }

            public NodeState nextNodeState() {
                NodeState item = null;
                NodeId id = (NodeId)this.iter.next();
                try {
                    item = (NodeState)SearchManager.this.itemMgr.getItemState(id);
                }
                catch (ItemStateException ise) {
                    EventImpl e = (EventImpl)addedNodes.get(id);
                    if (e == null || !e.isExternal()) {
                        log.error("Unable to index node " + id + ": does not exist");
                    }
                    log.info("Node no longer available " + id + ", skipped.");
                }
                return item;
            }
        };
        NodeIdIterator removedIds = new NodeIdIterator(){
            private final Iterator iter;
            {
                this.iter = removedNodes.iterator();
            }

            public NodeId nextNodeId() throws NoSuchElementException {
                return (NodeId)this.iter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.nextNodeId();
            }
        };
        if (removedNodes.size() > 0 || addedNodes.size() > 0) {
            try {
                this.handler.updateNodes(removedIds, addedStates);
            }
            catch (RepositoryException e) {
                log.error("Error indexing node.", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error indexing node.", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("onEvent: indexing finished in " + String.valueOf(System.currentTimeMillis() - time) + " ms.");
        }
    }

    protected AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            Object obj = Class.forName(this.queryImplClassName).newInstance();
            if (obj instanceof AbstractQueryImpl) {
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException(this.queryImplClassName + " is not of type " + AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString());
        }
    }

    private void initializeQueryHandler() throws RepositoryException {
        try {
            this.handler = (QueryHandler)this.config.newInstance();
            QueryHandlerContext context = new QueryHandlerContext(this.fs, this.itemMgr, this.pm, this.rootNodeId, this.ntReg, this.nsReg, this.parentHandler, this.excludedNodeId);
            this.handler.init(context);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private void shutdownQueryHandler() throws IOException {
        if (this.handler != null) {
            this.handler.close();
            this.handler = null;
        }
    }
}

