/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RolesPermissionsPair;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.List;
import java.util.stream.Collectors;

public class ReadPermissionHandler
extends PermissionHandler {
    public ReadPermissionHandler() {
        super(PlatformPermissions.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getUser(), Permission.getReadPermissions(), onConfigurationItem);
            }
            if (viewAsData.getRoles() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getRoles(), Permission.getReadPermissions(), onConfigurationItem);
            }
        }
        return permissionEnforcer.hasLoggedInUserPermission(Permission.getReadPermissions(), onConfigurationItem);
    }

    private List<Role> getCurrentRoles(ViewAsData viewAsData) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                return permissionEnforcer.getUserRoles(viewAsData.getUser());
            }
            if (viewAsData.getRoles() != null) {
                return viewAsData.getRoles();
            }
        }
        return permissionEnforcer.getUserRoles(Permissions.getAuthentication());
    }

    @Override
    public RolesPermissionsPair getRolesPermissionsPair() {
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        return new RolesPermissionsPair(this.getCurrentRoles(viewAsData).stream().map(Role::getId).collect(Collectors.toList()), Permission.getReadPermissions().stream().map(Permission::getPermissionName).collect(Collectors.toList()));
    }

    @Override
    public void applyPermission(SearchParameters parameters) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null && (viewAsData.getUser() != null || viewAsData.getRoles() != null)) {
            permissionEnforcer.applyPermission(parameters, this.getCurrentRoles(viewAsData), Permission.getReadPermissions());
        } else {
            permissionEnforcer.applyLoggedInUserPermission(parameters, Permission.getReadPermissions());
        }
    }
}

