/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.grpc.ChannelFactory;
import com.google.api.gax.grpc.ChannelPool;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GrpcChannelUUIDInterceptor;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.GrpcMetadataHandlerInterceptor;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.alts.ComputeEngineChannelBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@InternalExtensionOnly
public final class InstantiatingGrpcChannelProvider
implements TransportChannelProvider {
    static final String DIRECT_PATH_ENV_VAR = "GOOGLE_CLOUD_ENABLE_DIRECT_PATH";
    static final long DIRECT_PATH_KEEP_ALIVE_TIME_SECONDS = 3600L;
    static final long DIRECT_PATH_KEEP_ALIVE_TIMEOUT_SECONDS = 20L;
    static final int MAX_POOL_SIZE = 1000;
    static final String GCE_PRODUCTION_NAME_PRIOR_2016 = "Google";
    static final String GCE_PRODUCTION_NAME_AFTER_2016 = "Google Compute Engine";
    private final int processorCount;
    private final Executor executor;
    private final HeaderProvider headerProvider;
    private final String endpoint;
    private final EnvironmentProvider envProvider;
    @Nullable
    private final GrpcInterceptorProvider interceptorProvider;
    @Nullable
    private final Integer maxInboundMessageSize;
    @Nullable
    private final Integer maxInboundMetadataSize;
    @Nullable
    private final Duration keepAliveTime;
    @Nullable
    private final Duration keepAliveTimeout;
    @Nullable
    private final Boolean keepAliveWithoutCalls;
    @Nullable
    private final Integer poolSize;
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final ChannelPrimer channelPrimer;
    @Nullable
    private final Boolean attemptDirectPath;
    @VisibleForTesting
    final ImmutableMap<String, ?> directPathServiceConfig;
    @Nullable
    private final ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;

    private InstantiatingGrpcChannelProvider(Builder builder) {
        this.processorCount = builder.processorCount;
        this.executor = builder.executor;
        this.headerProvider = builder.headerProvider;
        this.endpoint = builder.endpoint;
        this.envProvider = builder.envProvider;
        this.interceptorProvider = builder.interceptorProvider;
        this.maxInboundMessageSize = builder.maxInboundMessageSize;
        this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.poolSize = builder.poolSize;
        this.channelConfigurator = builder.channelConfigurator;
        this.credentials = builder.credentials;
        this.channelPrimer = builder.channelPrimer;
        this.attemptDirectPath = builder.attemptDirectPath;
        this.directPathServiceConfig = builder.directPathServiceConfig == null ? InstantiatingGrpcChannelProvider.getDefaultDirectPathServiceConfig() : builder.directPathServiceConfig;
    }

    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Deprecated
    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    public TransportChannelProvider withExecutor(Executor executor) {
        return this.toBuilder().setExecutor(executor).build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers)).build();
    }

    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    public boolean needsEndpoint() {
        return this.endpoint == null;
    }

    public TransportChannelProvider withEndpoint(String endpoint) {
        InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
        return this.toBuilder().setEndpoint(endpoint).build();
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public boolean acceptsPoolSize() {
        return this.poolSize == null;
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public TransportChannelProvider withPoolSize(int size) {
        Preconditions.checkState((boolean)this.acceptsPoolSize(), (String)"pool size already set to %s", (Object)this.poolSize);
        return this.toBuilder().setPoolSize(size).build();
    }

    public boolean needsCredentials() {
        return this.credentials == null;
    }

    public TransportChannelProvider withCredentials(Credentials credentials) {
        return this.toBuilder().setCredentials(credentials).build();
    }

    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsExecutor()) {
            throw new IllegalStateException("getTransportChannel() called when needsExecutor() is true");
        }
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        if (this.needsEndpoint()) {
            throw new IllegalStateException("getTransportChannel() called when needsEndpoint() is true");
        }
        return this.createChannel();
    }

    private TransportChannel createChannel() throws IOException {
        int realPoolSize = (Integer)MoreObjects.firstNonNull((Object)this.poolSize, (Object)1);
        ChannelFactory channelFactory = new ChannelFactory(){

            @Override
            public ManagedChannel createSingleChannel() throws IOException {
                return InstantiatingGrpcChannelProvider.this.createSingleChannel();
            }
        };
        ChannelPool outerChannel = this.channelPrimer != null ? ChannelPool.createRefreshing(realPoolSize, channelFactory) : ChannelPool.create(realPoolSize, channelFactory);
        return GrpcTransportChannel.create(outerChannel);
    }

    private boolean isDirectPathEnabled(String serviceAddress) {
        if (this.attemptDirectPath != null) {
            return this.attemptDirectPath;
        }
        String whiteList = this.envProvider.getenv(DIRECT_PATH_ENV_VAR);
        if (whiteList == null) {
            return false;
        }
        for (String service : whiteList.split(",")) {
            if (service.isEmpty() || !serviceAddress.contains(service)) continue;
            return true;
        }
        return false;
    }

    static boolean isOnComputeEngine() {
        String osName = System.getProperty("os.name");
        if ("Linux".equals(osName)) {
            String cmd = "cat /sys/class/dmi/id/product_name";
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
                process.waitFor();
                String result = CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), "UTF-8"));
                return result.contains(GCE_PRODUCTION_NAME_PRIOR_2016) || result.contains(GCE_PRODUCTION_NAME_AFTER_2016);
            }
            catch (IOException | InterruptedException e) {
                return false;
            }
        }
        return false;
    }

    private ManagedChannel createSingleChannel() throws IOException {
        ManagedChannelBuilder builder;
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor(this.headerProvider.getHeaders());
        GrpcMetadataHandlerInterceptor metadataHandlerInterceptor = new GrpcMetadataHandlerInterceptor();
        int colon = this.endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalStateException("invalid endpoint - should have been validated: " + this.endpoint);
        }
        int port = Integer.parseInt(this.endpoint.substring(colon + 1));
        String serviceAddress = this.endpoint.substring(0, colon);
        if (this.isDirectPathEnabled(serviceAddress) && this.credentials instanceof ComputeEngineCredentials && InstantiatingGrpcChannelProvider.isOnComputeEngine()) {
            builder = ComputeEngineChannelBuilder.forAddress((String)serviceAddress, (int)port);
            builder.keepAliveTime(3600L, TimeUnit.SECONDS);
            builder.keepAliveTimeout(20L, TimeUnit.SECONDS);
            builder.defaultServiceConfig(this.directPathServiceConfig);
        } else {
            builder = ManagedChannelBuilder.forAddress((String)serviceAddress, (int)port);
        }
        builder = builder.disableServiceConfigLookUp().intercept(new ClientInterceptor[]{new GrpcChannelUUIDInterceptor()}).intercept(new ClientInterceptor[]{headerInterceptor}).intercept(new ClientInterceptor[]{metadataHandlerInterceptor}).userAgent(headerInterceptor.getUserAgentHeader()).executor(this.executor);
        if (this.maxInboundMetadataSize != null) {
            builder.maxInboundMetadataSize(this.maxInboundMetadataSize.intValue());
        }
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveTimeout != null) {
            builder.keepAliveTimeout(this.keepAliveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            builder.keepAliveWithoutCalls(this.keepAliveWithoutCalls.booleanValue());
        }
        if (this.interceptorProvider != null) {
            builder.intercept(this.interceptorProvider.getInterceptors());
        }
        if (this.channelConfigurator != null) {
            builder = (ManagedChannelBuilder)this.channelConfigurator.apply((Object)builder);
        }
        ManagedChannel managedChannel = builder.build();
        if (this.channelPrimer != null) {
            this.channelPrimer.primeChannel(managedChannel);
        }
        return managedChannel;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Boolean getKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
    public Integer getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static ImmutableMap<String, ?> getDefaultDirectPathServiceConfig() {
        ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
        ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy));
        ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
        return ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
    }

    private static void validateEndpoint(String endpoint) {
        int colon = endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException(String.format("invalid endpoint, expecting \"<host>:<port>\"", new Object[0]));
        }
        Integer.parseInt(endpoint.substring(colon + 1));
    }

    static class DirectPathEnvironmentProvider
    implements EnvironmentProvider {
        private static DirectPathEnvironmentProvider provider;

        private DirectPathEnvironmentProvider() {
        }

        public static DirectPathEnvironmentProvider getInstance() {
            if (provider == null) {
                provider = new DirectPathEnvironmentProvider();
            }
            return provider;
        }

        @Override
        public String getenv(String env) {
            return System.getenv(env);
        }
    }

    static interface EnvironmentProvider {
        @Nullable
        public String getenv(String var1);
    }

    public static final class Builder {
        private int processorCount;
        private Executor executor;
        private HeaderProvider headerProvider;
        private String endpoint;
        private EnvironmentProvider envProvider;
        @Nullable
        private GrpcInterceptorProvider interceptorProvider;
        @Nullable
        private Integer maxInboundMessageSize;
        @Nullable
        private Integer maxInboundMetadataSize;
        @Nullable
        private Duration keepAliveTime;
        @Nullable
        private Duration keepAliveTimeout;
        @Nullable
        private Boolean keepAliveWithoutCalls;
        @Nullable
        private Integer poolSize;
        @Nullable
        private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
        @Nullable
        private Credentials credentials;
        @Nullable
        private ChannelPrimer channelPrimer;
        @Nullable
        private Boolean attemptDirectPath;
        @Nullable
        private ImmutableMap<String, ?> directPathServiceConfig;

        private Builder() {
            this.processorCount = Runtime.getRuntime().availableProcessors();
            this.envProvider = DirectPathEnvironmentProvider.getInstance();
        }

        private Builder(InstantiatingGrpcChannelProvider provider) {
            this.processorCount = provider.processorCount;
            this.executor = provider.executor;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
            this.envProvider = provider.envProvider;
            this.interceptorProvider = provider.interceptorProvider;
            this.maxInboundMessageSize = provider.maxInboundMessageSize;
            this.maxInboundMetadataSize = provider.maxInboundMetadataSize;
            this.keepAliveTime = provider.keepAliveTime;
            this.keepAliveTimeout = provider.keepAliveTimeout;
            this.keepAliveWithoutCalls = provider.keepAliveWithoutCalls;
            this.poolSize = provider.poolSize;
            this.channelConfigurator = provider.channelConfigurator;
            this.credentials = provider.credentials;
            this.channelPrimer = provider.channelPrimer;
            this.attemptDirectPath = provider.attemptDirectPath;
            this.directPathServiceConfig = provider.directPathServiceConfig;
        }

        Builder setProcessorCount(int processorCount) {
            this.processorCount = processorCount;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Deprecated
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            return this.setExecutor(executorProvider.getExecutor());
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
            this.endpoint = endpoint;
            return this;
        }

        public Builder setInterceptorProvider(GrpcInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setMaxInboundMessageSize(Integer max) {
            this.maxInboundMessageSize = max;
            return this;
        }

        public Integer getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Builder setMaxInboundMetadataSize(Integer max) {
            this.maxInboundMetadataSize = max;
            return this;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Integer getMaxInboundMetadataSize() {
            return this.maxInboundMetadataSize;
        }

        public Builder setKeepAliveTime(Duration duration) {
            this.keepAliveTime = duration;
            return this;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public Builder setKeepAliveTimeout(Duration duration) {
            this.keepAliveTimeout = duration;
            return this;
        }

        public Duration getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public Builder setKeepAliveWithoutCalls(Boolean keepalive) {
            this.keepAliveWithoutCalls = keepalive;
            return this;
        }

        public Boolean getKeepAliveWithoutCalls() {
            return this.keepAliveWithoutCalls;
        }

        public int getPoolSize() {
            if (this.poolSize == null) {
                return 1;
            }
            return this.poolSize;
        }

        public Builder setPoolSize(int poolSize) {
            Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Pool size must be positive");
            Preconditions.checkArgument((poolSize <= 1000 ? 1 : 0) != 0, (String)"Pool size must be less than %s", (int)1000);
            this.poolSize = poolSize;
            return this;
        }

        public Builder setChannelsPerCpu(double multiplier) {
            return this.setChannelsPerCpu(multiplier, 100);
        }

        public Builder setChannelsPerCpu(double multiplier, int maxChannels) {
            Preconditions.checkArgument((multiplier > 0.0 ? 1 : 0) != 0, (Object)"multiplier must be positive");
            Preconditions.checkArgument((maxChannels > 0 ? 1 : 0) != 0, (Object)"maxChannels must be positive");
            int channelCount = (int)Math.ceil((double)this.processorCount * multiplier);
            if (channelCount > maxChannels) {
                channelCount = maxChannels;
            }
            return this.setPoolSize(channelCount);
        }

        public Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setChannelPrimer(ChannelPrimer channelPrimer) {
            this.channelPrimer = channelPrimer;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setAttemptDirectPath(boolean attemptDirectPath) {
            this.attemptDirectPath = attemptDirectPath;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setDirectPathServiceConfig(Map<String, ?> serviceConfig) {
            Preconditions.checkNotNull(serviceConfig, (Object)"serviceConfig");
            this.directPathServiceConfig = ImmutableMap.copyOf(serviceConfig);
            return this;
        }

        public InstantiatingGrpcChannelProvider build() {
            return new InstantiatingGrpcChannelProvider(this);
        }

        @BetaApi(value="Surface for advanced channel configuration is not yet stable")
        public Builder setChannelConfigurator(@Nullable ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator) {
            this.channelConfigurator = channelConfigurator;
            return this;
        }

        @Nullable
        public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
            return this.channelConfigurator;
        }
    }
}

