/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.validation.BooleanOrPlaceholderValidator;
import com.xebialabs.deployit.booter.local.validation.ConvertingValidationRule;
import com.xebialabs.deployit.booter.local.validation.IntegerOrPlaceholderValidator;
import com.xebialabs.deployit.plugin.api.reflect.InputHint;
import com.xebialabs.deployit.plugin.api.reflect.InputHintValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class GeneratedDeployablePropertyDescriptor
extends LocalPropertyDescriptor {
    public GeneratedDeployablePropertyDescriptor(LocalDescriptor descriptor, PropertyDescriptor deployedPropertyDescriptor) {
        this.setName(deployedPropertyDescriptor.getName());
        this.setDeclaringDescriptor(descriptor);
        this.initMetadataFromDescriptor(deployedPropertyDescriptor);
    }

    private void initMetadataFromDescriptor(PropertyDescriptor propertyDescriptor) {
        this.setKind(propertyDescriptor.getKind().isSimple() ? PropertyKind.STRING : propertyDescriptor.getKind());
        this.setCategory(propertyDescriptor.getCategory());
        this.setLabel(propertyDescriptor.getLabel());
        this.setRequired(false);
        this.setPassword(propertyDescriptor.isPassword());
        this.setSize(propertyDescriptor.getSize());
        this.initDescription(propertyDescriptor);
        this.setInputHint(this.createInputHint(propertyDescriptor));
    }

    private void initDescription(PropertyDescriptor propertyDescriptor) {
        Object description = String.format("%s (%s)", propertyDescriptor.getDescription(), propertyDescriptor.getKind().name().toLowerCase());
        if (propertyDescriptor.getKind() == PropertyKind.ENUM) {
            description = (String)description + String.format(" values(%s)", String.join((CharSequence)", ", propertyDescriptor.getEnumValues()));
        }
        if (propertyDescriptor.getKind().isSimple() && propertyDescriptor.getDefaultValue() != null) {
            description = (String)description + String.format(" default(%s)", propertyDescriptor.getDefaultValue());
        }
        this.setDescription((String)description);
    }

    private InputHint createInputHint(PropertyDescriptor propertyDescriptor) {
        return new InputHint.InputHintBuilder().construct($ -> {
            $.kind = propertyDescriptor.getKind();
            $.required = propertyDescriptor.isRequired();
            $.values.addAll(this.getEnumValues(propertyDescriptor));
            $.validationRules = this.getValidationRules(propertyDescriptor);
            $.prompt = this.getPrompt(propertyDescriptor.getInputHint());
            $.copyFromProperty = this.getCopyFromProperty(propertyDescriptor.getInputHint());
            $.referencedType = this.getInputHintReferencedType(propertyDescriptor.getInputHint());
            $.methodRef = this.getMethodRef(propertyDescriptor.getInputHint());
            $.dynamicLookup = this.isDynamicLookup(propertyDescriptor.getInputHint());
        }).constructInputHint();
    }

    private List<InputHintValue> getEnumValues(PropertyDescriptor propertyDescriptor) {
        ArrayList<InputHintValue> inputHintValues = new ArrayList<InputHintValue>();
        List enumValues = propertyDescriptor.getEnumValues();
        if (enumValues != null) {
            inputHintValues.addAll(enumValues.stream().map(value -> InputHintValue.inputHintValue((String)value, (String)value)).collect(Collectors.toList()));
        }
        if (propertyDescriptor.getInputHint() != null && propertyDescriptor.getInputHint().getValues() != null) {
            inputHintValues.addAll(propertyDescriptor.getInputHint().getValues());
        }
        return inputHintValues;
    }

    private String getPrompt(InputHint inputHint) {
        if (inputHint != null) {
            return inputHint.getPrompt();
        }
        return null;
    }

    private Type getInputHintReferencedType(InputHint inputHint) {
        if (inputHint != null) {
            return inputHint.getReferencedType();
        }
        return null;
    }

    private String getMethodRef(InputHint inputHint) {
        if (inputHint != null) {
            return inputHint.getMethodRef();
        }
        return null;
    }

    private boolean isDynamicLookup(InputHint inputHint) {
        if (inputHint != null) {
            return inputHint.isDynamicLookup();
        }
        return true;
    }

    private String getCopyFromProperty(InputHint inputHint) {
        if (inputHint != null) {
            return inputHint.getCopyFromProperty();
        }
        return null;
    }

    private Set<Validator<?>> getValidationRules(PropertyDescriptor propertyDescriptor) {
        HashSet validationRules = new HashSet();
        if (propertyDescriptor instanceof LocalPropertyDescriptor) {
            LocalPropertyDescriptor localPropertyDescriptor = (LocalPropertyDescriptor)propertyDescriptor;
            if (localPropertyDescriptor.getKind().isSimple()) {
                for (Validator<?> v : localPropertyDescriptor.validationRules) {
                    validationRules.add(new ConvertingValidationRule(v, localPropertyDescriptor.createConverter()));
                }
            } else {
                validationRules.addAll(localPropertyDescriptor.validationRules);
            }
            if (propertyDescriptor.getInputHint() != null && propertyDescriptor.getInputHint().getValidationRules() != null) {
                validationRules.addAll(propertyDescriptor.getInputHint().getValidationRules());
            }
            this.addPropertyKindValiationRule(propertyDescriptor.getKind(), validationRules);
        }
        return validationRules;
    }

    private void addPropertyKindValiationRule(PropertyKind propertyKind, Set<Validator<?>> validators) {
        switch (propertyKind) {
            case BOOLEAN: {
                validators.add(new BooleanOrPlaceholderValidator());
                break;
            }
            case INTEGER: {
                validators.add(new IntegerOrPlaceholderValidator());
            }
        }
    }

    public Object get(ConfigurationItem item) {
        return this.getDeclaringDescriptor().getSyntheticPropertyValue(item, this.getName());
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        this.getDeclaringDescriptor().setSyntheticPropertyValue(item, this.getName(), value);
    }
}

