/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.Diff;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.InternalUtils;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.NodeType;
import com.flipkart.zjsonpatch.Operation;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;

public final class JsonDiff {
    private final List<Diff> diffs = new ArrayList<Diff>();
    private final EnumSet<DiffFlags> flags;

    private JsonDiff(EnumSet<DiffFlags> flags) {
        this.flags = flags.clone();
    }

    public static JsonNode asJson(JsonNode source, JsonNode target) {
        return JsonDiff.asJson(source, target, DiffFlags.defaults());
    }

    public static JsonNode asJson(JsonNode source, JsonNode target, EnumSet<DiffFlags> flags) {
        JsonDiff diff = new JsonDiff(flags);
        diff.generateDiffs(JsonPointer.ROOT, source, target);
        if (!flags.contains((Object)DiffFlags.OMIT_MOVE_OPERATION)) {
            diff.introduceMoveOperation();
        }
        if (!flags.contains((Object)DiffFlags.OMIT_COPY_OPERATION)) {
            diff.introduceCopyOperation(source, target);
        }
        return diff.getJsonNodes();
    }

    private static JsonPointer getMatchingValuePath(Map<JsonNode, JsonPointer> unchangedValues, JsonNode value) {
        return unchangedValues.get(value);
    }

    private void introduceCopyOperation(JsonNode source, JsonNode target) {
        Map<JsonNode, JsonPointer> unchangedValues = JsonDiff.getUnchangedPart(source, target);
        for (int i = 0; i < this.diffs.size(); ++i) {
            JsonPointer matchingValuePath;
            Diff diff = this.diffs.get(i);
            if (Operation.ADD != diff.getOperation() || (matchingValuePath = JsonDiff.getMatchingValuePath(unchangedValues, diff.getValue())) == null || !JsonDiff.isAllowed(matchingValuePath, diff.getPath())) continue;
            if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                this.diffs.add(i, new Diff(Operation.TEST, matchingValuePath, diff.getValue()));
                ++i;
            }
            this.diffs.set(i, new Diff(Operation.COPY, matchingValuePath, diff.getPath()));
        }
    }

    private static boolean isNumber(String str) {
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return size > 0;
    }

    private static boolean isAllowed(JsonPointer source, JsonPointer destination) {
        boolean isSame = source.equals(destination);
        int i = 0;
        for (int j = 0; i < source.size() && j < destination.size(); ++i, ++j) {
            JsonPointer.RefToken srcValue = source.get(i);
            JsonPointer.RefToken dstValue = destination.get(j);
            String srcStr = srcValue.toString();
            String dstStr = dstValue.toString();
            if (!JsonDiff.isNumber(srcStr) || !JsonDiff.isNumber(dstStr) || srcStr.compareTo(dstStr) <= 0) continue;
            return false;
        }
        return !isSame;
    }

    private static Map<JsonNode, JsonPointer> getUnchangedPart(JsonNode source, JsonNode target) {
        HashMap<JsonNode, JsonPointer> unchangedValues = new HashMap<JsonNode, JsonPointer>();
        JsonDiff.computeUnchangedValues(unchangedValues, JsonPointer.ROOT, source, target);
        return unchangedValues;
    }

    private static void computeUnchangedValues(Map<JsonNode, JsonPointer> unchangedValues, JsonPointer path, JsonNode source, JsonNode target) {
        NodeType secondType;
        if (source.equals((Object)target)) {
            if (!unchangedValues.containsKey(target)) {
                unchangedValues.put(target, path);
            }
            return;
        }
        NodeType firstType = NodeType.getNodeType(source);
        if (firstType == (secondType = NodeType.getNodeType(target))) {
            switch (firstType) {
                case OBJECT: {
                    JsonDiff.computeObject(unchangedValues, path, source, target);
                    break;
                }
                case ARRAY: {
                    JsonDiff.computeArray(unchangedValues, path, source, target);
                    break;
                }
            }
        }
    }

    private static void computeArray(Map<JsonNode, JsonPointer> unchangedValues, JsonPointer path, JsonNode source, JsonNode target) {
        int size = Math.min(source.size(), target.size());
        for (int i = 0; i < size; ++i) {
            JsonPointer currPath = path.append(i);
            JsonDiff.computeUnchangedValues(unchangedValues, currPath, source.get(i), target.get(i));
        }
    }

    private static void computeObject(Map<JsonNode, JsonPointer> unchangedValues, JsonPointer path, JsonNode source, JsonNode target) {
        Iterator firstFields = source.fieldNames();
        while (firstFields.hasNext()) {
            String name = (String)firstFields.next();
            if (!target.has(name)) continue;
            JsonPointer currPath = path.append(name);
            JsonDiff.computeUnchangedValues(unchangedValues, currPath, source.get(name), target.get(name));
        }
    }

    private void introduceMoveOperation() {
        block0: for (int i = 0; i < this.diffs.size(); ++i) {
            Diff diff1 = this.diffs.get(i);
            if (Operation.REMOVE != diff1.getOperation() && Operation.ADD != diff1.getOperation()) continue;
            for (int j = i + 1; j < this.diffs.size(); ++j) {
                JsonPointer relativePath;
                Diff diff2 = this.diffs.get(j);
                if (!diff1.getValue().equals((Object)diff2.getValue())) continue;
                Diff moveDiff = null;
                if (Operation.REMOVE == diff1.getOperation() && Operation.ADD == diff2.getOperation()) {
                    relativePath = JsonDiff.computeRelativePath(diff2.getPath(), i + 1, j - 1, this.diffs);
                    moveDiff = new Diff(Operation.MOVE, diff1.getPath(), relativePath);
                } else if (Operation.ADD == diff1.getOperation() && Operation.REMOVE == diff2.getOperation()) {
                    relativePath = JsonDiff.computeRelativePath(diff2.getPath(), i, j - 1, this.diffs);
                    moveDiff = new Diff(Operation.MOVE, relativePath, diff1.getPath());
                }
                if (moveDiff == null) continue;
                this.diffs.remove(j);
                this.diffs.set(i, moveDiff);
                continue block0;
            }
        }
    }

    private static JsonPointer computeRelativePath(JsonPointer path, int startIdx, int endIdx, List<Diff> diffs) {
        int i;
        ArrayList<Integer> counters = new ArrayList<Integer>(path.size());
        for (i = 0; i < path.size(); ++i) {
            counters.add(0);
        }
        for (i = startIdx; i <= endIdx; ++i) {
            Diff diff = diffs.get(i);
            if (Operation.ADD != diff.getOperation() && Operation.REMOVE != diff.getOperation()) continue;
            JsonDiff.updatePath(path, diff, counters);
        }
        return JsonDiff.updatePathWithCounters(counters, path);
    }

    private static JsonPointer updatePathWithCounters(List<Integer> counters, JsonPointer path) {
        List<JsonPointer.RefToken> tokens = path.decompose();
        for (int i = 0; i < counters.size(); ++i) {
            int value = counters.get(i);
            if (value == 0) continue;
            int currValue = tokens.get(i).getIndex();
            tokens.set(i, new JsonPointer.RefToken(Integer.toString(currValue + value)));
        }
        return new JsonPointer(tokens);
    }

    private static void updatePath(JsonPointer path, Diff pseudo, List<Integer> counters) {
        if (pseudo.getPath().size() <= path.size()) {
            int idx = -1;
            int i = 0;
            while (i < pseudo.getPath().size() - 1 && pseudo.getPath().get(i).equals(path.get(i))) {
                idx = i++;
            }
            if (idx == pseudo.getPath().size() - 2 && pseudo.getPath().get(pseudo.getPath().size() - 1).isArrayIndex()) {
                JsonDiff.updateCounters(pseudo, pseudo.getPath().size() - 1, counters);
            }
        }
    }

    private static void updateCounters(Diff pseudo, int idx, List<Integer> counters) {
        if (Operation.ADD == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) - 1);
        } else if (Operation.REMOVE == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) + 1);
        }
    }

    private ArrayNode getJsonNodes() {
        JsonNodeFactory FACTORY = JsonNodeFactory.instance;
        ArrayNode patch = FACTORY.arrayNode();
        for (Diff diff : this.diffs) {
            ObjectNode jsonNode = JsonDiff.getJsonNode(FACTORY, diff, this.flags);
            patch.add((JsonNode)jsonNode);
        }
        return patch;
    }

    private static ObjectNode getJsonNode(JsonNodeFactory FACTORY, Diff diff, EnumSet<DiffFlags> flags) {
        ObjectNode jsonNode = FACTORY.objectNode();
        jsonNode.put("op", diff.getOperation().rfcName());
        switch (diff.getOperation()) {
            case MOVE: 
            case COPY: {
                jsonNode.put("from", diff.getPath().toString());
                jsonNode.put("path", diff.getToPath().toString());
                break;
            }
            case REMOVE: {
                jsonNode.put("path", diff.getPath().toString());
                if (flags.contains((Object)DiffFlags.OMIT_VALUE_ON_REMOVE)) break;
                jsonNode.set("value", diff.getValue());
                break;
            }
            case REPLACE: {
                if (flags.contains((Object)DiffFlags.ADD_ORIGINAL_VALUE_ON_REPLACE)) {
                    jsonNode.set("fromValue", diff.getSrcValue());
                }
            }
            case ADD: 
            case TEST: {
                jsonNode.put("path", diff.getPath().toString());
                jsonNode.set("value", diff.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation specified:" + (Object)((Object)diff.getOperation()));
            }
        }
        return jsonNode;
    }

    private void generateDiffs(JsonPointer path, JsonNode source, JsonNode target) {
        if (!source.equals((Object)target)) {
            NodeType sourceType = NodeType.getNodeType(source);
            NodeType targetType = NodeType.getNodeType(target);
            if (sourceType == NodeType.ARRAY && targetType == NodeType.ARRAY) {
                this.compareArray(path, source, target);
            } else if (sourceType == NodeType.OBJECT && targetType == NodeType.OBJECT) {
                this.compareObjects(path, source, target);
            } else {
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, path, source));
                }
                this.diffs.add(Diff.generateDiff(Operation.REPLACE, path, source, target));
            }
        }
    }

    private void compareArray(JsonPointer path, JsonNode source, JsonNode target) {
        List<JsonNode> lcs = JsonDiff.getLCS(source, target);
        int srcIdx = 0;
        int targetIdx = 0;
        int lcsIdx = 0;
        int srcSize = source.size();
        int targetSize = target.size();
        int lcsSize = lcs.size();
        int pos = 0;
        while (lcsIdx < lcsSize) {
            JsonPointer currPath;
            JsonNode lcsNode = lcs.get(lcsIdx);
            JsonNode srcNode = source.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            if (lcsNode.equals((Object)srcNode) && lcsNode.equals((Object)targetNode)) {
                ++srcIdx;
                ++targetIdx;
                ++lcsIdx;
                ++pos;
                continue;
            }
            if (lcsNode.equals((Object)srcNode)) {
                currPath = path.append(pos);
                this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, targetNode));
                ++pos;
                ++targetIdx;
                continue;
            }
            if (lcsNode.equals((Object)targetNode)) {
                currPath = path.append(pos);
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, currPath, srcNode));
                }
                this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, srcNode));
                ++srcIdx;
                continue;
            }
            currPath = path.append(pos);
            this.generateDiffs(currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        while (srcIdx < srcSize && targetIdx < targetSize) {
            JsonNode srcNode = source.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            JsonPointer currPath = path.append(pos);
            this.generateDiffs(currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        pos = this.addRemaining(path, target, pos, targetIdx, targetSize);
        this.removeRemaining(path, pos, srcIdx, srcSize, source);
    }

    private void removeRemaining(JsonPointer path, int pos, int srcIdx, int srcSize, JsonNode source) {
        while (srcIdx < srcSize) {
            JsonPointer currPath = path.append(pos);
            if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                this.diffs.add(new Diff(Operation.TEST, currPath, source.get(srcIdx)));
            }
            this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source.get(srcIdx)));
            ++srcIdx;
        }
    }

    private int addRemaining(JsonPointer path, JsonNode target, int pos, int targetIdx, int targetSize) {
        while (targetIdx < targetSize) {
            JsonNode jsonNode = target.get(targetIdx);
            JsonPointer currPath = path.append(pos);
            this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, jsonNode.deepCopy()));
            ++pos;
            ++targetIdx;
        }
        return pos;
    }

    private void compareObjects(JsonPointer path, JsonNode source, JsonNode target) {
        Iterator keysFromSrc = source.fieldNames();
        while (keysFromSrc.hasNext()) {
            JsonPointer currPath;
            String key = (String)keysFromSrc.next();
            if (!target.has(key)) {
                currPath = path.append(key);
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, currPath, source.get(key)));
                }
                this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source.get(key)));
                continue;
            }
            currPath = path.append(key);
            this.generateDiffs(currPath, source.get(key), target.get(key));
        }
        Iterator keysFromTarget = target.fieldNames();
        while (keysFromTarget.hasNext()) {
            String key = (String)keysFromTarget.next();
            if (source.has(key)) continue;
            JsonPointer currPath = path.append(key);
            this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, target.get(key)));
        }
    }

    private static List<JsonNode> getLCS(JsonNode first, JsonNode second) {
        return ListUtils.longestCommonSubsequence(InternalUtils.toList((ArrayNode)first), InternalUtils.toList((ArrayNode)second));
    }
}

