/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.GlobalPermission;
import ai.digital.deploy.permissions.model.GlobalPermission$;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.RolePrincipal;
import ai.digital.deploy.permissions.repository.GlobalPermissionRepository;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001B\n\u0015\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003<\u0001\u0011\u0005A\bC\u0003C\u0001\u0011\u00053\tC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0003m\u0001\u0011\u0005S\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0003v\u0001\u0011\u0005c\u0010\u0003\u0004v\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA*\u0001\u0011\u0005\u0013Q\r\u0002\u001c\u000f2|'-\u00197QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005U1\u0012\u0001B5na2T!a\u0006\r\u0002\u000fM,'O^5dK*\u0011\u0011DG\u0001\fa\u0016\u0014X.[:tS>t7O\u0003\u0002\u001c9\u00051A-\u001a9m_fT!!\b\u0010\u0002\u000f\u0011Lw-\u001b;bY*\tq$\u0001\u0002bS\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0016\u000e\u0003YI!a\u000b\f\u0003/\u001dcwNY1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017AG4m_\n\fG\u000eU3s[&\u001c8/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0019\u0003)\u0011X\r]8tSR|'/_\u0005\u0003e=\u0012!d\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8SKB|7/\u001b;pef\f1B]8mKN+'O^5dKB\u0011\u0011&N\u0005\u0003mY\u00111BU8mKN+'O^5dK\u0006!\"o\u001c7f!JLgnY5qC2\u001cVM\u001d<jG\u0016\u0004\"!K\u001d\n\u0005i2\"\u0001\u0006*pY\u0016\u0004&/\u001b8dSB\fGnU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005{}\u0002\u0015\t\u0005\u0002?\u00015\tA\u0003C\u0003-\t\u0001\u0007Q\u0006C\u00034\t\u0001\u0007A\u0007C\u00038\t\u0001\u0007\u0001(A\u0002bI\u0012$2\u0001\u0012/g!\u0011\u0019SiR'\n\u0005\u0019##A\u0002+va2,'\u0007\u0005\u0002I\u00176\t\u0011J\u0003\u0002K1\u0005)Qn\u001c3fY&\u0011A*\u0013\u0002\u0005%>dW\rE\u0002O-fs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005I\u0003\u0013A\u0002\u001fs_>$h(C\u0001&\u0013\t)F%A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&\u0001\u0002'jgRT!!\u0016\u0013\u0011\u0005!S\u0016BA.J\u0005A9En\u001c2bYB+'/\\5tg&|g\u000eC\u0003^\u000b\u0001\u0007a,\u0001\u0005s_2,g*Y7f!\ty6M\u0004\u0002aCB\u0011\u0001\u000bJ\u0005\u0003E\u0012\na\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!\r\n\u0005\u00063\u0015\u0001\ra\u001a\t\u0004\u001dZs\u0016A\u0002:f[>4X\rF\u0002EU.DQ!\u0018\u0004A\u0002yCQ!\u0007\u0004A\u0002\u001d\fQB]3n_Z,gi\u001c:S_2,GC\u00018r!\t\u0019s.\u0003\u0002qI\t!QK\\5u\u0011\u0015\u0011x\u00011\u0001H\u0003\u0011\u0011x\u000e\\3\u0002\u0013I,Wn\u001c<f\u00032dG#\u00018\u0002\tI,\u0017\r\u001a\u000b\u0002\u001b\"\u0012\u0011\u0002\u001f\t\u0003srl\u0011A\u001f\u0006\u0003wb\t1A\u001b9b\u0013\ti(P\u0001\u0014SK\u0006$wJ\u001c7z)J\fgn]1di&|g.\u00197QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016$\"!T@\t\u000buS\u0001\u0019\u00010)\u0005)AHcA'\u0002\u0006!1\u0011qA\u0006A\u0002\u001d\f\u0011B]8mK:\u000bW.Z:)\u0005-A\u0018!\u0005:fC\u0012\u0014\u0015PU8mKB\u000bG\u000f^3s]R\u0019Q*a\u0004\t\r\u0005EA\u00021\u0001_\u0003-\u0011x\u000e\\3QCR$XM\u001d8)\u00051A\u0018\u0001B3eSR$r\u0001RA\r\u00037\ty\u0002C\u0003^\u001b\u0001\u0007a\f\u0003\u0004\u0002\u001e5\u0001\raZ\u0001\u0011a\u0016\u0014X.[:tS>t7\u000fV8BI\u0012Da!!\t\u000e\u0001\u00049\u0017a\u00059fe6L7o]5p]N$v\u000eR3mKR,\u0017aB4fiJ{G.\u001a\u000b\u0004\u000f\u0006\u001d\u0002\"B/\u000f\u0001\u0004q\u0016!H4fi\u001ecwNY1m!\u0016\u0014X.[:tS>t7OR8s%>dW-\u00133\u0015\u0007\u001d\fi\u0003C\u0004\u00020=\u0001\r!!\r\u0002\rI|G.Z%e!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA!\u001e;jY*\u0011\u00111H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002@\u0005U\"\u0001B+V\u0013\u0012C#a\u0004=\u0002A\u001d,Go\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8t\r>\u0014\bK]5oG&\u0004\u0018\r\u001c\u000b\u0005\u0003\u000f\ni\u0005\u0005\u0003`\u0003\u0013r\u0016bAA&K\n\u00191+\u001a;\t\r\u0005=\u0003\u00031\u0001_\u0003%\u0001(/\u001b8dSB\fG\u000e\u000b\u0002\u0011q\u0006y1\r[3dWB+'/\\5tg&|g\u000e\u0006\u0004\u0002X\u0005u\u0013q\f\t\u0004G\u0005e\u0013bAA.I\t9!i\\8mK\u0006t\u0007\"B\r\u0012\u0001\u00049\u0007BBA1#\u0001\u0007q-\u0001\u0005bY2\u0014v\u000e\\3tQ\t\t\u0002\u0010\u0006\u0005\u0002X\u0005\u001d\u0014\u0011NA6\u0011\u0015I\"\u00031\u0001h\u0011\u0019\t\tG\u0005a\u0001O\"1\u0011Q\u000e\nA\u0002\u001d\f!\u0002\u001d:j]\u000eL\u0007/\u00197tQ\t\u0011\u0002\u0010K\u0002\u0001\u0003g\u00022!_A;\u0013\r\t9H\u001f\u0002\u001f)J\fgn]1di&|g.\u00197QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016D3\u0001AA>!\u0011\ti(a#\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\t))a\"\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!#\u0002\u0007=\u0014x-\u0003\u0003\u0002\u000e\u0006}$aB*feZL7-\u001a")
public class GlobalPermissionServiceImpl
implements GlobalPermissionService {
    private final GlobalPermissionRepository globalPermissionRepository;
    private final RoleService roleService;
    private final RolePrincipalService rolePrincipalService;

    @Override
    public Tuple2<Role, List<GlobalPermission>> add(String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        Tuple2 tuple2 = this.globalPermissionRepository.get(role).partition((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)gp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List exists = (List)tuple2._1();
        List toDelete = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exists, (Object)toDelete);
        Tuple2 tuple23 = tuple22;
        List exists2 = (List)tuple23._1();
        List toDelete2 = (List)tuple23._2();
        List toSave = permissions.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)GlobalPermissionServiceImpl.$anonfun$add$2(exists2, p))).map((Function1 & Serializable)p -> GlobalPermission$.MODULE$.apply(role, (String)p));
        this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
        return new Tuple2((Object)role, exists2.$plus$plus(this.globalPermissionRepository.add((List<GlobalPermission>)toSave)));
    }

    @Override
    public Tuple2<Role, List<GlobalPermission>> remove(String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        Tuple2 tuple2 = this.globalPermissionRepository.get(role).partition((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)gp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List gp2 = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)gp2);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List gp3 = (List)tuple23._2();
        this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
        return new Tuple2((Object)role, (Object)gp3);
    }

    @Override
    public void removeForRole(Role role) {
        this.globalPermissionRepository.removeForRole(role);
    }

    @Override
    public void removeAll() {
        this.globalPermissionRepository.removeAll();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> read() {
        return this.globalPermissionRepository.get();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> read(String roleName) {
        return this.globalPermissionRepository.get(roleName);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> read(List<String> roleNames) {
        return this.globalPermissionRepository.get(roleNames);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> readByRolePattern(String rolePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(rolePattern, (Function1 & Serializable)p -> $this.globalPermissionRepository.listByRoleNamePattern((String)p), (Function0 & Serializable)() -> $this.globalPermissionRepository.get());
    }

    @Override
    public Tuple2<Role, List<GlobalPermission>> edit(String roleName, List<String> permissionsToAdd, List<String> permissionsToDelete) {
        Role role = this.getRole(roleName);
        List<GlobalPermission> permissions = this.globalPermissionRepository.get(role);
        Tuple2 tuple2 = permissions.partition((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)permissionsToDelete.contains((Object)p.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List exists = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)exists);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List exists2 = (List)tuple23._2();
        this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
        List toAdd = permissionsToAdd.map((Function1 & Serializable)p -> GlobalPermission$.MODULE$.apply(role, (String)p));
        return new Tuple2((Object)role, exists2.$plus$plus(this.globalPermissionRepository.add((List<GlobalPermission>)toAdd)));
    }

    /*
     * WARNING - void declaration
     */
    private Role getRole(String roleName) {
        void var2_2;
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        return var2_2;
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<String> getGlobalPermissionsForRoleId(UUID roleId) {
        List<GlobalPermission> permissions = this.globalPermissionRepository.get(roleId);
        return permissions.map((Function1 & Serializable)x$5 -> x$5.permissionName());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<String> getGlobalPermissionsForPrincipal(String principal) {
        List<RolePrincipal> result = this.rolePrincipalService.read(principal);
        List roles = result.map((Function1 & Serializable)x$6 -> x$6.role().name());
        return this.globalPermissionRepository.get((List<String>)roles).map((Function1 & Serializable)data -> data.permissionName()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(List<String> permissions, List<String> allRoles) {
        return this.globalPermissionRepository.getByPermissionsAndRoles(permissions, (Set<String>)allRoles.toSet()).nonEmpty();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(List<String> permissions, List<String> allRoles, List<String> principals) {
        Set principalRoleIds = this.rolePrincipalService.readAll(principals).map((Function1 & Serializable)x$7 -> x$7.role().name()).toSet();
        return this.globalPermissionRepository.getByPermissionsAndRoles(permissions, (Set<String>)((Set)principalRoleIds.$plus$plus(allRoles))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$add$2(List exists$1, String p) {
        return exists$1.map((Function1 & Serializable)x$2 -> x$2.permissionName()).contains((Object)p);
    }

    public GlobalPermissionServiceImpl(GlobalPermissionRepository globalPermissionRepository, RoleService roleService, RolePrincipalService rolePrincipalService) {
        this.globalPermissionRepository = globalPermissionRepository;
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
    }
}

