/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AwsIamAuthentication;
import org.springframework.vault.authentication.AwsIamAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.web.client.RestOperations;

public class AwsIamClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public AwsIamClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.AWS_IAM);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        this.assertClassPresent("com.amazonaws.auth.AWSCredentials", this.missingClassForAuthMethod("AWSCredentials", "aws-java-sdk-core", VaultEnvironmentProperties.AuthenticationMethod.AWS_IAM));
        VaultEnvironmentProperties.AwsIamProperties awsIam = vaultProperties.getAwsIam();
        AWSCredentialsProvider credentialsProvider = AwsCredentialProvider.getAwsCredentialsProvider();
        AwsIamAuthenticationOptions.AwsIamAuthenticationOptionsBuilder builder = AwsIamAuthenticationOptions.builder();
        if (StringUtils.hasText((String)awsIam.getRole())) {
            builder.role(awsIam.getRole());
        }
        if (StringUtils.hasText((String)awsIam.getServerName())) {
            builder.serverName(awsIam.getServerName());
        }
        if (awsIam.getEndpointUri() != null) {
            builder.endpointUri(awsIam.getEndpointUri());
        }
        builder.path(awsIam.getAwsPath()).credentialsProvider(credentialsProvider);
        AwsIamAuthenticationOptions options = builder.credentialsProvider(credentialsProvider).build();
        return new AwsIamAuthentication(options, vaultRestOperations);
    }

    private static class AwsCredentialProvider {
        private AwsCredentialProvider() {
        }

        private static AWSCredentialsProvider getAwsCredentialsProvider() {
            final DefaultAWSCredentialsProviderChain backingCredentialsProvider = DefaultAWSCredentialsProviderChain.getInstance();
            final AWSCredentials firstAccess = backingCredentialsProvider.getCredentials();
            final AtomicReference<AWSCredentials> once = new AtomicReference<AWSCredentials>(firstAccess);
            return new AWSCredentialsProvider(){

                public AWSCredentials getCredentials() {
                    if (once.compareAndSet(firstAccess, null)) {
                        return firstAccess;
                    }
                    return backingCredentialsProvider.getCredentials();
                }

                public void refresh() {
                    backingCredentialsProvider.refresh();
                }
            };
        }
    }
}

