/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Filter;
import org.jboss.logmanager.ConfigurationLocator;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.DefaultConfigurationLocator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogLevelInitTask;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.StandardOutputStreams;

public final class LogManager
extends java.util.logging.LogManager {
    public static final String PER_THREAD_LOG_FILTER_KEY = "org.jboss.logmanager.useThreadLocalFilter";
    static final boolean PER_THREAD_LOG_FILTER;
    private final AtomicBoolean configured = new AtomicBoolean();

    public LogManager() {
        AccessController.doPrivileged(new LogLevelInitTask());
    }

    private static String tryGetProperty(String name, String defaultVal) {
        try {
            return System.getProperty(name, defaultVal);
        }
        catch (Throwable t) {
            return defaultVal;
        }
    }

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        InputStream configuration;
        this.checkAccess();
        if (this.configured.getAndSet(true)) {
            return;
        }
        String confLocClassName = LogManager.tryGetProperty("org.jboss.logmanager.configurationLocator", null);
        ConfigurationLocator locator = null;
        if (confLocClassName != null) {
            locator = LogManager.construct(ConfigurationLocator.class, confLocClassName);
        } else {
            ServiceLoader<ConfigurationLocator> loader;
            Iterator<ConfigurationLocator> iterator;
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null && (iterator = (loader = ServiceLoader.load(ConfigurationLocator.class, tccl)).iterator()).hasNext()) {
                locator = iterator.next();
            }
            if (locator == null) {
                loader = ServiceLoader.load(ConfigurationLocator.class, tccl != null ? tccl : LogManager.class.getClassLoader());
                iterator = loader.iterator();
                locator = iterator.hasNext() ? iterator.next() : new DefaultConfigurationLocator();
            }
        }
        if (locator != null && (configuration = locator.findConfiguration()) != null) {
            this.readConfiguration(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        try {
            this.checkAccess();
            this.configured.set(true);
            String confClassName = LogManager.tryGetProperty("org.jboss.logmanager.configurator", null);
            Configurator configurator = null;
            if (confClassName != null) {
                configurator = LogManager.construct(Configurator.class, confClassName);
            } else {
                ServiceLoader<Configurator> loader;
                Iterator<Configurator> iterator;
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl != null && (iterator = (loader = ServiceLoader.load(Configurator.class, tccl)).iterator()).hasNext()) {
                    configurator = iterator.next();
                }
                if (configurator == null) {
                    loader = ServiceLoader.load(Configurator.class, LogManager.class.getClassLoader());
                    iterator = loader.iterator();
                    configurator = iterator.hasNext() ? iterator.next() : new PropertyConfigurator();
                }
            }
            if (configurator != null) {
                try {
                    configurator.configure(inputStream);
                    LogContext.getSystemLogContext().getLogger("").attach(Configurator.ATTACHMENT_KEY, configurator);
                }
                catch (Throwable t) {
                    StandardOutputStreams.printError(t, "Failed to read or configure the org.jboss.logmanager.LogManager");
                }
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static <T> T construct(Class<? extends T> type, String className) throws IOException {
        try {
            Class<?> clazz = null;
            try {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl != null) {
                    clazz = Class.forName(className, true, tccl);
                }
            }
            catch (ClassNotFoundException tccl) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = Class.forName(className, true, LogManager.class.getClassLoader());
            }
            return type.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to load configuration class " + className);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void updateConfiguration(Function<String, BiFunction<String, String, String>> mapper) throws IOException {
    }

    @Override
    public void updateConfiguration(InputStream ins, Function<String, BiFunction<String, String, String>> mapper) throws IOException {
    }

    @Override
    public java.util.logging.LogManager addConfigurationListener(Runnable listener) {
        return this;
    }

    @Override
    public void removeConfigurationListener(Runnable listener) {
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return LogContext.getLogContext().getLoggerNames();
    }

    @Override
    public boolean addLogger(java.util.logging.Logger logger) {
        return false;
    }

    @Override
    public Logger getLogger(String name) {
        return LogContext.getLogContext().getLogger(name);
    }

    public static Filter getThreadLocalLogFilter() {
        return PER_THREAD_LOG_FILTER ? LocalFilterHolder.LOCAL_FILTER.get() : null;
    }

    public static void setThreadLocalLogLevel(Filter filter) {
        if (PER_THREAD_LOG_FILTER) {
            LocalFilterHolder.LOCAL_FILTER.set(filter);
        }
    }

    static {
        if (System.getSecurityManager() == null) {
            try {
                Class.forName(StandardOutputStreams.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            PER_THREAD_LOG_FILTER = Boolean.getBoolean(PER_THREAD_LOG_FILTER_KEY);
        } else {
            PER_THREAD_LOG_FILTER = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean(LogManager.PER_THREAD_LOG_FILTER_KEY);
                }
            });
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class.forName(StandardOutputStreams.class.getName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    private static class LocalFilterHolder {
        static final ThreadLocal<Filter> LOCAL_FILTER = new ThreadLocal();

        private LocalFilterHolder() {
        }
    }
}

