/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereFileDirectoryWalker;
import java.io.IOException;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OverthereFileTransmitter
extends OverthereFileDirectoryWalker {
    private static final String SOURCE = "Source";
    private static final String DESTINATION = "Destination";
    private Stack<OverthereFile> dstDirStack = new Stack();
    private OverthereFile srcDir;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected OverthereFileTransmitter() {
    }

    protected OverthereFileTransmitter(OverthereFile srcDir, OverthereFile dstDir) {
        this.dstDirStack.push(dstDir);
        this.srcDir = srcDir;
        this.checkDirectoryExists(srcDir, SOURCE);
    }

    @Override
    protected void handleDirectoryStart(OverthereFile scrDir, int depth) throws IOException {
        OverthereFile dstDir = this.getCurrentDestinationDir();
        if (depth != 0) {
            dstDir = this.createSubdirectoryAndMakeCurrent(dstDir, scrDir.getName());
        }
        if (dstDir.exists()) {
            this.checkReallyIsADirectory(dstDir, DESTINATION);
            this.logger.trace("About to copy files into existing directory {}", (Object)dstDir);
        } else {
            dstDir.mkdir();
        }
    }

    private OverthereFile createSubdirectoryAndMakeCurrent(OverthereFile parentDir, String subdirName) {
        OverthereFile subdir = parentDir.getFile(subdirName);
        this.dstDirStack.push(subdir);
        return subdir;
    }

    protected void startTransmission() {
        this.walk(this.srcDir);
    }

    private OverthereFile getCurrentDestinationDir() {
        return this.dstDirStack.peek();
    }

    @Override
    protected void handleFile(OverthereFile srcFile, int depth) throws IOException {
        OverthereFile dstFile = this.getCurrentDestinationDir().getFile(srcFile.getName());
        this.transmitFile(srcFile, dstFile);
    }

    protected abstract void transmitFile(OverthereFile var1, OverthereFile var2);

    @Override
    protected void handleDirectoryEnd(OverthereFile directory, int depth) throws IOException {
        if (depth != 0) {
            this.dstDirStack.pop();
        }
    }

    protected void checkReallyIsAFile(OverthereFile file, String fileDescription) {
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeIOException(fileDescription + " file " + file + " exists but is a directory");
        }
    }

    protected void checkDirectoryExists(OverthereFile dir, String dirDescription) {
        if (!dir.exists()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " does not exist");
        }
        this.checkReallyIsADirectory(dir, dirDescription);
    }

    protected void checkReallyIsADirectory(OverthereFile dir, String dirDescription) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " exists but is not a directory");
        }
    }

    protected void checkFileExists(OverthereFile file, String sourceDescription) {
        if (!file.exists()) {
            throw new RuntimeIOException(sourceDescription + " file " + file + " does not exist");
        }
        this.checkReallyIsAFile(file, sourceDescription);
    }
}

