/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationLargeMessageEndMessage
extends PacketImpl {
    long messageId;
    long pendingRecordId;
    private boolean isDelete;

    public ReplicationLargeMessageEndMessage() {
        super((byte)100);
    }

    public ReplicationLargeMessageEndMessage(long messageId, long pendingRecordId, boolean isDelete) {
        this();
        this.messageId = messageId;
        this.pendingRecordId = -pendingRecordId;
        this.isDelete = isDelete;
    }

    public int expectedEncodeSize() {
        return 30;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.messageId);
        buffer.writeLong(this.pendingRecordId);
        buffer.writeBoolean(this.isDelete);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.messageId = buffer.readLong();
        if (buffer.readableBytes() >= 8) {
            this.pendingRecordId = buffer.readLong();
        }
        if (buffer.readableBytes() >= 1) {
            this.isDelete = buffer.readBoolean();
        }
    }

    public long getMessageId() {
        return this.messageId;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isDelete ? 1231 : 1237);
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        return result;
    }

    public String toString() {
        return "ReplicationLargeMessageEndMessage{messageId=" + this.messageId + ", isDelete=" + this.isDelete + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplicationLargeMessageEndMessage other = (ReplicationLargeMessageEndMessage)((Object)obj);
        if (this.messageId != other.messageId) {
            return false;
        }
        return this.isDelete == other.isDelete;
    }

    public long getPendingRecordId() {
        return this.pendingRecordId;
    }

    public boolean isDelete() {
        return this.isDelete;
    }
}

