/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

class QueryTreeNodeVector<E extends QueryTreeNode>
extends QueryTreeNode
implements Iterable<E> {
    private final ArrayList<E> v = new ArrayList();
    final Class<E> eltClass;

    QueryTreeNodeVector(Class<E> clazz, ContextManager contextManager) {
        super(contextManager);
        this.eltClass = clazz;
    }

    public final int size() {
        return this.v.size();
    }

    final E elementAt(int n) {
        return (E)((QueryTreeNode)this.v.get(n));
    }

    void addElement(E e) {
        this.v.add(e);
    }

    final E removeElementAt(int n) {
        return (E)((QueryTreeNode)this.v.remove(n));
    }

    final void removeElement(E e) {
        this.v.remove(e);
    }

    final int indexOf(E e) {
        return this.v.indexOf(e);
    }

    final void setElementAt(E e, int n) {
        this.v.set(n, e);
    }

    final void destructiveAppend(QueryTreeNodeVector<E> queryTreeNodeVector) {
        this.nondestructiveAppend(queryTreeNodeVector);
        queryTreeNodeVector.removeAllElements();
    }

    final void nondestructiveAppend(QueryTreeNodeVector<E> queryTreeNodeVector) {
        this.v.addAll(queryTreeNodeVector.v);
    }

    final void removeAllElements() {
        this.v.clear();
    }

    final void insertElementAt(E e, int n) {
        this.v.add(n, e);
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Visitable visitable = ((QueryTreeNode)this.elementAt(i)).accept(visitor);
            this.setElementAt((QueryTreeNode)this.eltClass.cast(visitable), i);
        }
    }

    @Override
    public final Iterator<E> iterator() {
        return this.v.iterator();
    }
}

