/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.MutableListDataEvent;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultEventListModel<E>
implements ListEventListener<E>,
ListModel {
    protected EventList<E> source;
    private boolean disposeSource;
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    protected final MutableListDataEvent listDataEvent = new MutableListDataEvent(this);

    public DefaultEventListModel(EventList<E> source) {
        this(source, false);
    }

    public DefaultEventListModel(EventList<E> source, boolean disposeSource) {
        this.source = source;
        this.disposeSource = disposeSource;
        this.source.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Events to " + this.getClass().getSimpleName() + " must arrive on the EDT - consider adding GlazedListsSwing.swingThreadProxyList(source) somewhere in your list pipeline");
        }
        listChanges.nextBlock();
        int startIndex = listChanges.getBlockStartIndex();
        int endIndex = listChanges.getBlockEndIndex();
        this.listDataEvent.setRange(startIndex, endIndex);
        int changeType = listChanges.getType();
        switch (changeType) {
            case 2: {
                this.listDataEvent.setType(1);
                break;
            }
            case 0: {
                this.listDataEvent.setType(2);
                break;
            }
            case 1: {
                this.listDataEvent.setType(0);
            }
        }
        if (listChanges.nextBlock()) {
            this.listDataEvent.setRange(0, Integer.MAX_VALUE);
            this.listDataEvent.setType(0);
        }
        this.fireListDataEvent(this.listDataEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementAt(int index) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object e = this.source.get(index);
            return e;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n = this.source.size();
            return n;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    protected void fireListDataEvent(ListDataEvent listDataEvent) {
        int n = this.listeners.size();
        block5: for (int i = 0; i < n; ++i) {
            ListDataListener listDataListener = this.listeners.get(i);
            switch (listDataEvent.getType()) {
                case 0: {
                    listDataListener.contentsChanged(listDataEvent);
                    continue block5;
                }
                case 1: {
                    listDataListener.intervalAdded(listDataEvent);
                    continue block5;
                }
                case 2: {
                    listDataListener.intervalRemoved(listDataEvent);
                }
            }
        }
    }

    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
        this.source = null;
    }
}

