/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.uuid.UUID;

public class ItemStateBinding {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_CURRENT = 2;
    protected final StringIndex nsIndex;
    protected final StringIndex nameIndex;
    protected final BLOBStore blobStore;
    protected long minBlobSize = 16384L;
    protected final ErrorHandling errorHandling;
    protected final DataStore dataStore;

    public ItemStateBinding(ErrorHandling errorHandling, BLOBStore blobStore, StringIndex nsIndex, StringIndex nameIndex, DataStore dataStore) {
        this.errorHandling = errorHandling;
        this.nsIndex = nsIndex;
        this.nameIndex = nameIndex;
        this.blobStore = blobStore;
        this.dataStore = dataStore;
    }

    public long getMinBlobSize() {
        return this.minBlobSize;
    }

    public void setMinBlobSize(long minBlobSize) {
        this.minBlobSize = minBlobSize;
    }

    public BLOBStore getBlobStore() {
        return this.blobStore;
    }

    public NodeReferences readState(DataInputStream in, NodeReferencesId id, PersistenceManager pMgr) throws IOException {
        NodeReferences state = new NodeReferences(id);
        int count = in.readInt();
        count &= 0xFFFFFF;
        for (int i = 0; i < count; ++i) {
            state.addReference(this.readPropertyId(in));
        }
        return state;
    }

    public void writeState(DataOutputStream out, NodeReferences state) throws IOException {
        List c = state.getReferences();
        out.writeInt(c.size() | 0x2000000);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            PropertyId propId = (PropertyId)iter.next();
            this.writePropertyId(out, propId);
        }
    }

    public NodeState readState(DataInputStream in, NodeId id, PersistenceManager pMgr) throws IOException {
        int i;
        NodeState state = pMgr.createNew(id);
        int index = in.readInt();
        int version = index >> 24 & 0xFF;
        String uri = this.nsIndex.indexToString(index & 0xFFFFFF);
        String local = in.readUTF();
        state.setNodeTypeName(NameFactoryImpl.getInstance().create(uri, local));
        state.setParentId(this.readID(in));
        state.setDefinitionId(NodeDefId.valueOf(in.readUTF()));
        int count = in.readInt();
        HashSet<Name> set = new HashSet<Name>(count);
        for (i = 0; i < count; ++i) {
            set.add(this.readQName(in));
        }
        if (set.size() > 0) {
            state.setMixinTypeNames(set);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            state.addPropertyName(this.readIndexedQName(in));
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            Name name = this.readQName(in);
            NodeId parentId = this.readID(in);
            state.addChildNodeEntry(name, parentId);
        }
        if (version >= 1) {
            state.setModCount(this.readModCount(in));
        }
        if (version >= 2) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                state.addShare(this.readID(in));
            }
        }
        return state;
    }

    public void writeState(DataOutputStream out, NodeState state) throws IOException {
        out.writeInt(0x2000000 | this.nsIndex.stringToIndex(state.getNodeTypeName().getNamespaceURI()));
        out.writeUTF(state.getNodeTypeName().getLocalName());
        this.writeID(out, state.getParentId());
        out.writeUTF(state.getDefinitionId().toString());
        Collection c = state.getMixinTypeNames();
        out.writeInt(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.writeQName(out, (Name)iter.next());
        }
        c = state.getPropertyNames();
        out.writeInt(c.size());
        iter = c.iterator();
        while (iter.hasNext()) {
            Name pName = (Name)iter.next();
            this.writeIndexedQName(out, pName);
        }
        c = state.getChildNodeEntries();
        out.writeInt(c.size());
        iter = c.iterator();
        while (iter.hasNext()) {
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            this.writeQName(out, entry.getName());
            this.writeID(out, entry.getId());
        }
        this.writeModCount(out, state.getModCount());
        c = state.getSharedSet();
        out.writeInt(c.size());
        iter = c.iterator();
        while (iter.hasNext()) {
            this.writeID(out, (NodeId)iter.next());
        }
    }

    public UUID readUUID(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            byte[] bytes = new byte[16];
            in.readFully(bytes);
            return new UUID(bytes);
        }
        return null;
    }

    public void writeUUID(DataOutputStream out, String uuid) throws IOException {
        if (uuid == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.write(UUID.fromString(uuid).getRawBytes());
        }
    }

    public NodeId readID(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            byte[] bytes = new byte[16];
            for (int pos = 0; pos < 16; pos += in.read(bytes, pos, 16 - pos)) {
            }
            return new NodeId(new UUID(bytes));
        }
        return null;
    }

    public void writeID(DataOutputStream out, NodeId id) throws IOException {
        if (id == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.write(id.getUUID().getRawBytes());
        }
    }

    public void writeUUID(DataOutputStream out, UUID uuid) throws IOException {
        if (uuid == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.write(uuid.getRawBytes());
        }
    }

    public Name readQName(DataInputStream in) throws IOException {
        String uri = this.nsIndex.indexToString(in.readInt());
        String local = in.readUTF();
        return NameFactoryImpl.getInstance().create(uri, local);
    }

    public short readModCount(DataInputStream in) throws IOException {
        return in.readShort();
    }

    public void writeModCount(DataOutputStream out, short modCount) throws IOException {
        out.writeShort(modCount);
    }

    public void writeQName(DataOutputStream out, Name name) throws IOException {
        out.writeInt(this.nsIndex.stringToIndex(name.getNamespaceURI()));
        out.writeUTF(name.getLocalName());
    }

    public Name readIndexedQName(DataInputStream in) throws IOException {
        int index = in.readInt();
        if (index < 0) {
            return null;
        }
        String uri = this.nsIndex.indexToString(index);
        String local = this.nameIndex.indexToString(in.readInt());
        return NameFactoryImpl.getInstance().create(uri, local);
    }

    public void writeIndexedQName(DataOutputStream out, Name name) throws IOException {
        if (name == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.nsIndex.stringToIndex(name.getNamespaceURI()));
            out.writeInt(this.nameIndex.stringToIndex(name.getLocalName()));
        }
    }

    public void writePropertyId(DataOutputStream out, PropertyId id) throws IOException {
        this.writeID(out, id.getParentId());
        this.writeQName(out, id.getName());
    }

    public PropertyId readPropertyId(DataInputStream in) throws IOException {
        UUID uuid = this.readUUID(in);
        Name name = this.readQName(in);
        return new PropertyId(new NodeId(uuid), name);
    }
}

