/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.ReferencedPermission;
import ai.digital.deploy.permissions.model.ReferencedPermission$;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.view.RoleReferencedPermissionView;
import ai.digital.deploy.permissions.repository.ReferencedPermissionRepository;
import ai.digital.deploy.permissions.repository.RoleReferencedPermissionViewRepository;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001B\f\u0019\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u0011\u0011\u0004\u0001\u0005B\u0005}\u0001bBA\r\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u00033\u0001A\u0011IA\u0016\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002~\u0001!I!a \t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u00111\u0013\u0001\u0005B\u0005U\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\t)\u000b\u0001C!\u0003o\u0013qDU3gKJ,gnY3e!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\tI\"$\u0001\u0003j[Bd'BA\u000e\u001d\u0003\u001d\u0019XM\u001d<jG\u0016T!!\b\u0010\u0002\u0017A,'/\\5tg&|gn\u001d\u0006\u0003?\u0001\na\u0001Z3qY>L(BA\u0011#\u0003\u001d!\u0017nZ5uC2T\u0011aI\u0001\u0003C&\u001c\u0001aE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0017/\u001b\u0005Q\u0012BA\u0018\u001b\u0005m\u0011VMZ3sK:\u001cW\r\u001a)fe6L7o]5p]N+'O^5dK\u0006q\"/\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:\u0014V\r]8tSR|'/\u001f\t\u0003eUj\u0011a\r\u0006\u0003iq\t!B]3q_NLGo\u001c:z\u0013\t14G\u0001\u0010SK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006Y!o\u001c7f'\u0016\u0014h/[2f!\ti\u0013(\u0003\u0002;5\tY!k\u001c7f'\u0016\u0014h/[2f\u0003Q\u0011x\u000e\\3Qe&t7-\u001b9bYN+'O^5dKB\u0011Q&P\u0005\u0003}i\u0011ACU8mKB\u0013\u0018N\\2ja\u0006d7+\u001a:wS\u000e,\u0017A\n:pY\u0016\u0014VMZ3sK:\u001cW\r\u001a)fe6L7o]5p]ZKWm\u001e*fa>\u001c\u0018\u000e^8ssB\u0011!'Q\u0005\u0003\u0005N\u0012aEU8mKJ+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8o-&,wOU3q_NLGo\u001c:z\u0003\u0019a\u0014N\\5u}Q)Qi\u0012%J\u0015B\u0011a\tA\u0007\u00021!)\u0001'\u0002a\u0001c!)q'\u0002a\u0001q!)1(\u0002a\u0001y!)q(\u0002a\u0001\u0001\u0006\u0019\u0011\r\u001a3\u0015\t5+w.\u001f\t\u0005O9\u0003f+\u0003\u0002PQ\t1A+\u001e9mKJ\u0002\"!\u0015+\u000e\u0003IS!a\u0015\u000f\u0002\u000b5|G-\u001a7\n\u0005U\u0013&\u0001\u0002*pY\u0016\u00042aV0c\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\I\u00051AH]8pizJ\u0011!K\u0005\u0003=\"\nq\u0001]1dW\u0006<W-\u0003\u0002aC\n!A*[:u\u0015\tq\u0006\u0006\u0005\u0002RG&\u0011AM\u0015\u0002\u0015%\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8\t\u000b\u00194\u0001\u0019A4\u0002\u0017I,g-\u001a:f]\u000e,\u0017\n\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA!\u001e;jY*\tA.\u0001\u0003kCZ\f\u0017B\u00018j\u0005\u0011)V+\u0013#\t\u000bA4\u0001\u0019A9\u0002\u0011I|G.\u001a(b[\u0016\u0004\"A\u001d<\u000f\u0005M$\bCA-)\u0013\t)\b&\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;)\u0011\u0015ib\u00011\u0001{!\r9v,]\u0001\u0007e\u0016lwN^3\u0015\t5khp \u0005\u0006M\u001e\u0001\ra\u001a\u0005\u0006a\u001e\u0001\r!\u001d\u0005\u0006;\u001d\u0001\rA_\u0001\u000ee\u0016lwN^3G_J\u0014v\u000e\\3\u0015\t\u0005\u0015\u00111\u0002\t\u0004O\u0005\u001d\u0011bAA\u0005Q\t!QK\\5u\u0011\u0019\ti\u0001\u0003a\u0001!\u0006!!o\u001c7f\u0003I\u0011X-\\8wK\u001a{'OU3gKJ,gnY3\u0015\t\u0005\u0015\u00111\u0003\u0005\u0006M&\u0001\raZ\u0001\ne\u0016lwN^3BY2$\"!!\u0002\u0002\tI,\u0017\r\u001a\u000b\u0004-\u0006u\u0001\"\u00029\f\u0001\u0004\tHc\u0001,\u0002\"!1\u00111\u0005\u0007A\u0002i\f\u0011B]8mK:\u000bW.Z:\u0015\u000bY\u000b9#!\u000b\t\u000b\u0019l\u0001\u0019A4\t\u000bAl\u0001\u0019A9\u0015\u0011\u00055\u0012QKA,\u00037\u0002ba\n(\u00020\u0005\u001d\u0003#BA\u0019\u0003\u0007\u0002VBAA\u001a\u0015\u0011\t)$a\u000e\u0002\r\u0011|W.Y5o\u0015\u0011\tI$a\u000f\u0002\t\u0011\fG/\u0019\u0006\u0005\u0003{\ty$A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t\t%A\u0002pe\u001eLA!!\u0012\u00024\t!\u0001+Y4f!\u00119v,!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014S\u0003\u00111\u0018.Z<\n\t\u0005M\u0013Q\n\u0002\u001d%>dWMU3gKJ,gnY3e!\u0016\u0014X.[:tS>tg+[3x\u0011\u00151g\u00021\u0001h\u0011\u0019\tIF\u0004a\u0001c\u0006Y!o\u001c7f!\u0006$H/\u001a:o\u0011\u001d\tiF\u0004a\u0001\u0003?\n\u0001\u0002]1hK\u0006\u0014G.\u001a\t\u0005\u0003c\t\t'\u0003\u0003\u0002d\u0005M\"\u0001\u0003)bO\u0016\f'\r\\3\u0002%I,\u0017\r\u001a$peJ{G.\u001a)biR,'O\u001c\u000b\u0006-\u0006%\u00141\u000e\u0005\u0006M>\u0001\ra\u001a\u0005\u0007\u00033z\u0001\u0019A9\u0002\t\u0015$\u0017\u000e\u001e\u000b\n\u001b\u0006E\u00141OA;\u0003sBQA\u001a\tA\u0002\u001dDQ\u0001\u001d\tA\u0002EDa!a\u001e\u0011\u0001\u0004Q\u0018\u0001\u00059fe6L7o]5p]N$v.\u00113e\u0011\u0019\tY\b\u0005a\u0001u\u0006\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8U_\u0012+G.\u001a;f\u0003\u001d9W\r\u001e*pY\u0016$2\u0001UAA\u0011\u0015\u0001\u0018\u00031\u0001r\u0003Q9W\r\u001e*fM\u0016\u0014XM\\2fg\u001a{'OU8mKR1\u0011qQAG\u0003#\u0003BA]AEO&\u0019\u00111\u0012=\u0003\u0007M+G\u000f\u0003\u0004\u0002\u0010J\u0001\raZ\u0001\u0007e>dW-\u00133\t\u000bu\u0011\u0002\u0019\u0001>\u00021\u001d,GOU3gKJ,gnY3t\r>\u0014(k\u001c7f\u001d\u0006lW\r\u0006\u0004\u0002\b\u0006]\u0015\u0011\u0014\u0005\u0006aN\u0001\r!\u001d\u0005\u0006;M\u0001\rA_\u0001\u001eO\u0016$(+\u001a4fe\u0016t7-Z:G_J\u0004&/\u001b8dSB\fGNT1nKR1\u0011qQAP\u0003GCa!!)\u0015\u0001\u0004\t\u0018!\u00049sS:\u001c\u0017\u000e]1m\u001d\u0006lW\rC\u0003\u001e)\u0001\u0007!0A\bdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o)!\tI+a,\u00022\u0006M\u0006cA\u0014\u0002,&\u0019\u0011Q\u0016\u0015\u0003\u000f\t{w\u000e\\3b]\")a-\u0006a\u0001O\")Q$\u0006a\u0001u\"1\u0011QW\u000bA\u0002i\f\u0001\"\u00197m%>dWm\u001d\u000b\u000b\u0003S\u000bI,a/\u0002>\u0006}\u0006\"\u00024\u0017\u0001\u00049\u0007\"B\u000f\u0017\u0001\u0004Q\bBBA[-\u0001\u0007!\u0010\u0003\u0004\u0002BZ\u0001\rA_\u0001\u000baJLgnY5qC2\u001c\bf\u0001\u0001\u0002FB!\u0011qYAg\u001b\t\tIMC\u0002\u0002Lr\t1A\u001b9b\u0013\u0011\ty-!3\u0003=Q\u0013\u0018M\\:bGRLwN\\1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002TB!\u0011Q[An\u001b\t\t9N\u0003\u0003\u0002Z\u0006m\u0012AC:uKJ,w\u000e^=qK&!\u0011Q\\Al\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ReferencedPermissionServiceImpl
implements ReferencedPermissionService {
    private final ReferencedPermissionRepository referencedPermissionRepository;
    private final RoleService roleService;
    private final RolePrincipalService rolePrincipalService;
    private final RoleReferencedPermissionViewRepository roleReferencedPermissionViewRepository;

    @Override
    public Tuple2<Role, List<ReferencedPermission>> add(UUID referenceId, String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        List<ReferencedPermission> savedPermissions = this.referencedPermissionRepository.get(referenceId, role);
        Tuple2 tuple2 = savedPermissions.partition((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)rp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List exists = (List)tuple2._1();
        List toDelete = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exists, (Object)toDelete);
        Tuple2 tuple23 = tuple22;
        List exists2 = (List)tuple23._1();
        List toDelete2 = (List)tuple23._2();
        List toSave = permissions.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ReferencedPermissionServiceImpl.$anonfun$add$2(exists2, p))).map((Function1 & Serializable)p -> ReferencedPermission$.MODULE$.apply(role, (String)p, referenceId));
        this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
        return new Tuple2((Object)role, exists2.$plus$plus(this.referencedPermissionRepository.add((List<ReferencedPermission>)toSave)));
    }

    @Override
    public Tuple2<Role, List<ReferencedPermission>> remove(UUID referenceId, String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        Tuple2 tuple2 = this.referencedPermissionRepository.get(referenceId, role).partition((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)rp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List rp2 = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)rp2);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List rp3 = (List)tuple23._2();
        this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
        return new Tuple2((Object)role, (Object)rp3);
    }

    @Override
    public void removeForRole(Role role) {
        this.referencedPermissionRepository.removeForRole(role);
    }

    @Override
    public void removeForReference(UUID referenceId) {
        this.referencedPermissionRepository.removeForReference(referenceId);
    }

    @Override
    public void removeAll() {
        this.referencedPermissionRepository.removeAll();
    }

    @Override
    public List<ReferencedPermission> read(String roleName) {
        this.roleService.readOrThrowException(roleName);
        return this.referencedPermissionRepository.get(roleName);
    }

    @Override
    public List<ReferencedPermission> read(List<String> roleNames) {
        this.roleService.read(roleNames);
        return this.referencedPermissionRepository.get(roleNames);
    }

    @Override
    public List<ReferencedPermission> read(UUID referenceId, String roleName) {
        this.roleService.readOrThrowException(roleName);
        return this.referencedPermissionRepository.get(referenceId, roleName);
    }

    @Override
    public Tuple2<Page<Role>, List<RoleReferencedPermissionView>> read(UUID referenceId, String rolePattern, Pageable pageable) {
        Page<Role> rolePage = this.roleService.read(rolePattern, pageable);
        List roleIds = CollectionConverters$.MODULE$.ListHasAsScala(rolePage.getContent()).asScala().toList().map((Function1 & Serializable)x$4 -> x$4.id());
        List<RoleReferencedPermissionView> views = this.roleReferencedPermissionViewRepository.get((List<UUID>)roleIds, referenceId);
        return new Tuple2(rolePage, views);
    }

    @Override
    public List<ReferencedPermission> readForRolePattern(UUID referenceId, String rolePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(rolePattern, (Function1 & Serializable)p -> $this.referencedPermissionRepository.listByRoleNamePattern((String)p, referenceId), (Function0 & Serializable)() -> $this.referencedPermissionRepository.get(referenceId));
    }

    @Override
    public Tuple2<Role, List<ReferencedPermission>> edit(UUID referenceId, String roleName, List<String> permissionsToAdd, List<String> permissionToDelete) {
        Role role = this.getRole(roleName);
        List<ReferencedPermission> permissions = this.referencedPermissionRepository.get(referenceId, role);
        Tuple2 tuple2 = permissions.partition((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)permissionToDelete.contains((Object)p.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List exists = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)exists);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List exists2 = (List)tuple23._2();
        this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
        List toAdd = permissionsToAdd.map((Function1 & Serializable)p -> ReferencedPermission$.MODULE$.apply(role, (String)p, referenceId));
        return new Tuple2((Object)role, exists2.$plus$plus(this.referencedPermissionRepository.add((List<ReferencedPermission>)toAdd)));
    }

    /*
     * WARNING - void declaration
     */
    private Role getRole(String roleName) {
        void var2_2;
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        return var2_2;
    }

    @Override
    public Set<UUID> getReferencesForRole(UUID roleId, List<String> permissions) {
        return this.referencedPermissionRepository.listByRoleAndPermissions(roleId, permissions).map((Function1 & Serializable)x$6 -> x$6.reference()).toSet();
    }

    @Override
    public Set<UUID> getReferencesForRoleName(String roleName, List<String> permissions) {
        return this.referencedPermissionRepository.listByRoleNameAndPermissions(roleName, permissions).map((Function1 & Serializable)x$7 -> x$7.reference()).toSet();
    }

    @Override
    public Set<UUID> getReferencesForPrincipalName(String principalName, List<String> permissions) {
        return this.referencedPermissionRepository.listByPrincipalNameAndPermissions(principalName, permissions).map((Function1 & Serializable)x$8 -> x$8.reference()).toSet();
    }

    @Override
    public boolean checkPermission(UUID referenceId, List<String> permissions, List<String> allRoles) {
        return this.referencedPermissionRepository.getByPermissionsAndRoles(referenceId, permissions, (Set<String>)allRoles.toSet()).nonEmpty();
    }

    @Override
    public boolean checkPermission(UUID referenceId, List<String> permissions, List<String> allRoles, List<String> principals) {
        Set principalRoleIds = this.rolePrincipalService.readAll(principals).map((Function1 & Serializable)x$9 -> x$9.role().name()).toSet();
        return this.referencedPermissionRepository.getByPermissionsAndRoles(referenceId, permissions, (Set<String>)((Set)principalRoleIds.$plus$plus(allRoles))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$add$2(List exists$1, String p) {
        return exists$1.map((Function1 & Serializable)x$2 -> x$2.permissionName()).contains((Object)p);
    }

    public ReferencedPermissionServiceImpl(ReferencedPermissionRepository referencedPermissionRepository, RoleService roleService, RolePrincipalService rolePrincipalService, RoleReferencedPermissionViewRepository roleReferencedPermissionViewRepository) {
        this.referencedPermissionRepository = referencedPermissionRepository;
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
        this.roleReferencedPermissionViewRepository = roleReferencedPermissionViewRepository;
    }
}

