/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.GlobalPermission;
import ai.digital.deploy.permissions.model.GlobalPermission$;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.RolePrincipal;
import ai.digital.deploy.permissions.repository.GlobalPermissionRepository;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\n\u0015\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003<\u0001\u0011\u0005A\bC\u0003C\u0001\u0011\u00053\tC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0003m\u0001\u0011\u0005S\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0003v\u0001\u0011\u0005s\u000fC\u0003v\u0001\u0011\u0005\u0013\u0010C\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\tY\u0004\u0001C!\u0003\u0017\u00121d\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3J[Bd'BA\u000b\u0017\u0003\u0011IW\u000e\u001d7\u000b\u0005]A\u0012aB:feZL7-\u001a\u0006\u00033i\t1\u0002]3s[&\u001c8/[8og*\u00111\u0004H\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005uq\u0012a\u00023jO&$\u0018\r\u001c\u0006\u0002?\u0005\u0011\u0011-[\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%RS\"\u0001\f\n\u0005-2\"aF$m_\n\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f\u0003i9Gn\u001c2bYB+'/\\5tg&|gNU3q_NLGo\u001c:z!\tq\u0013'D\u00010\u0015\t\u0001\u0004$\u0001\u0006sKB|7/\u001b;pefL!AM\u0018\u00035\u001dcwNY1m!\u0016\u0014X.[:tS>t'+\u001a9pg&$xN]=\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003SUJ!A\u000e\f\u0003\u0017I{G.Z*feZL7-Z\u0001\u0015e>dW\r\u0015:j]\u000eL\u0007/\u00197TKJ4\u0018nY3\u0011\u0005%J\u0014B\u0001\u001e\u0017\u0005Q\u0011v\u000e\\3Qe&t7-\u001b9bYN+'O^5dK\u00061A(\u001b8jiz\"B!P A\u0003B\u0011a\bA\u0007\u0002)!)A\u0006\u0002a\u0001[!)1\u0007\u0002a\u0001i!)q\u0007\u0002a\u0001q\u0005\u0019\u0011\r\u001a3\u0015\u0007\u0011cf\r\u0005\u0003$\u000b\u001ek\u0015B\u0001$%\u0005\u0019!V\u000f\u001d7feA\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nG\u0001\u0006[>$W\r\\\u0005\u0003\u0019&\u0013AAU8mKB\u0019aJV-\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*!\u0003\u0019a$o\\8u}%\tQ%\u0003\u0002VI\u00059\u0001/Y2lC\u001e,\u0017BA,Y\u0005\u0011a\u0015n\u001d;\u000b\u0005U#\u0003C\u0001%[\u0013\tY\u0016J\u0001\tHY>\u0014\u0017\r\u001c)fe6L7o]5p]\")Q,\u0002a\u0001=\u0006A!o\u001c7f\u001d\u0006lW\r\u0005\u0002`G:\u0011\u0001-\u0019\t\u0003!\u0012J!A\u0019\u0013\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003E\u0012BQ!G\u0003A\u0002\u001d\u00042A\u0014,_\u0003\u0019\u0011X-\\8wKR\u0019AI[6\t\u000bu3\u0001\u0019\u00010\t\u000be1\u0001\u0019A4\u0002\u001bI,Wn\u001c<f\r>\u0014(k\u001c7f)\tq\u0017\u000f\u0005\u0002$_&\u0011\u0001\u000f\n\u0002\u0005+:LG\u000fC\u0003s\u000f\u0001\u0007q)\u0001\u0003s_2,\u0017!\u0003:f[>4X-\u00117m)\u0005q\u0017\u0001\u0002:fC\u0012$\u0012!\u0014\u000b\u0003\u001bbDQ!\u0018\u0006A\u0002y#\"!\u0014>\t\u000bm\\\u0001\u0019A4\u0002\u0013I|G.\u001a(b[\u0016\u001c\u0018!\u0005:fC\u0012\u0014\u0015PU8mKB\u000bG\u000f^3s]R\u0011QJ \u0005\u0006\u007f2\u0001\rAX\u0001\fe>dW\rU1ui\u0016\u0014h.\u0001\u0003fI&$Hc\u0002#\u0002\u0006\u0005\u001d\u00111\u0002\u0005\u0006;6\u0001\rA\u0018\u0005\u0007\u0003\u0013i\u0001\u0019A4\u0002!A,'/\\5tg&|gn\u001d+p\u0003\u0012$\u0007BBA\u0007\u001b\u0001\u0007q-A\nqKJl\u0017n]:j_:\u001cHk\u001c#fY\u0016$X-A\u0004hKR\u0014v\u000e\\3\u0015\u0007\u001d\u000b\u0019\u0002C\u0003^\u001d\u0001\u0007a,A\u000fhKR<En\u001c2bYB+'/\\5tg&|gn\u001d$peJ{G.Z%e)\r9\u0017\u0011\u0004\u0005\b\u00037y\u0001\u0019AA\u000f\u0003\u0019\u0011x\u000e\\3JIB!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012\u0001B;uS2T!!a\n\u0002\t)\fg/Y\u0005\u0005\u0003W\t\tC\u0001\u0003V+&#\u0015\u0001I4fi\u001ecwNY1m!\u0016\u0014X.[:tS>t7OR8s!JLgnY5qC2$B!!\r\u00028A!q,a\r_\u0013\r\t)$\u001a\u0002\u0004'\u0016$\bBBA\u001d!\u0001\u0007a,A\u0005qe&t7-\u001b9bY\u0006y1\r[3dWB+'/\\5tg&|g\u000e\u0006\u0004\u0002@\u0005\u0015\u0013q\t\t\u0004G\u0005\u0005\u0013bAA\"I\t9!i\\8mK\u0006t\u0007\"B\r\u0012\u0001\u00049\u0007BBA%#\u0001\u0007q-\u0001\u0005bY2\u0014v\u000e\\3t)!\ty$!\u0014\u0002P\u0005E\u0003\"B\r\u0013\u0001\u00049\u0007BBA%%\u0001\u0007q\r\u0003\u0004\u0002TI\u0001\raZ\u0001\u000baJLgnY5qC2\u001c\bf\u0001\u0001\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^a\t1A\u001b9b\u0013\u0011\t\t'a\u0017\u0003=Q\u0013\u0018M\\:bGRLwN\\1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002fA!\u0011qMA;\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014AC:uKJ,w\u000e^=qK*!\u0011qNA9\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA:\u0003\ry'oZ\u0005\u0005\u0003o\nIGA\u0004TKJ4\u0018nY3")
public class GlobalPermissionServiceImpl
implements GlobalPermissionService {
    private final GlobalPermissionRepository globalPermissionRepository;
    private final RoleService roleService;
    private final RolePrincipalService rolePrincipalService;

    @Override
    public Tuple2<Role, List<GlobalPermission>> add(String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        Tuple2 tuple2 = this.globalPermissionRepository.get(role).partition((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)gp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List exists = (List)tuple2._1();
        List toDelete = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exists, (Object)toDelete);
        Tuple2 tuple23 = tuple22;
        List exists2 = (List)tuple23._1();
        List toDelete2 = (List)tuple23._2();
        List toSave = permissions.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)GlobalPermissionServiceImpl.$anonfun$add$2(exists2, p))).map((Function1 & Serializable)p -> GlobalPermission$.MODULE$.apply(role, (String)p));
        this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
        return new Tuple2((Object)role, exists2.$plus$plus(this.globalPermissionRepository.add((List<GlobalPermission>)toSave)));
    }

    @Override
    public Tuple2<Role, List<GlobalPermission>> remove(String roleName, List<String> permissions) {
        Role role = this.getRole(roleName);
        Tuple2 tuple2 = this.globalPermissionRepository.get(role).partition((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)gp.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List gp2 = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)gp2);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List gp3 = (List)tuple23._2();
        this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
        return new Tuple2((Object)role, (Object)gp3);
    }

    @Override
    public void removeForRole(Role role) {
        this.globalPermissionRepository.removeForRole(role);
    }

    @Override
    public void removeAll() {
        this.globalPermissionRepository.removeAll();
    }

    @Override
    public List<GlobalPermission> read() {
        return this.globalPermissionRepository.get();
    }

    @Override
    public List<GlobalPermission> read(String roleName) {
        return this.globalPermissionRepository.get(roleName);
    }

    @Override
    public List<GlobalPermission> read(List<String> roleNames) {
        return this.globalPermissionRepository.get(roleNames);
    }

    @Override
    public List<GlobalPermission> readByRolePattern(String rolePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(rolePattern, (Function1 & Serializable)p -> $this.globalPermissionRepository.listByRoleNamePattern((String)p), (Function0 & Serializable)() -> $this.globalPermissionRepository.get());
    }

    @Override
    public Tuple2<Role, List<GlobalPermission>> edit(String roleName, List<String> permissionsToAdd, List<String> permissionsToDelete) {
        Role role = this.getRole(roleName);
        List<GlobalPermission> permissions = this.globalPermissionRepository.get(role);
        Tuple2 tuple2 = permissions.partition((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)permissionsToDelete.contains((Object)p.permissionName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List toDelete = (List)tuple2._1();
        List exists = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)exists);
        Tuple2 tuple23 = tuple22;
        List toDelete2 = (List)tuple23._1();
        List exists2 = (List)tuple23._2();
        this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
        List toAdd = permissionsToAdd.map((Function1 & Serializable)p -> GlobalPermission$.MODULE$.apply(role, (String)p));
        return new Tuple2((Object)role, exists2.$plus$plus(this.globalPermissionRepository.add((List<GlobalPermission>)toAdd)));
    }

    /*
     * WARNING - void declaration
     */
    private Role getRole(String roleName) {
        void var2_2;
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        return var2_2;
    }

    @Override
    public List<String> getGlobalPermissionsForRoleId(UUID roleId) {
        List<GlobalPermission> permissions = this.globalPermissionRepository.get(roleId);
        return permissions.map((Function1 & Serializable)x$5 -> x$5.permissionName());
    }

    @Override
    public Set<String> getGlobalPermissionsForPrincipal(String principal) {
        List<RolePrincipal> result = this.rolePrincipalService.read(principal);
        List roles = result.map((Function1 & Serializable)x$6 -> x$6.role().name());
        return this.globalPermissionRepository.get((List<String>)roles).map((Function1 & Serializable)data -> data.permissionName()).toSet();
    }

    @Override
    public boolean checkPermission(List<String> permissions, List<String> allRoles) {
        return this.globalPermissionRepository.getByPermissionsAndRoles(permissions, (Set<String>)allRoles.toSet()).nonEmpty();
    }

    @Override
    public boolean checkPermission(List<String> permissions, List<String> allRoles, List<String> principals) {
        Set principalRoleIds = this.rolePrincipalService.readAll(principals).map((Function1 & Serializable)x$7 -> x$7.role().name()).toSet();
        return this.globalPermissionRepository.getByPermissionsAndRoles(permissions, (Set<String>)((Set)principalRoleIds.$plus$plus(allRoles))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$add$2(List exists$1, String p) {
        return exists$1.map((Function1 & Serializable)x$2 -> x$2.permissionName()).contains((Object)p);
    }

    public GlobalPermissionServiceImpl(GlobalPermissionRepository globalPermissionRepository, RoleService roleService, RolePrincipalService rolePrincipalService) {
        this.globalPermissionRepository = globalPermissionRepository;
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
    }
}

