/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkDirContext {
    private static final AtomicReference<WorkDirFactory> FACTORY = new AtomicReference();
    private static final ThreadLocal<WorkDir> WORKDIR = new ThreadLocal();

    @Autowired
    public WorkDirContext(WorkDirFactory workDirFactory) {
        FACTORY.compareAndSet(null, workDirFactory);
    }

    public static void initWorkdir() {
        WORKDIR.set(FACTORY.get().newWorkDir());
    }

    public static void initWorkdir(String prefix) {
        WORKDIR.set(FACTORY.get().newWorkDir(prefix));
    }

    public static void setWorkDir(WorkDir workDir) {
        WORKDIR.set(workDir);
    }

    public static void clear() {
        WORKDIR.remove();
    }

    public static WorkDir get() {
        return WORKDIR.get();
    }
}

