/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Prints the headers of all sent and/or received messages")
public class HDRS
extends Protocol {
    @Property(description="Enables printing of down messages")
    protected volatile boolean print_down = true;
    @Property(description="Enables printing of up (received) messages")
    protected volatile boolean print_up = true;

    @Override
    public Object down(Message msg) {
        if (this.print_down) {
            System.out.printf("-- to %s (%d bytes): %s\n", msg.dest(), msg.getLength(), msg.printHeaders());
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        if (this.print_up) {
            System.out.printf("-- [s] from %s (%d bytes): %s\n", msg.src(), msg.getLength(), msg.printHeaders());
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.print_up) {
            for (Message msg : batch) {
                System.out.printf("-- [b] from %s (%d bytes): %s\n", msg.src(), msg.getLength(), msg.printHeaders());
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }
}

