/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.couchbase;

import com.couchbase.client.java.Cluster;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.couchbase.CouchbaseReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Cluster.class, Flux.class})
@ConditionalOnBean(value={Cluster.class})
@ConditionalOnEnabledHealthIndicator(value="couchbase")
@AutoConfigureAfter(value={CouchbaseAutoConfiguration.class})
public class CouchbaseReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<CouchbaseReactiveHealthIndicator, Cluster> {
    @Bean
    @ConditionalOnMissingBean(name={"couchbaseHealthIndicator", "couchbaseHealthContributor"})
    public ReactiveHealthContributor couchbaseHealthContributor(Map<String, Cluster> clusters) {
        return (ReactiveHealthContributor)this.createContributor(clusters);
    }
}

