/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.scaladsl;

import akka.Done;
import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Status;
import akka.annotation.InternalApi;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializerHelper$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.BoundedSourceQueue;
import akka.stream.CompletionStrategy;
import akka.stream.CompletionStrategy$Draining$;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.Outlet$;
import akka.stream.OverflowStrategy;
import akka.stream.Shape;
import akka.stream.SourceShape;
import akka.stream.UniformFanInShape;
import akka.stream.impl.ActorRefBackpressureSource;
import akka.stream.impl.ActorRefSource;
import akka.stream.impl.BoundedSourceQueueStage;
import akka.stream.impl.EmptySource$;
import akka.stream.impl.FailedSource;
import akka.stream.impl.LazySource;
import akka.stream.impl.LinearTraversalBuilder$;
import akka.stream.impl.MaybeSource$;
import akka.stream.impl.PublisherSource;
import akka.stream.impl.QueueSource;
import akka.stream.impl.SetupSourceStage;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.SubscriberSource;
import akka.stream.impl.Unfold;
import akka.stream.impl.UnfoldAsync;
import akka.stream.impl.UnfoldResourceSource;
import akka.stream.impl.UnfoldResourceSourceAsync;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.scaladsl.FlowOps;
import akka.stream.scaladsl.FlowOpsMat;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.GraphDSL$Implicits$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.SourceQueueWithComplete;
import akka.stream.scaladsl.StreamConverters$;
import akka.stream.scaladsl.ZipWithN$;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.util.ConstantFun$;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.stream.BaseStream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Source$ {
    public static final Source$ MODULE$ = new Source$();
    private static final Source<Nothing$, NotUsed> _empty = MODULE$.fromGraph(EmptySource$.MODULE$);
    private static final Source<Nothing$, NotUsed> _never = MODULE$.future((Future)Future.never$.MODULE$).withAttributes(Stages$DefaultAttributes$.MODULE$.neverSource());

    public <T> SourceShape<T> shape(String name) {
        return new SourceShape(Outlet$.MODULE$.apply(new java.lang.StringBuilder(4).append(name).append(".out").toString()));
    }

    public <T> Source<T, NotUsed> fromPublisher(Publisher<T> publisher) {
        return this.fromGraph(new PublisherSource<T>(publisher, Stages$DefaultAttributes$.MODULE$.publisherSource(), this.shape("PublisherSource")));
    }

    public <T> Source<T, NotUsed> fromIterator(Function0<Iterator<T>> f) {
        return this.apply(new scala.collection.immutable.Iterable<T>(f){
            private final Function0 f$2;

            public IterableFactory<scala.collection.immutable.Iterable> iterableFactory() {
                return scala.collection.immutable.Iterable.iterableFactory$((scala.collection.immutable.Iterable)this);
            }

            public final Iterable<T> toIterable() {
                return Iterable.toIterable$((Iterable)this);
            }

            public final Iterable<T> coll() {
                return Iterable.coll$((Iterable)this);
            }

            public Iterable<T> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public String className() {
                return Iterable.className$((Iterable)this);
            }

            public final String collectionClassName() {
                return Iterable.collectionClassName$((Iterable)this);
            }

            public String stringPrefix() {
                return Iterable.stringPrefix$((Iterable)this);
            }

            public <B> LazyZip2<T, B, Iterable> lazyZip(Iterable<B> that) {
                return Iterable.lazyZip$((Iterable)this, that);
            }

            public IterableOps fromSpecific(IterableOnce coll) {
                return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
            }

            public Builder<T, scala.collection.immutable.Iterable<T>> newSpecificBuilder() {
                return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
            }

            public IterableOps empty() {
                return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
            }

            public final Iterable<T> toTraversable() {
                return IterableOps.toTraversable$((IterableOps)this);
            }

            public boolean isTraversableAgain() {
                return IterableOps.isTraversableAgain$((IterableOps)this);
            }

            public final Object repr() {
                return IterableOps.repr$((IterableOps)this);
            }

            public IterableFactory<?> companion() {
                return IterableOps.companion$((IterableOps)this);
            }

            public T head() {
                return (T)IterableOps.head$((IterableOps)this);
            }

            public Option<T> headOption() {
                return IterableOps.headOption$((IterableOps)this);
            }

            public T last() {
                return (T)IterableOps.last$((IterableOps)this);
            }

            public Option<T> lastOption() {
                return IterableOps.lastOption$((IterableOps)this);
            }

            public View<T> view() {
                return IterableOps.view$((IterableOps)this);
            }

            public int sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public final IterableOps sizeIs() {
                return IterableOps.sizeIs$((IterableOps)this);
            }

            public int sizeCompare(Iterable<?> that) {
                return IterableOps.sizeCompare$((IterableOps)this, that);
            }

            public View<T> view(int from, int until) {
                return IterableOps.view$((IterableOps)this, (int)from, (int)until);
            }

            public Object transpose(Function1 asIterable) {
                return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
            }

            public Object filter(Function1 pred) {
                return IterableOps.filter$((IterableOps)this, (Function1)pred);
            }

            public Object filterNot(Function1 pred) {
                return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
            }

            public WithFilter<T, ?> withFilter(Function1<T, Object> p) {
                return IterableOps.withFilter$((IterableOps)this, p);
            }

            public Tuple2<scala.collection.immutable.Iterable<T>, scala.collection.immutable.Iterable<T>> partition(Function1<T, Object> p) {
                return IterableOps.partition$((IterableOps)this, p);
            }

            public Tuple2<scala.collection.immutable.Iterable<T>, scala.collection.immutable.Iterable<T>> splitAt(int n) {
                return IterableOps.splitAt$((IterableOps)this, (int)n);
            }

            public Object take(int n) {
                return IterableOps.take$((IterableOps)this, (int)n);
            }

            public Object takeRight(int n) {
                return IterableOps.takeRight$((IterableOps)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
            }

            public Tuple2<scala.collection.immutable.Iterable<T>, scala.collection.immutable.Iterable<T>> span(Function1<T, Object> p) {
                return IterableOps.span$((IterableOps)this, p);
            }

            public Object drop(int n) {
                return IterableOps.drop$((IterableOps)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableOps.dropRight$((IterableOps)this, (int)n);
            }

            public Object dropWhile(Function1 p) {
                return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> grouped(int size) {
                return IterableOps.grouped$((IterableOps)this, (int)size);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> sliding(int size) {
                return IterableOps.sliding$((IterableOps)this, (int)size);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> sliding(int size, int step) {
                return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
            }

            public Object tail() {
                return IterableOps.tail$((IterableOps)this);
            }

            public Object init() {
                return IterableOps.init$((IterableOps)this);
            }

            public Object slice(int from, int until) {
                return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
            }

            public <K> Map<K, scala.collection.immutable.Iterable<T>> groupBy(Function1<T, K> f) {
                return IterableOps.groupBy$((IterableOps)this, f);
            }

            public <K, B> Map<K, scala.collection.immutable.Iterable<B>> groupMap(Function1<T, K> key, Function1<T, B> f) {
                return IterableOps.groupMap$((IterableOps)this, key, f);
            }

            public <K, B> Map<K, B> groupMapReduce(Function1<T, K> key, Function1<T, B> f, Function2<B, B, B> reduce) {
                return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
            }

            public Object scan(Object z, Function2 op) {
                return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanLeft(Object z, Function2 op) {
                return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanRight(Object z, Function2 op) {
                return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object map(Function1 f) {
                return IterableOps.map$((IterableOps)this, (Function1)f);
            }

            public Object flatMap(Function1 f) {
                return IterableOps.flatMap$((IterableOps)this, (Function1)f);
            }

            public Object flatten(Function1 asIterable) {
                return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
            }

            public Object collect(PartialFunction pf) {
                return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
            }

            public <A1, A2> Tuple2<scala.collection.immutable.Iterable<A1>, scala.collection.immutable.Iterable<A2>> partitionMap(Function1<T, Either<A1, A2>> f) {
                return IterableOps.partitionMap$((IterableOps)this, f);
            }

            public Object concat(IterableOnce suffix) {
                return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public final Object $plus$plus(IterableOnce suffix) {
                return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
            }

            public Object zip(IterableOnce that) {
                return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
            }

            public Object zipWithIndex() {
                return IterableOps.zipWithIndex$((IterableOps)this);
            }

            public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
            }

            public <A1, A2> Tuple2<scala.collection.immutable.Iterable<A1>, scala.collection.immutable.Iterable<A2>> unzip(Function1<T, Tuple2<A1, A2>> asPair) {
                return IterableOps.unzip$((IterableOps)this, asPair);
            }

            public <A1, A2, A3> Tuple3<scala.collection.immutable.Iterable<A1>, scala.collection.immutable.Iterable<A2>, scala.collection.immutable.Iterable<A3>> unzip3(Function1<T, Tuple3<A1, A2, A3>> asTriple) {
                return IterableOps.unzip3$((IterableOps)this, asTriple);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> tails() {
                return IterableOps.tails$((IterableOps)this);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> inits() {
                return IterableOps.inits$((IterableOps)this);
            }

            public Object tapEach(Function1 f) {
                return IterableOps.tapEach$((IterableOps)this, (Function1)f);
            }

            public Object $plus$plus$colon(IterableOnce that) {
                return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
            }

            public boolean hasDefiniteSize() {
                return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<T, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<T, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<T> find(Function1<T, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean isEmpty() {
                return IterableOnceOps.isEmpty$((IterableOnceOps)this);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public <B> T min(Ordering<B> ord) {
                return (T)IterableOnceOps.min$((IterableOnceOps)this, ord);
            }

            public <B> Option<T> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public <B> T max(Ordering<B> ord) {
                return (T)IterableOnceOps.max$((IterableOnceOps)this, ord);
            }

            public <B> Option<T> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)IterableOnceOps.maxBy$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<T> maxByOption(Function1<T, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)IterableOnceOps.minBy$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<T> minByOption(Function1<T, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<T, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<T, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<T> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<T> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<T> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<T, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<T> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<T> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<T> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<T, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public Iterator<T> iterator() {
                return (Iterator)this.f$2.apply();
            }

            public String toString() {
                return "() => Iterator";
            }
            {
                this.f$2 = f$2;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
                scala.collection.immutable.Iterable.$init$((scala.collection.immutable.Iterable)this);
            }
        });
    }

    public <T, S extends BaseStream<T, S>> Source<T, NotUsed> fromJavaStream(Function0<BaseStream<T, S>> stream) {
        return StreamConverters$.MODULE$.fromJavaStream(stream);
    }

    public <T> Source<T, NotUsed> cycle(Function0<Iterator<T>> f) {
        Iterator iterator = package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> {
            void var1_1;
            Iterator i = (Iterator)f.apply();
            if (i.isEmpty()) {
                throw new IllegalArgumentException("empty iterator");
            }
            return var1_1;
        }).flatten(Predef$.MODULE$.$conforms());
        return this.fromIterator((Function0 & Serializable)() -> iterator).withAttributes(Stages$DefaultAttributes$.MODULE$.cycledSource());
    }

    public <T, M> Source<T, M> fromGraph(Graph<SourceShape<T>, M> g) {
        FlowOps flowOps;
        Graph<SourceShape<T>, M> graph = g;
        if (graph instanceof Source) {
            Source source;
            flowOps = source = (Source)graph;
        } else if (graph instanceof akka.stream.javadsl.Source) {
            akka.stream.javadsl.Source source = (akka.stream.javadsl.Source)graph;
            flowOps = source.asScala();
        } else if (graph instanceof GraphStageWithMaterializedValue) {
            GraphStageWithMaterializedValue graphStageWithMaterializedValue = (GraphStageWithMaterializedValue)graph;
            Attributes attrs = graphStageWithMaterializedValue.traversalBuilder().attributes();
            Graph noAttrStage = graphStageWithMaterializedValue.withAttributes(Attributes$.MODULE$.none());
            flowOps = new Source(LinearTraversalBuilder$.MODULE$.fromBuilder(noAttrStage.traversalBuilder(), (Shape)noAttrStage.shape(), (Function2<Nothing$, Nothing$, Object>)Keep$.MODULE$.right()), (SourceShape)noAttrStage.shape()).withAttributes(attrs);
        } else {
            flowOps = new Source(LinearTraversalBuilder$.MODULE$.fromBuilder(graph.traversalBuilder(), graph.shape(), Keep$.MODULE$.right()), graph.shape());
        }
        return flowOps;
    }

    public <T, M> Source<T, Future<M>> fromMaterializer(Function2<Materializer, Attributes, Source<T, M>> factory) {
        return this.fromGraph(new SetupSourceStage<T, M>(factory));
    }

    public <T, M> Source<T, Future<M>> setup(Function2<ActorMaterializer, Attributes, Source<T, M>> factory) {
        return this.fromGraph(new SetupSourceStage((Function2 & Serializable)(materializer, attributes) -> (Source)factory.apply((Object)ActorMaterializerHelper$.MODULE$.downcast((Materializer)materializer), attributes)));
    }

    public <T> Source<T, NotUsed> apply(scala.collection.immutable.Iterable<T> iterable) {
        return ((Source)this.single(iterable).mapConcat(ConstantFun$.MODULE$.scalaIdentityFunction())).withAttributes(Stages$DefaultAttributes$.MODULE$.iterableSource());
    }

    public <T> Source<T, NotUsed> fromFuture(Future<T> future) {
        return this.fromGraph(new GraphStages.FutureSource<T>(future));
    }

    public <T> Source<T, NotUsed> fromCompletionStage(CompletionStage<T> future) {
        return this.fromGraph(new GraphStages.FutureSource(FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(future))));
    }

    public <T, M> Source<T, Future<M>> fromFutureSource(Future<Graph<SourceShape<T>, M>> future) {
        return this.fromGraph(new GraphStages.FutureFlattenSource<T, M>(future));
    }

    public <T, M> Source<T, CompletionStage<M>> fromSourceCompletionStage(CompletionStage<? extends Graph<SourceShape<T>, M>> completion) {
        return this.fromFutureSource(FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(completion))).mapMaterializedValue((Function1 & Serializable)x$2 -> FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(x$2)));
    }

    public <T> Source<T, Cancellable> tick(FiniteDuration initialDelay, FiniteDuration interval, T tick) {
        return this.fromGraph(new GraphStages.TickSource<T>(initialDelay, interval, tick));
    }

    public <T> Source<T, NotUsed> single(T element) {
        return this.fromGraph(new GraphStages.SingleSource<T>(element));
    }

    public <T> Source<T, NotUsed> repeat(T element) {
        Some next = new Some((Object)new Tuple2(element, element));
        return this.unfold(element, (Function1 & Serializable)x$3 -> next).withAttributes(Stages$DefaultAttributes$.MODULE$.repeat());
    }

    public <S, E> Source<E, NotUsed> unfold(S s, Function1<S, Option<Tuple2<S, E>>> f) {
        return this.fromGraph(new Unfold<S, E>(s, f));
    }

    public <S, E> Source<E, NotUsed> unfoldAsync(S s, Function1<S, Future<Option<Tuple2<S, E>>>> f) {
        return this.fromGraph(new UnfoldAsync<S, E>(s, f));
    }

    public <T> Source<T, NotUsed> empty() {
        return _empty;
    }

    public <T> Source<T, Promise<Option<T>>> maybe() {
        return this.fromGraph(MaybeSource$.MODULE$);
    }

    public <T> Source<T, NotUsed> failed(Throwable cause) {
        return this.fromGraph(new FailedSource(cause));
    }

    public <T, M> Source<T, Future<M>> lazily(Function0<Source<T, M>> create) {
        return this.fromGraph(new LazySource<T, M>(create));
    }

    public <T> Source<T, Future<NotUsed>> lazilyAsync(Function0<Future<T>> create) {
        return this.lazily((Function0 & Serializable)() -> MODULE$.fromFuture((Future)create.apply()));
    }

    public <T> Source<T, NotUsed> future(Future<T> futureElement) {
        return this.fromGraph(new GraphStages.FutureSource<T>(futureElement));
    }

    public <T> Source<T, NotUsed> never() {
        return _never;
    }

    public <T> Source<T, NotUsed> completionStage(CompletionStage<T> completionStage) {
        return this.future(FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(completionStage)));
    }

    public <T, M> Source<T, Future<M>> futureSource(Future<Source<T, M>> futureSource) {
        return this.fromGraph(new GraphStages.FutureFlattenSource(futureSource));
    }

    public <T> Source<T, NotUsed> lazySingle(Function0<T> create) {
        return this.lazySource((Function0 & Serializable)() -> MODULE$.single(create.apply())).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
    }

    public <T> Source<T, NotUsed> lazyFuture(Function0<Future<T>> create) {
        return this.lazySource((Function0 & Serializable)() -> {
            Future f = (Future)create.apply();
            return MODULE$.future(f);
        }).mapMaterializedValue((Function1 & Serializable)x$5 -> NotUsed$.MODULE$);
    }

    public <T, M> Source<T, Future<M>> lazySource(Function0<Source<T, M>> create) {
        return this.fromGraph(new LazySource<T, M>(create));
    }

    public <T, M> Source<T, Future<M>> lazyFutureSource(Function0<Future<Source<T, M>>> create) {
        return this.lazySource((Function0 & Serializable)() -> MODULE$.futureSource((Future)create.apply())).mapMaterializedValue((Function1 & Serializable)x$6 -> x$6.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public <T> Source<T, Subscriber<T>> asSubscriber() {
        return this.fromGraph(new SubscriberSource<T>(Stages$DefaultAttributes$.MODULE$.subscriberSource(), this.shape("SubscriberSource")));
    }

    public <T> Source<T, ActorRef> actorRef(PartialFunction<Object, CompletionStrategy> completionMatcher, PartialFunction<Object, Throwable> failureMatcher, int bufferSize, OverflowStrategy overflowStrategy) {
        Predef$.MODULE$.require(bufferSize >= 0, (Function0 & Serializable)() -> "bufferSize must be greater than or equal to 0");
        Predef$.MODULE$.require(!overflowStrategy.isBackpressure(), (Function0 & Serializable)() -> "Backpressure overflowStrategy not supported");
        return this.fromGraph(new ActorRefSource(bufferSize, overflowStrategy, completionMatcher, failureMatcher)).withAttributes(Stages$DefaultAttributes$.MODULE$.actorRefSource());
    }

    public <T> Source<T, ActorRef> actorRef(int bufferSize, OverflowStrategy overflowStrategy) {
        return this.actorRef((PartialFunction<Object, CompletionStrategy>)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Status.Success success = null;
                A1 A1 = x1;
                if (A1 instanceof Status.Success) {
                    bl = true;
                    success = (Status.Success)A1;
                    Object s = success.status();
                    if (s instanceof CompletionStrategy) {
                        CompletionStrategy completionStrategy = (CompletionStrategy)s;
                        object = completionStrategy;
                        return (B1)object;
                    }
                }
                if (bl) {
                    object = CompletionStrategy$Draining$.MODULE$;
                    return (B1)object;
                }
                if (Status.Success$.MODULE$.equals(A1)) {
                    object = CompletionStrategy$Draining$.MODULE$;
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                boolean bl = false;
                Status.Success success = null;
                Object object = x1;
                if (object instanceof Status.Success) {
                    bl = true;
                    success = (Status.Success)object;
                    Object s = success.status();
                    if (s instanceof CompletionStrategy) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (!Status.Success$.MODULE$.equals(object)) return false;
                return true;
            }
        }, (PartialFunction<Object, Throwable>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Status.Failure) {
                    Status.Failure failure = (Status.Failure)A1;
                    Throwable cause = failure.cause();
                    object = cause;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof Status.Failure;
                return bl;
            }
        }, bufferSize, overflowStrategy);
    }

    @InternalApi
    public <T> Source<T, ActorRef> actorRefWithAck(Option<ActorRef> ackTo, Object ackMessage, PartialFunction<Object, CompletionStrategy> completionMatcher, PartialFunction<Object, Throwable> failureMatcher) {
        return this.fromGraph(new ActorRefBackpressureSource(ackTo, ackMessage, completionMatcher, failureMatcher));
    }

    public <T> Source<T, ActorRef> actorRefWithBackpressure(Object ackMessage, PartialFunction<Object, CompletionStrategy> completionMatcher, PartialFunction<Object, Throwable> failureMatcher) {
        return this.fromGraph(new ActorRefBackpressureSource((Option<ActorRef>)None$.MODULE$, ackMessage, completionMatcher, failureMatcher));
    }

    public <T> Source<T, ActorRef> actorRefWithAck(Object ackMessage) {
        return this.actorRefWithAck((Option<ActorRef>)None$.MODULE$, ackMessage, (PartialFunction<Object, CompletionStrategy>)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Status.Success success = null;
                A1 A1 = x1;
                if (A1 instanceof Status.Success) {
                    bl = true;
                    success = (Status.Success)A1;
                    Object s = success.status();
                    if (s instanceof CompletionStrategy) {
                        CompletionStrategy completionStrategy = (CompletionStrategy)s;
                        object = completionStrategy;
                        return (B1)object;
                    }
                }
                if (bl) {
                    object = CompletionStrategy$Draining$.MODULE$;
                    return (B1)object;
                }
                if (Status.Success$.MODULE$.equals(A1)) {
                    object = CompletionStrategy$Draining$.MODULE$;
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                boolean bl = false;
                Status.Success success = null;
                Object object = x1;
                if (object instanceof Status.Success) {
                    bl = true;
                    success = (Status.Success)object;
                    Object s = success.status();
                    if (s instanceof CompletionStrategy) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (!Status.Success$.MODULE$.equals(object)) return false;
                return true;
            }
        }, (PartialFunction<Object, Throwable>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Status.Failure) {
                    Status.Failure failure = (Status.Failure)A1;
                    Throwable cause = failure.cause();
                    object = cause;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof Status.Failure;
                return bl;
            }
        });
    }

    public <T, U> Source<U, NotUsed> combine(Source<T, ?> first, Source<T, ?> second, Seq<Source<T, ?>> rest, Function1<Object, Graph<UniformFanInShape<T, U>, NotUsed>> strategy) {
        return this.fromGraph(GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            UniformFanInShape c = (UniformFanInShape)b.add((Graph)strategy.apply((Object)BoxesRunTime.boxToInteger((int)(rest.size() + 2))));
            new GraphDSL.Implicits.SourceArrow(GraphDSL$Implicits$.MODULE$.SourceArrow(first)).$tilde$greater(c.in(0), (GraphDSL.Builder<?>)b);
            new GraphDSL.Implicits.SourceArrow(GraphDSL$Implicits$.MODULE$.SourceArrow(second)).$tilde$greater(c.in(1), (GraphDSL.Builder<?>)b);
            return this.combineRest$2(2, rest.iterator(), c, (GraphDSL.Builder)b);
        }));
    }

    public <T, U, M1, M2, M> Source<U, M> combineMat(Source<T, M1> first, Source<T, M2> second, Function1<Object, Graph<UniformFanInShape<T, U>, NotUsed>> strategy, Function2<M1, M2, M> matF) {
        Graph secondPartiallyCombined = GraphDSL$.MODULE$.create(second, (Function1 & Serializable)b -> (Function1 & Serializable)secondShape -> {
            UniformFanInShape c = (UniformFanInShape)b.add((Graph)strategy.apply((Object)BoxesRunTime.boxToInteger((int)2)));
            new GraphDSL.Implicits.SourceShapeArrow(GraphDSL$Implicits$.MODULE$.SourceShapeArrow(secondShape)).$tilde$greater(c.in(1), (GraphDSL.Builder<?>)b);
            return new FlowShape(c.in(0), c.out());
        });
        return first.viaMat(secondPartiallyCombined, (Function2)matF);
    }

    public <T> Source<Seq<T>, NotUsed> zipN(Seq<Source<T, ?>> sources) {
        return this.zipWithN(ConstantFun$.MODULE$.scalaIdentityFunction(), sources).addAttributes(Stages$DefaultAttributes$.MODULE$.zipN());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, O> Source<O, NotUsed> zipWithN(Function1<Seq<T>, O> zipper, Seq<Source<T, ?>> sources) {
        void var3_8;
        SeqOps seqOps;
        SeqOps seqOps2;
        Seq<Source<T, ?>> seq = sources;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = Seq$.MODULE$.unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
            Source<T, NotUsed> source = this.empty();
        } else if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Source source = (Source)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            FlowOpsMat flowOpsMat = ((Source)source.map((Function1 & Serializable)t -> zipper.apply((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{t}))))).mapMaterializedValue((Function1 & Serializable)x$7 -> NotUsed$.MODULE$);
        } else {
            Option option;
            Option option2;
            if (seq == null || (option2 = package$.MODULE$.$plus$colon().unapply(seq)).isEmpty()) throw new IllegalArgumentException();
            Source s1 = (Source)((Tuple2)option2.get())._1();
            Seq seq2 = (Seq)((Tuple2)option2.get())._2();
            if (seq2 == null || (option = package$.MODULE$.$plus$colon().unapply((SeqOps)seq2)).isEmpty()) throw new IllegalArgumentException();
            Source s2 = (Source)((Tuple2)option.get())._1();
            Seq ss = (Seq)((Tuple2)option.get())._2();
            Source source = this.combine(s1, s2, ss, (Function1 & Serializable)n -> ZipWithN$.MODULE$.apply(zipper, BoxesRunTime.unboxToInt((Object)n)));
        }
        void source = var3_8;
        return source.addAttributes(Stages$DefaultAttributes$.MODULE$.zipWithN());
    }

    public <T> Source<T, BoundedSourceQueue<T>> queue(int bufferSize) {
        return this.fromGraph(new BoundedSourceQueueStage(bufferSize));
    }

    public <T> Source<T, SourceQueueWithComplete<T>> queue(int bufferSize, OverflowStrategy overflowStrategy) {
        return this.queue(bufferSize, overflowStrategy, 1);
    }

    public <T> Source<T, SourceQueueWithComplete<T>> queue(int bufferSize, OverflowStrategy overflowStrategy, int maxConcurrentOffers) {
        return this.fromGraph(new QueueSource(bufferSize, overflowStrategy, maxConcurrentOffers).withAttributes(Stages$DefaultAttributes$.MODULE$.queueSource()));
    }

    public <T, S> Source<T, NotUsed> unfoldResource(Function0<S> create, Function1<S, Option<T>> read, Function1<S, BoxedUnit> close) {
        return this.fromGraph(new UnfoldResourceSource<T, S>(create, read, close));
    }

    public <T, S> Source<T, NotUsed> unfoldResourceAsync(Function0<Future<S>> create, Function1<S, Future<Option<T>>> read, Function1<S, Future<Done>> close) {
        return this.fromGraph(new UnfoldResourceSourceAsync<T, S>(create, read, close));
    }

    private final SourceShape combineRest$2(int idx, Iterator i, UniformFanInShape c$2, GraphDSL.Builder b$2) {
        while (i.hasNext()) {
            new GraphDSL.Implicits.SourceArrow(GraphDSL$Implicits$.MODULE$.SourceArrow((Graph)i.next())).$tilde$greater(c$2.in(idx), b$2);
            ++idx;
        }
        return new SourceShape(c$2.out());
    }

    private Source$() {
    }
}

