/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.utils.RandomUtil;

public class AMQPMirrorBrokerConnectionElement
extends AMQPBrokerConnectionElement {
    SimpleString sourceMirrorAddress;
    boolean durable;
    boolean queueCreation = true;
    boolean queueRemoval = true;
    boolean messageAcknowledgements = true;

    public AMQPMirrorBrokerConnectionElement() {
        this.setType(AMQPBrokerConnectionAddressType.MIRROR);
    }

    public boolean isDurable() {
        return this.durable;
    }

    public AMQPMirrorBrokerConnectionElement setSourceMirrorAddress(String mirrorAddress) {
        return this.setSourceMirrorAddress(SimpleString.toSimpleString((String)mirrorAddress));
    }

    public AMQPMirrorBrokerConnectionElement setSourceMirrorAddress(SimpleString souceMirrorAddress) {
        this.sourceMirrorAddress = souceMirrorAddress;
        this.durable = this.sourceMirrorAddress != null;
        return this;
    }

    public SimpleString getSourceMirrorAddress() {
        if (this.sourceMirrorAddress == null) {
            this.sourceMirrorAddress = SimpleString.toSimpleString((String)(this.parent.getName() + RandomUtil.randomString()));
        }
        return this.sourceMirrorAddress;
    }

    public boolean isQueueCreation() {
        return this.queueCreation;
    }

    public AMQPMirrorBrokerConnectionElement setQueueCreation(boolean queueCreation) {
        this.queueCreation = queueCreation;
        return this;
    }

    public boolean isQueueRemoval() {
        return this.queueRemoval;
    }

    public AMQPMirrorBrokerConnectionElement setQueueRemoval(boolean queueRemoval) {
        this.queueRemoval = queueRemoval;
        return this;
    }

    @Override
    public AMQPMirrorBrokerConnectionElement setType(AMQPBrokerConnectionAddressType type) {
        super.setType(type);
        return this;
    }

    public boolean isMessageAcknowledgements() {
        return this.messageAcknowledgements;
    }

    public AMQPMirrorBrokerConnectionElement setMessageAcknowledgements(boolean messageAcknowledgements) {
        this.messageAcknowledgements = messageAcknowledgements;
        return this;
    }
}

