/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.jmx.AdditionalJmxObjects;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.AlternatingBundler;
import org.jgroups.protocols.AsyncNoBundler;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.MsgStats;
import org.jgroups.protocols.NoBundler;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.RemoveQueueBundler;
import org.jgroups.protocols.RingBufferBundler;
import org.jgroups.protocols.RingBufferBundlerLockless;
import org.jgroups.protocols.RingBufferBundlerLockless2;
import org.jgroups.protocols.SenderSendsBundler;
import org.jgroups.protocols.SimplifiedTransferQueueBundler;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.TransferQueueBundler;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.IpAddressUUID;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AsciiString;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.ExpiryCache;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.MaxOneThreadPerSender;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.SubmitToThreadPool;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeScheduler3;
import org.jgroups.util.TimeService;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Transport protocol")
public abstract class TP
extends Protocol
implements DiagnosticsHandler.ProbeHandler,
AdditionalJmxObjects {
    public static final byte LIST = 1;
    public static final byte MULTICAST = 2;
    public static final int MSG_OVERHEAD = 3;
    protected static final long MIN_WAIT_BETWEEN_DISCOVERIES = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
    @LocalAddress
    @Property(name="bind_addr", description="The bind address which should be used by this transport. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL, NON_LOOPBACK, match-interface, match-host, match-address", defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr;
    @Property(description="Use IP addresses (IpAddressUUID) instead of UUIDs as addresses. This is currently not compatible with RELAY2: disable if RELAY2 is used.")
    protected boolean use_ip_addrs;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr;
    @Property(description="Used to map the internal port (bind_port) to an external port. Only used if > 0", systemProperty={"jgroups.external_port"}, writable=false)
    protected int external_port;
    @ManagedAttribute(description="tracing is enabled or disabled for the given log", writable=true)
    protected boolean is_trace;
    @Property(description="If true, the transport should use all available interfaces to receive multicast messages")
    protected boolean receive_on_all_interfaces;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addresses or interface names) to receive multicasts on")
    protected List<NetworkInterface> receive_interfaces;
    @Property(description="Max number of elements in the logical address cache before eviction starts")
    protected int logical_addr_cache_max_size;
    @Property(description="Time (in ms) after which entries in the logical address cache marked as removable can be removed. 0 never removes any entries (not recommended)")
    protected long logical_addr_cache_expiration;
    @Property(description="Interval (in ms) at which the reaper task scans logical_addr_cache and removes entries marked as removable. 0 disables reaping.")
    protected long logical_addr_cache_reaper_interval;
    @Property(description="The port to which the transport binds. Default of 0 binds to any (ephemeral) port. See also port_range", systemProperty={"jgroups.bind_port"}, writable=false)
    protected int bind_port;
    @Property(description="The range of valid ports: [bind_port .. bind_port+port_range ]. 0 only binds to bind_port and fails if taken")
    protected int port_range;
    @Property(description="Whether or not to make a copy of a message before looping it back up. Don't use this; might get removed without warning")
    protected boolean loopback_copy;
    @Property(description="Loop back the message on a separate thread or use the current thread. Don't use this; might get removed without warning")
    protected boolean loopback_separate_thread;
    @Property(description="The fully qualified name of a class implementing MessageProcessingPolicy")
    protected String message_processing_policy;
    @Property(name="message_processing_policy.max_buffer_size", description="Max number of messages buffered for consumption of the delivery thread in MaxOneThreadPerSender. 0 creates an unbounded buffer")
    protected int msg_processing_max_buffer_size;
    @Property(description="Thread naming pattern for threads in this channel. Valid values are \"pcl\": \"p\": includes the thread name, e.g. \"Incoming thread-1\", \"UDP ucast receiver\", \"c\": includes the cluster name, e.g. \"MyCluster\", \"l\": includes the local address of the current member, e.g. \"192.168.5.1:5678\"")
    protected String thread_naming_pattern;
    @Property(name="thread_pool.use_fork_join_pool", description="If enabled, a ForkJoinPool will be used rather than a ThreadPoolExecutor")
    protected boolean use_fork_join_pool;
    @Property(name="thread_pool.use_common_fork_join_pool", description="If true, the common fork-join pool will be used; otherwise a custom ForkJoinPool will be created")
    protected boolean use_common_fork_join_pool;
    @Property(description="Create fibers (if true) or regular threads (if false). This requires Java 15/Loom. If not present, use_fibers will be set to false and regular threads will be created. Note that the ThreadFactoryneeds to support this (DefaultThreadFactory does)")
    protected boolean use_fibers;
    @Property(name="thread_pool.enabled", description="Enable or disable the thread pool")
    protected boolean thread_pool_enabled;
    @Property(name="thread_pool.min_threads", description="Minimum thread pool size for the thread pool")
    protected int thread_pool_min_threads;
    @Property(name="thread_pool.max_threads", description="Maximum thread pool size for the thread pool")
    protected int thread_pool_max_threads;
    @Property(name="thread_pool.keep_alive_time", description="Timeout in milliseconds to remove idle threads from pool")
    protected long thread_pool_keep_alive_time;
    @Property(description="Interval (in ms) at which the time service updates its timestamp. 0 disables the time service")
    protected long time_service_interval;
    @Property(description="Switch to enable diagnostic probing. Default is true")
    protected boolean enable_diagnostics;
    @Property(description="Use a multicast socket to listen for probe requests (ignored if enable_diagnostics is false)")
    protected boolean diag_enable_udp;
    @Property(description="Use a TCP socket to listen for probe requests (ignored if enable_diagnostics is false)")
    protected boolean diag_enable_tcp;
    @Property(description="Multicast address for diagnostic probing. Used when diag_enable_udp is true", defaultValueIPv4="224.0.75.75", defaultValueIPv6="ff0e::0:75:75")
    protected InetAddress diagnostics_addr;
    @Property(description="Bind address for diagnostic probing. Used when diag_enable_tcp is true")
    protected InetAddress diagnostics_bind_addr;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addresses or interface names) that the diagnostics multicast socket should bind to")
    protected List<NetworkInterface> diagnostics_bind_interfaces;
    @Property(description="Port for diagnostic probing. Default is 7500")
    protected int diagnostics_port;
    @Property(description="The number of ports to be probed for an available port (TCP)")
    protected int diagnostics_port_range;
    @Property(description="TTL of the diagnostics multicast socket")
    protected int diagnostics_ttl;
    @Property(description="Authorization passcode for diagnostics. If specified every probe query will be authorized")
    protected String diagnostics_passcode;
    @Property(description="whether or not warnings about messages from different groups are logged")
    protected boolean log_discard_msgs;
    @Property(description="whether or not warnings about messages from members with a different version are discarded")
    protected boolean log_discard_msgs_version;
    @Property(description="Timeout (in ms) to determine how long to wait until a request to fetch the physical address for a given logical address will be sent again. Subsequent requests for the same physical address will therefore be spaced at least who_has_cache_timeout ms apart")
    protected long who_has_cache_timeout;
    @Property(description="Time during which identical warnings about messages from a member with a different version will be suppressed. 0 disables this (every warning will be logged). Setting the log level to ERROR also disables this.")
    protected long suppress_time_different_version_warnings;
    @Property(description="Time during which identical warnings about messages from a member from a different cluster will be suppressed. 0 disables this (every warning will be logged). Setting the log level to ERROR also disables this.")
    protected long suppress_time_different_cluster_warnings;
    @Property(description="The number of times a thread pool needs to be full before a thread dump is logged")
    protected int thread_dumps_threshold;
    protected final AtomicInteger thread_dumps;
    @Property(name="max_bundle_size", description="Maximum number of bytes for messages to be queued until they are sent")
    protected int max_bundle_size;
    @Property(description="The type of bundler used (\"ring-buffer\", \"transfer-queue\" (default), \"sender-sends\" or \"no-bundler\") or the fully qualified classname of a Bundler implementation")
    protected String bundler_type;
    @Property(description="The max number of elements in a bundler if the bundler supports size limitations")
    protected int bundler_capacity;
    @Property(description="Number of spins before a real lock is acquired")
    protected int bundler_num_spins;
    @Property(description="The wait strategy for a RingBuffer")
    protected String bundler_wait_strategy;
    protected final MsgStats msg_stats;
    @ManagedAttribute(description="Channel (cluster) name")
    protected AsciiString cluster_name;
    @ManagedAttribute(description="If enabled, the timer will run non-blocking tasks on its own (runner) thread, and not submit them to the thread pool. Otherwise, all tasks are submitted to the thread pool. This attribute is experimental and may be removed without notice.")
    protected boolean timer_handle_non_blocking_tasks;
    protected Address local_addr;
    protected PhysicalAddress local_physical_addr;
    protected volatile View view;
    protected final Set<Address> members;
    protected final ReentrantLock connectLock;
    protected Executor thread_pool;
    protected ThreadFactory thread_factory;
    protected ThreadFactory internal_thread_factory;
    protected Executor internal_pool;
    protected TimeScheduler timer;
    protected TimeService time_service;
    protected SocketFactory socket_factory;
    protected Bundler bundler;
    protected MessageProcessingPolicy msg_processing_policy;
    protected DiagnosticsHandler diag_handler;
    protected final List<DiagnosticsHandler.ProbeHandler> preregistered_probe_handlers;
    protected TpHeader header;
    protected LazyRemovalCache<Address, PhysicalAddress> logical_addr_cache;
    protected long last_discovery_request;
    protected Future<?> logical_addr_cache_reaper;
    protected final AverageMinMax avg_batch_size;
    protected static final LazyRemovalCache.Printable<Address, LazyRemovalCache.Entry<PhysicalAddress>> print_function = (logical_addr, entry) -> {
        StringBuilder sb = new StringBuilder();
        String tmp_logical_name = NameCache.get(logical_addr);
        if (tmp_logical_name != null) {
            sb.append(tmp_logical_name).append(": ");
        }
        if (logical_addr instanceof UUID) {
            sb.append(((UUID)logical_addr).toStringLong()).append(": ");
        }
        sb.append(entry.toString(val -> val instanceof PhysicalAddress ? val.printIpAddress() : val.toString()));
        sb.append("\n");
        return sb.toString();
    };
    protected ExpiryCache<Address> who_has_cache;
    protected SuppressLog<Address> suppress_log_different_version;
    protected SuppressLog<Address> suppress_log_different_cluster;

    @ManagedAttribute(description="Fully qualified classname of bundler")
    public String getBundlerClass() {
        return this.bundler != null ? this.bundler.getClass().getName() : "null";
    }

    public <T extends TP> T setMaxBundleSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("max_bundle_size (" + size + ") is <= 0");
        }
        this.max_bundle_size = size;
        return (T)this;
    }

    public final int getMaxBundleSize() {
        return this.max_bundle_size;
    }

    public int getBundlerCapacity() {
        return this.bundler_capacity;
    }

    public <T extends TP> T setBundlerCapacity(int c) {
        this.bundler_capacity = c;
        return (T)this;
    }

    public int getMessageProcessingMaxBufferSize() {
        return this.msg_processing_max_buffer_size;
    }

    public boolean useFibers() {
        return this.use_fibers;
    }

    public int getThreadDumpsThreshold() {
        return this.thread_dumps_threshold;
    }

    public <T extends TP> T setThreadDumpsThreshold(int t) {
        this.thread_dumps_threshold = t;
        return (T)this;
    }

    @ManagedAttribute
    public int getBundlerBufferSize() {
        if (this.bundler instanceof TransferQueueBundler) {
            return ((TransferQueueBundler)this.bundler).getBufferSize();
        }
        return this.bundler != null ? this.bundler.size() : 0;
    }

    @ManagedAttribute(description="The wait strategy for a RingBuffer")
    public String bundlerWaitStrategy() {
        return this.bundler instanceof RingBufferBundler ? ((RingBufferBundler)this.bundler).waitStrategy() : this.bundler_wait_strategy;
    }

    @ManagedAttribute(description="Sets the wait strategy in the RingBufferBundler. Allowed values are \"spin\", \"yield\", \"park\", \"spin-park\" and \"spin-yield\" or a fully qualified classname")
    public <T extends TP> T bundlerWaitStrategy(String strategy) {
        if (this.bundler instanceof RingBufferBundler) {
            ((RingBufferBundler)this.bundler).waitStrategy(strategy);
            this.bundler_wait_strategy = strategy;
        } else {
            this.bundler_wait_strategy = strategy;
        }
        return (T)this;
    }

    @ManagedAttribute(description="Number of spins before a real lock is acquired")
    public int bundlerNumSpins() {
        return this.bundler instanceof RingBufferBundler ? ((RingBufferBundler)this.bundler).numSpins() : this.bundler_num_spins;
    }

    @ManagedAttribute(description="Sets the number of times a thread spins until a real lock is acquired")
    public <T extends TP> T bundlerNumSpins(int spins) {
        this.bundler_num_spins = spins;
        if (this.bundler instanceof RingBufferBundler) {
            ((RingBufferBundler)this.bundler).numSpins(spins);
        }
        return (T)this;
    }

    @ManagedAttribute(description="Is the logical_addr_cache reaper task running")
    public boolean isLogicalAddressCacheReaperRunning() {
        return this.logical_addr_cache_reaper != null && !this.logical_addr_cache_reaper.isDone();
    }

    @ManagedAttribute(description="Returns the average batch size of received batches")
    public String getAvgBatchSize() {
        return this.avg_batch_size.toString();
    }

    public AverageMinMax avgBatchSize() {
        return this.avg_batch_size;
    }

    public <T extends TP> T setThreadPoolMinThreads(int size) {
        this.thread_pool_min_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
        return (T)this;
    }

    public int getThreadPoolMinThreads() {
        return this.thread_pool_min_threads;
    }

    public <T extends TP> T setThreadPoolMaxThreads(int size) {
        this.thread_pool_max_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
        return (T)this;
    }

    public int getThreadPoolMaxThreads() {
        return this.thread_pool_max_threads;
    }

    public <T extends TP> T setThreadPoolKeepAliveTime(long time) {
        this.thread_pool_keep_alive_time = time;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
        return (T)this;
    }

    public long getThreadPoolKeepAliveTime() {
        return this.thread_pool_keep_alive_time;
    }

    @Override
    public Object[] getJmxObjects() {
        return new Object[]{this.msg_stats, this.msg_processing_policy, this.bundler};
    }

    @Override
    @Property(name="level", description="Sets the level")
    public <T extends Protocol> T setLevel(String level) {
        Object retval = super.setLevel(level);
        this.is_trace = this.log.isTraceEnabled();
        return retval;
    }

    @ManagedAttribute(description="Number of thread dumps")
    public int getNumberOfThreadDumps() {
        return this.thread_dumps.get();
    }

    @ManagedOperation(description="Resets the thread_dumps counter")
    public void resetThreadDumps() {
        this.thread_dumps.set(0);
    }

    @ManagedOperation(description="Changes the message processing policy. The fully qualified name of a class implementing MessageProcessingPolicy needs to be given")
    public void setMessageProcessingPolicy(String policy) {
        if (policy == null) {
            return;
        }
        if (policy.startsWith("submit")) {
            this.msg_processing_policy = new SubmitToThreadPool();
            this.msg_processing_policy.init(this);
            return;
        }
        if (policy.startsWith("max")) {
            this.msg_processing_policy = new MaxOneThreadPerSender();
            this.msg_processing_policy.init(this);
            return;
        }
        try {
            Class clazz = Util.loadClass(policy, this.getClass());
            this.msg_processing_policy = (MessageProcessingPolicy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.message_processing_policy = policy;
            this.msg_processing_policy.init(this);
        }
        catch (Exception e) {
            this.log.error("failed setting message_processing_policy", e);
        }
    }

    @ManagedAttribute(description="Class of the timer implementation")
    public String getTimerClass() {
        return this.timer != null ? this.timer.getClass().getSimpleName() : "null";
    }

    @ManagedAttribute(description="Name of the cluster to which this transport is connected")
    public String getClusterName() {
        return this.cluster_name != null ? this.cluster_name.toString() : null;
    }

    public AsciiString getClusterNameAscii() {
        return this.cluster_name;
    }

    @ManagedAttribute(description="Number of messages from members in a different cluster")
    public int getDifferentClusterMessages() {
        return this.suppress_log_different_cluster != null ? this.suppress_log_different_cluster.getCache().size() : 0;
    }

    @ManagedAttribute(description="Number of messages from members with a different JGroups version")
    public int getDifferentVersionMessages() {
        return this.suppress_log_different_version != null ? this.suppress_log_different_version.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the cache for messages from different clusters")
    public <T extends TP> T clearDifferentClusterCache() {
        if (this.suppress_log_different_cluster != null) {
            this.suppress_log_different_cluster.getCache().clear();
        }
        return (T)this;
    }

    @ManagedOperation(description="Clears the cache for messages from members with different versions")
    public <T extends TP> T clearDifferentVersionCache() {
        if (this.suppress_log_different_version != null) {
            this.suppress_log_different_version.getCache().clear();
        }
        return (T)this;
    }

    @ManagedAttribute(description="Type of logger used")
    public static String loggerType() {
        return LogFactory.loggerType();
    }

    @ManagedOperation(description="If enabled, the timer will run non-blocking tasks on its own (runner) thread, and not submit them to the thread pool. Otherwise, all tasks are submitted to the thread pool. This attribute is experimental and may be removed without notice.")
    public <T extends TP> T enableBlockingTimerTasks(boolean flag) {
        if (flag != this.timer_handle_non_blocking_tasks) {
            this.timer_handle_non_blocking_tasks = flag;
            this.timer.setNonBlockingTaskHandling(flag);
        }
        return (T)this;
    }

    protected TP() {
        this.is_trace = this.log.isTraceEnabled();
        this.logical_addr_cache_max_size = 2000;
        this.logical_addr_cache_expiration = 360000L;
        this.logical_addr_cache_reaper_interval = 60000L;
        this.port_range = 10;
        this.loopback_separate_thread = true;
        this.msg_processing_max_buffer_size = 5000;
        this.thread_naming_pattern = "cl";
        this.thread_pool_enabled = true;
        this.thread_pool_min_threads = 0;
        this.thread_pool_max_threads = 100;
        this.thread_pool_keep_alive_time = 30000L;
        this.time_service_interval = 500L;
        this.enable_diagnostics = true;
        this.diag_enable_udp = true;
        this.diagnostics_port = 7500;
        this.diagnostics_port_range = 50;
        this.diagnostics_ttl = 8;
        this.log_discard_msgs = true;
        this.log_discard_msgs_version = true;
        this.who_has_cache_timeout = 2000L;
        this.suppress_time_different_version_warnings = 60000L;
        this.suppress_time_different_cluster_warnings = 60000L;
        this.thread_dumps_threshold = 1;
        this.thread_dumps = new AtomicInteger();
        this.max_bundle_size = 64000;
        this.bundler_type = "transfer-queue";
        this.bundler_capacity = 16384;
        this.bundler_num_spins = 5;
        this.bundler_wait_strategy = "park";
        this.msg_stats = new MsgStats();
        this.timer_handle_non_blocking_tasks = true;
        this.members = new CopyOnWriteArraySet<Address>();
        this.connectLock = new ReentrantLock();
        this.socket_factory = new DefaultSocketFactory();
        this.msg_processing_policy = new MaxOneThreadPerSender();
        this.preregistered_probe_handlers = new LinkedList<DiagnosticsHandler.ProbeHandler>();
        this.avg_batch_size = new AverageMinMax();
    }

    public MsgStats getMessageStats() {
        return this.msg_stats;
    }

    public abstract boolean supportsMulticasting();

    public boolean isMulticastCapable() {
        return this.supportsMulticasting();
    }

    public String toString() {
        return this.local_addr != null ? this.getName() + "(local address: " + this.local_addr + ')' : this.getName();
    }

    @ManagedAttribute(description="The address of the channel")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : null;
    }

    public Address localAddress() {
        return this.local_addr;
    }

    public View view() {
        return this.view;
    }

    @ManagedAttribute(description="The physical address of the channel")
    public String getLocalPhysicalAddress() {
        return this.local_physical_addr != null ? this.local_physical_addr.printIpAddress() : null;
    }

    @Override
    public void resetStats() {
        this.msg_stats.reset();
        this.avg_batch_size.clear();
        this.msg_processing_policy.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TP> T registerProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.registerProbeHandler(handler);
        } else {
            List<DiagnosticsHandler.ProbeHandler> list = this.preregistered_probe_handlers;
            synchronized (list) {
                this.preregistered_probe_handlers.add(handler);
            }
        }
        return (T)this;
    }

    public <T extends TP> T unregisterProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.unregisterProbeHandler(handler);
        }
        return (T)this;
    }

    public DiagnosticsHandler getDiagnosticsHandler() {
        return this.diag_handler;
    }

    public <T extends TP> T setDiagnosticsHandler(DiagnosticsHandler handler) throws Exception {
        if (handler != null) {
            if (this.diag_handler != null) {
                this.diag_handler.stop();
            }
            this.diag_handler = handler;
            if (this.diag_handler != null) {
                this.diag_handler.start();
            }
        }
        return (T)this;
    }

    public Bundler getBundler() {
        return this.bundler;
    }

    public <T extends TP> T setBundler(Bundler bundler) {
        if (bundler != null) {
            this.bundler = bundler;
        }
        return (T)this;
    }

    public Executor getThreadPool() {
        return this.thread_pool;
    }

    public <T extends TP> T setThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            TP.shutdownThreadPool(this.thread_pool);
        }
        this.thread_pool = thread_pool;
        if (this.timer instanceof TimeScheduler3) {
            ((TimeScheduler3)this.timer).setThreadPool(thread_pool);
        }
        return (T)this;
    }

    public ThreadFactory getThreadPoolThreadFactory() {
        return this.thread_factory;
    }

    public <T extends TP> T setThreadPoolThreadFactory(ThreadFactory factory) {
        this.thread_factory = factory;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setThreadFactory(factory);
        }
        return (T)this;
    }

    public Executor getInternalThreadPool() {
        return this.internal_pool;
    }

    public <T extends TP> T setInternalThreadPool(Executor thread_pool) {
        if (this.internal_pool != null) {
            TP.shutdownThreadPool(this.internal_pool);
        }
        this.internal_pool = thread_pool;
        return (T)this;
    }

    public ThreadFactory getInternalThreadPoolThreadFactory() {
        return this.internal_thread_factory;
    }

    public <T extends TP> T setInternalThreadPoolThreadFactory(ThreadFactory factory) {
        this.internal_thread_factory = factory;
        if (this.internal_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.internal_pool).setThreadFactory(factory);
        }
        return (T)this;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public <T extends TP> T setTimer(TimeScheduler timer) {
        this.timer = timer;
        return (T)this;
    }

    public TimeService getTimeService() {
        return this.time_service;
    }

    public <T extends TP> T setTimeService(TimeService ts) {
        if (ts == null) {
            return (T)this;
        }
        if (this.time_service != null) {
            this.time_service.stop();
        }
        this.time_service = ts;
        this.time_service.start();
        return (T)this;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.thread_factory;
    }

    public <T extends TP> T setThreadFactory(ThreadFactory factory) {
        this.thread_factory = factory;
        return (T)this;
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        if (factory != null) {
            this.socket_factory = factory;
        }
    }

    public String getThreadNamingPattern() {
        return this.thread_naming_pattern;
    }

    public long getNumMessagesSent() {
        return this.msg_stats.getNumMsgsSent();
    }

    public <T extends TP> T incrBatchesSent(int delta) {
        if (this.stats) {
            this.msg_stats.incrNumBatchesSent(delta);
        }
        return (T)this;
    }

    public <T extends TP> T incrNumSingleMsgsSent(int d) {
        if (this.stats) {
            this.msg_stats.incrNumSingleMsgsSent(d);
        }
        return (T)this;
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public <T extends TP> T setBindAddress(InetAddress a) {
        this.bind_addr = a;
        return (T)this;
    }

    public int getBindPort() {
        return this.bind_port;
    }

    public <T extends TP> T setBindPort(int port) {
        this.bind_port = port;
        return (T)this;
    }

    public <T extends TP> T setBindToAllInterfaces(boolean f) {
        this.receive_on_all_interfaces = f;
        return (T)this;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public <T extends TP> T setPortRange(int range) {
        this.port_range = range;
        return (T)this;
    }

    public int getPortRange() {
        return this.port_range;
    }

    @ManagedAttribute(description="Current number of threads in the thread pool")
    public int getThreadPoolSize() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getPoolSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Current number of active threads in the thread pool")
    public int getThreadPoolSizeActive() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getActiveCount();
        }
        return 0;
    }

    @ManagedAttribute(description="Largest number of threads in the thread pool")
    public int getThreadPoolSizeLargest() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getLargestPoolSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Current number of threads in the internal thread pool")
    public int getInternalThreadPoolSize() {
        if (this.internal_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.internal_pool).getPoolSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Largest number of threads in the internal thread pool")
    public int getInternalThreadPoolSizeLargest() {
        if (this.internal_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.internal_pool).getLargestPoolSize();
        }
        return 0;
    }

    @ManagedAttribute(name="timer_tasks", description="Number of timer tasks queued up for execution")
    public int getNumTimerTasks() {
        return this.timer.size();
    }

    @ManagedOperation
    public String dumpTimerTasks() {
        return this.timer.dumpTimerTasks();
    }

    @ManagedOperation(description="Purges cancelled tasks from the timer queue")
    public void removeCancelledTimerTasks() {
        this.timer.removeCancelledTasks();
    }

    @ManagedAttribute(description="Number of threads currently in the pool")
    public int getTimerThreads() {
        return this.timer.getCurrentThreads();
    }

    @ManagedAttribute(description="Returns the number of live threads in the JVM")
    public static int getNumThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @ManagedAttribute(description="Whether the diagnostics handler is running or not")
    public boolean isDiagnosticsRunning() {
        return this.diag_handler != null && this.diag_handler.isRunning();
    }

    public <T extends TP> T setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
        return (T)this;
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    public <T extends TP> T setLogDiscardMessagesVersion(boolean f) {
        this.log_discard_msgs_version = f;
        return (T)this;
    }

    public boolean getLogDiscardMessagesVersion() {
        return this.log_discard_msgs_version;
    }

    public boolean getUseIpAddresses() {
        return this.use_ip_addrs;
    }

    public boolean isDiagnosticsEnabled() {
        return this.enable_diagnostics;
    }

    public <T extends TP> T setDiagnosticsEnabled(boolean f) {
        this.enable_diagnostics = f;
        return (T)this;
    }

    public boolean isDiagUdEnabled() {
        return this.diag_handler != null && this.diag_handler.udpEnabled();
    }

    public <T extends TP> T diagEnableUdp(boolean f) {
        this.diag_enable_udp = f;
        if (this.diag_handler != null) {
            this.diag_handler.enableUdp(f);
        }
        return (T)this;
    }

    public boolean diagTcpEnabled() {
        return this.diag_enable_tcp;
    }

    public <T extends TP> T diagEnableTcp(boolean f) {
        this.diag_enable_tcp = f;
        if (this.diag_handler != null) {
            this.diag_handler.enableTcp(f);
        }
        return (T)this;
    }

    @ManagedOperation(description="Dumps the contents of the logical address cache")
    public String printLogicalAddressCache() {
        return this.logical_addr_cache.printCache(print_function);
    }

    @ManagedOperation(description="Prints the contents of the who-has cache")
    public String printWhoHasCache() {
        return this.who_has_cache.toString();
    }

    @ManagedOperation(description="Evicts elements in the logical address cache which have expired")
    public void evictLogicalAddressCache() {
        this.evictLogicalAddressCache(false);
    }

    public void evictLogicalAddressCache(boolean force) {
        this.logical_addr_cache.removeMarkedElements(force);
        this.fetchLocalAddresses();
    }

    public abstract void sendMulticast(byte[] var1, int var2, int var3) throws Exception;

    public abstract void sendUnicast(PhysicalAddress var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract String getInfo();

    @Override
    public void init() throws Exception {
        this.id = ClassConfigurator.getProtocolId(TP.class);
        if (this.use_fibers && !Util.fibersAvailable()) {
            this.log.warn("use_fibers was set to false, as fibers are not available in this Java version");
            this.use_fibers = false;
        }
        if (this.thread_factory == null) {
            this.thread_factory = ((DefaultThreadFactory)new LazyThreadFactory("jgroups", false, true).useFibers(this.use_fibers)).log(this.log);
        }
        if (this.internal_thread_factory == null) {
            this.internal_thread_factory = ((DefaultThreadFactory)new LazyThreadFactory("jgroups-int", false, true).useFibers(this.use_fibers)).log(this.log);
        }
        this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
        if (this.enable_diagnostics && this.diag_handler == null) {
            this.diag_handler = this.createDiagnosticsHandler();
        }
        this.who_has_cache = new ExpiryCache(this.who_has_cache_timeout);
        if (this.suppress_time_different_version_warnings > 0L) {
            this.suppress_log_different_version = new SuppressLog(this.log, "VersionMismatch", "SuppressMsg");
        }
        if (this.suppress_time_different_cluster_warnings > 0L) {
            this.suppress_log_different_cluster = new SuppressLog(this.log, "MsgDroppedDiffCluster", "SuppressMsg");
        }
        if (this.use_common_fork_join_pool) {
            this.use_fork_join_pool = true;
        }
        if (this.use_fork_join_pool) {
            this.thread_pool_max_threads = Runtime.getRuntime().availableProcessors();
        }
        if (this.thread_pool == null || this.thread_pool instanceof ExecutorService && ((ExecutorService)this.thread_pool).isShutdown()) {
            if (this.thread_pool_enabled) {
                int num_cores = Runtime.getRuntime().availableProcessors();
                int max_internal_size = Math.max(4, num_cores);
                this.log.debug("thread pool min/max/keep-alive: %d/%d/%d use_fork_join=%b, internal pool: %d/%d/%d (%d cores available)", this.thread_pool_min_threads, this.thread_pool_max_threads, this.thread_pool_keep_alive_time, this.use_fork_join_pool, 0, max_internal_size, 30000, num_cores);
                this.thread_pool = TP.createThreadPool(this.thread_pool_min_threads, this.thread_pool_max_threads, this.thread_pool_keep_alive_time, "abort", new SynchronousQueue<Runnable>(), this.thread_factory, this.log, this.use_fork_join_pool, this.use_common_fork_join_pool);
                this.internal_pool = TP.createThreadPool(0, max_internal_size, 30000L, "abort", new SynchronousQueue<Runnable>(), this.internal_thread_factory, this.log, false, false);
            } else {
                this.thread_pool = new DirectExecutor();
            }
        }
        if (this.timer == null) {
            this.timer = new TimeScheduler3(this.thread_pool, this.thread_factory, false);
            this.timer.setNonBlockingTaskHandling(this.timer_handle_non_blocking_tasks);
        }
        if (this.time_service_interval > 0L) {
            this.time_service = new TimeService(this.timer, this.time_service_interval);
        }
        HashMap<String, Serializable> m = new HashMap<String, Serializable>(2);
        if (this.bind_addr != null) {
            m.put("bind_addr", this.bind_addr);
        }
        if (this.external_addr != null) {
            m.put("external_addr", this.external_addr);
        }
        if (this.external_port > 0) {
            m.put("external_port", Integer.valueOf(this.external_port));
        }
        if (!m.isEmpty()) {
            this.up(new Event(56, m));
        }
        this.logical_addr_cache = new LazyRemovalCache(this.logical_addr_cache_max_size, this.logical_addr_cache_expiration);
        if (this.logical_addr_cache_reaper_interval > 0L && (this.logical_addr_cache_reaper == null || this.logical_addr_cache_reaper.isDone())) {
            this.logical_addr_cache_reaper = this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TP.this.evictLogicalAddressCache();
                }

                public String toString() {
                    return TP.this.getClass().getSimpleName() + ": LogicalAddressCacheReaper (interval=" + TP.this.logical_addr_cache_reaper_interval + " ms)";
                }
            }, this.logical_addr_cache_reaper_interval, this.logical_addr_cache_reaper_interval, TimeUnit.MILLISECONDS, false);
        }
        if (this.message_processing_policy != null) {
            this.setMessageProcessingPolicy(this.message_processing_policy);
        } else {
            this.msg_processing_policy.init(this);
        }
    }

    @Override
    public void start() throws Exception {
        PhysicalAddress tmp;
        this.timer.start();
        if (this.time_service != null) {
            this.time_service.start();
        }
        if (this.use_ip_addrs && (tmp = this.getPhysicalAddress()) instanceof IpAddress) {
            this.local_addr = new IpAddressUUID(((IpAddress)tmp).getIpAddress(), ((IpAddress)tmp).getPort());
            this.stack.getTopProtocol().down(new Event(8, this.local_addr));
            this.stack.getTopProtocol().up(new Event(8, this.local_addr));
        }
        this.fetchLocalAddresses();
        this.startDiagnostics();
        if (this.bundler == null) {
            this.bundler = this.createBundler(this.bundler_type);
        }
        this.bundler.init(this);
        this.bundler.start();
        this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
    }

    @Override
    public void stop() {
        this.stopDiagnostics();
        if (this.bundler != null) {
            this.bundler.stop();
            this.bundler = null;
        }
        if (this.msg_processing_policy != null) {
            this.msg_processing_policy.destroy();
        }
        if (this.time_service != null) {
            this.time_service.stop();
        }
        this.timer.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.logical_addr_cache_reaper != null) {
            this.logical_addr_cache_reaper.cancel(false);
            this.logical_addr_cache_reaper = null;
        }
        if (this.thread_pool instanceof ExecutorService) {
            TP.shutdownThreadPool(this.thread_pool);
        }
        if (this.internal_pool instanceof ExecutorService) {
            TP.shutdownThreadPool(this.internal_pool);
        }
    }

    @ManagedAttribute(description="Returns stats about the current bundler")
    public String bundlerStats() {
        Map<String, Object> tmp = this.bundler != null ? this.bundler.getStats() : null;
        return tmp != null ? tmp.toString() : "n/a";
    }

    @ManagedOperation(description="Resets stats of the current bundler")
    public void bundlerStatsReset() {
        this.bundler.resetStats();
    }

    @ManagedOperation(description="Creates and sets a new bundler. Type has to be either a bundler_type or the fully qualified classname of a Bundler impl. Stops the current bundler (if running)")
    public <T extends TP> T bundler(String type) {
        Bundler new_bundler = this.createBundler(type);
        String old_bundler_class = null;
        if (this.bundler != null) {
            this.bundler.stop();
            old_bundler_class = this.bundler.getClass().getName();
        }
        new_bundler.init(this);
        new_bundler.start();
        this.bundler = new_bundler;
        this.bundler_type = type;
        if (old_bundler_class != null) {
            this.log.debug("%s: replaced bundler %s with %s", this.local_addr, old_bundler_class, this.bundler.getClass().getName());
        }
        return (T)this;
    }

    @ManagedOperation(description="Enables diagnostics and starts DiagnosticsHandler (if not running)")
    public void enableDiagnostics() {
        this.enable_diagnostics = true;
        try {
            this.startDiagnostics();
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedStartingDiagnostics"), e);
        }
    }

    @ManagedOperation(description="Disables diagnostics and stops DiagnosticsHandler (if running)")
    public void disableDiagnostics() {
        this.enable_diagnostics = false;
        this.stopDiagnostics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDiagnostics() throws Exception {
        List<DiagnosticsHandler.ProbeHandler> list;
        if (this.enable_diagnostics) {
            if (this.diag_handler == null) {
                this.diag_handler = this.createDiagnosticsHandler();
            }
            this.diag_handler.registerProbeHandler(this);
            this.diag_handler.start();
            list = this.preregistered_probe_handlers;
            synchronized (list) {
                for (DiagnosticsHandler.ProbeHandler handler : this.preregistered_probe_handlers) {
                    this.diag_handler.registerProbeHandler(handler);
                }
            }
        }
        list = this.preregistered_probe_handlers;
        synchronized (list) {
            this.preregistered_probe_handlers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopDiagnostics() {
        if (this.diag_handler != null) {
            this.diag_handler.unregisterProbeHandler(this);
            this.diag_handler.stop();
        }
        List<DiagnosticsHandler.ProbeHandler> list = this.preregistered_probe_handlers;
        synchronized (list) {
            this.preregistered_probe_handlers.clear();
        }
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        HashMap<String, String> retval = new HashMap<String, String>(keys != null ? keys.length : 2);
        if (keys == null) {
            return retval;
        }
        String[] stringArray = keys;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String key;
            switch (key = stringArray[i]) {
                case "dump": {
                    retval.put(key, Util.dumpThreads());
                    continue block12;
                }
                case "uuids": {
                    retval.put(key, this.printLogicalAddressCache());
                    if (retval.containsKey("local_addr")) continue block12;
                    retval.put("local_addr", this.local_addr != null ? this.local_addr.toString() : null);
                    continue block12;
                }
                case "keys": {
                    StringBuilder sb = new StringBuilder();
                    if (this.diag_handler != null) {
                        for (DiagnosticsHandler.ProbeHandler handler : this.diag_handler.getProbeHandlers()) {
                            String[] tmp = handler.supportedKeys();
                            if (tmp == null || tmp.length <= 0) continue;
                            for (String s : tmp) {
                                sb.append(s).append(" ");
                            }
                        }
                    }
                    retval.put(key, sb.toString());
                    continue block12;
                }
                case "member-addrs": {
                    Set<PhysicalAddress> physical_addrs = this.logical_addr_cache.nonRemovedValues();
                    String list = Util.print(physical_addrs);
                    retval.put(key, list);
                }
            }
        }
        return retval;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"dump", "keys", "uuids", "member-addrs"};
    }

    protected void handleConnect() throws Exception {
    }

    protected void handleDisconnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Set<Address> set = this.members;
                synchronized (set) {
                    View v;
                    this.view = v = (View)evt.getArg();
                    ArrayList<Address> old_members = new ArrayList<Address>(this.members);
                    this.members.clear();
                    this.members.addAll(v.getMembers());
                    this.logical_addr_cache.retainAll(this.members);
                    this.fetchLocalAddresses();
                    List<Address> left_mbrs = Util.leftMembers(old_members, this.members);
                    if (left_mbrs != null && !left_mbrs.isEmpty()) {
                        NameCache.removeAll(left_mbrs);
                    }
                    if (this.suppress_log_different_version != null) {
                        this.suppress_log_different_version.removeExpired(this.suppress_time_different_version_warnings);
                    }
                    if (this.suppress_log_different_cluster != null) {
                        this.suppress_log_different_cluster.removeExpired(this.suppress_time_different_cluster_warnings);
                    }
                }
                this.who_has_cache.removeExpiredElements();
                if (this.bundler != null) {
                    this.bundler.viewChange((View)evt.getArg());
                }
                if (!(this.msg_processing_policy instanceof MaxOneThreadPerSender)) break;
                ((MaxOneThreadPerSender)this.msg_processing_policy).viewChange(this.view.getMembers());
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = new AsciiString((String)evt.getArg());
                this.header = new TpHeader(this.cluster_name);
                this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
                this.setThreadNames();
                this.connectLock.lock();
                try {
                    this.handleConnect();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.connectLock.unlock();
                }
                return null;
            }
            case 4: {
                this.unsetThreadNames();
                this.connectLock.lock();
                try {
                    this.handleDisconnect();
                    break;
                }
                finally {
                    this.connectLock.unlock();
                }
            }
            case 87: {
                Address addr = (Address)evt.getArg();
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(addr);
                if (physical_addr != null) {
                    return physical_addr;
                }
                if (Objects.equals(addr, this.local_addr) && (physical_addr = this.getPhysicalAddress()) != null) {
                    this.addPhysicalAddressToCache(addr, physical_addr);
                }
                return physical_addr;
            }
            case 102: {
                return this.getAllPhysicalAddressesFromCache();
            }
            case 88: {
                Object arg = evt.getArg();
                boolean skip_removed_values = arg instanceof Boolean && (Boolean)arg != false;
                return this.logical_addr_cache.contents(skip_removed_values);
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                return this.addPhysicalAddressToCache((Address)tuple.getVal1(), (PhysicalAddress)tuple.getVal2());
            }
            case 90: {
                this.removeLogicalAddressFromCache((Address)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.registerLocalAddress((Address)evt.getArg());
            }
        }
        return null;
    }

    @Override
    public Object down(Message msg) {
        boolean loop_back;
        if (this.header != null) {
            msg.putHeader(this.id, this.header);
        }
        this.setSourceAddress(msg);
        Address dest = msg.getDest();
        Address sender = msg.getSrc();
        if (this.is_trace) {
            this.log.trace("%s: sending msg to %s, src=%s, size=%d, headers are %s", this.local_addr, dest, sender, msg.size(), msg.printHeaders());
        }
        boolean multicast = dest == null;
        boolean do_send = multicast || !dest.equals(sender);
        boolean bl = loop_back = (multicast || dest.equals(sender)) && !msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK);
        if (dest instanceof PhysicalAddress && dest.equals(this.local_physical_addr)) {
            loop_back = true;
            do_send = false;
        }
        if (this.loopback_separate_thread) {
            if (loop_back) {
                this.loopback(msg, multicast);
            }
            if (do_send) {
                this._send(msg, dest);
            }
        } else {
            if (do_send) {
                this._send(msg, dest);
            }
            if (loop_back) {
                this.loopback(msg, multicast);
            }
        }
        return null;
    }

    protected DiagnosticsHandler createDiagnosticsHandler() {
        return new DiagnosticsHandler(this.diagnostics_addr, this.diagnostics_port, this.diagnostics_bind_interfaces, this.diagnostics_ttl, this.log, this.getSocketFactory(), this.getThreadFactory(), this.diagnostics_passcode).transport(this).setDiagnosticsBindAddress(this.diagnostics_bind_addr).enableUdp(this.diag_enable_udp).enableTcp(this.diag_enable_tcp).setDiagnosticsPortRange(this.diagnostics_port_range);
    }

    protected Bundler createBundler(String type) {
        if (type == null) {
            throw new IllegalArgumentException("bundler type has to be non-null");
        }
        switch (type) {
            case "transfer-queue": 
            case "tq": {
                return new TransferQueueBundler(this.bundler_capacity);
            }
            case "simplified-transfer-queue": 
            case "stq": {
                return new SimplifiedTransferQueueBundler(this.bundler_capacity);
            }
            case "sender-sends": 
            case "ss": {
                return new SenderSendsBundler();
            }
            case "ring-buffer": 
            case "rb": {
                return new RingBufferBundler(this.bundler_capacity).numSpins(this.bundler_num_spins).waitStrategy(this.bundler_wait_strategy);
            }
            case "ring-buffer-lockless": 
            case "rbl": {
                return new RingBufferBundlerLockless(this.bundler_capacity);
            }
            case "ring-buffer-lockless2": 
            case "rbl2": {
                return new RingBufferBundlerLockless2(this.bundler_capacity);
            }
            case "no-bundler": 
            case "nb": {
                return new NoBundler();
            }
            case "async-no-bundler": 
            case "anb": {
                return new AsyncNoBundler();
            }
            case "ab": 
            case "alternating-bundler": {
                return new AlternatingBundler();
            }
            case "rqb": 
            case "rq": 
            case "remove-queue-bundler": 
            case "remove-queue": {
                return new RemoveQueueBundler();
            }
        }
        try {
            Class clazz = Util.loadClass(type, this.getClass());
            return (Bundler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            this.log.warn("failed creating instance of bundler %s: %s", type, t);
            return new TransferQueueBundler(this.bundler_capacity);
        }
    }

    protected void loopback(Message msg, boolean multicast) {
        Message copy;
        Message message = copy = this.loopback_copy ? msg.copy() : msg;
        if (this.is_trace) {
            this.log.trace("%s: looping back message %s, headers are %s", this.local_addr, copy, copy.printHeaders());
        }
        if (!this.loopback_separate_thread) {
            this.passMessageUp(copy, null, false, multicast, false);
            return;
        }
        boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
        boolean oob = msg.isFlagSet(Message.Flag.OOB);
        this.msg_processing_policy.loopback(msg, oob, internal);
    }

    protected void _send(Message msg, Address dest) {
        try {
            this.send(msg);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (InterruptedException interruptedEx) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("SendFailure"), this.local_addr, dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void setSourceAddress(Message msg) {
        if (msg.getSrc() == null && this.local_addr != null) {
            msg.setSrc(this.local_addr);
        }
    }

    public void passMessageUp(Message msg, byte[] cluster_name, boolean perform_cluster_name_matching, boolean multicast, boolean discard_own_mcast) {
        if (this.is_trace) {
            this.log.trace("%s: received %s, headers are %s", this.local_addr, msg, msg.printHeaders());
        }
        if (this.up_prot == null) {
            return;
        }
        if (multicast && discard_own_mcast && this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
            return;
        }
        if (perform_cluster_name_matching && this.cluster_name != null && !this.cluster_name.equals(cluster_name)) {
            if (this.log_discard_msgs && this.log.isWarnEnabled()) {
                Address sender = msg.getSrc();
                if (this.suppress_log_different_cluster != null) {
                    this.suppress_log_different_cluster.log(SuppressLog.Level.warn, sender, this.suppress_time_different_cluster_warnings, new AsciiString(cluster_name), this.cluster_name, sender);
                } else {
                    this.log.warn(Util.getMessage("MsgDroppedDiffCluster"), new AsciiString(cluster_name), this.cluster_name, sender);
                }
            }
            return;
        }
        this.up_prot.up(msg);
    }

    public void passBatchUp(MessageBatch batch, boolean perform_cluster_name_matching, boolean discard_own_mcast) {
        if (this.is_trace) {
            this.log.trace("%s: received message batch of %d messages from %s", this.local_addr, batch.size(), batch.sender());
        }
        if (this.up_prot == null) {
            return;
        }
        if (perform_cluster_name_matching && this.cluster_name != null && !this.cluster_name.equals(batch.clusterName())) {
            if (this.log_discard_msgs && this.log.isWarnEnabled()) {
                Address sender = batch.sender();
                if (this.suppress_log_different_cluster != null) {
                    this.suppress_log_different_cluster.log(SuppressLog.Level.warn, sender, this.suppress_time_different_cluster_warnings, batch.clusterName(), this.cluster_name, sender);
                } else {
                    this.log.warn(Util.getMessage("BatchDroppedDiffCluster"), batch.clusterName(), this.cluster_name, sender);
                }
            }
            return;
        }
        if (batch.multicast() && discard_own_mcast && this.local_addr != null && this.local_addr.equals(batch.sender())) {
            return;
        }
        this.up_prot.up(batch);
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        if (data == null) {
            return;
        }
        if (Objects.equals(this.local_physical_addr, sender)) {
            return;
        }
        if (length < 3) {
            return;
        }
        short version = Bits.readShort(data, offset);
        if (!this.versionMatch(version, sender)) {
            return;
        }
        byte flags = data[offset += 2];
        boolean is_message_list = (flags & 1) == 1;
        boolean multicast = (flags & 2) == 2;
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, ++offset, length);
        if (is_message_list) {
            this.handleMessageBatch(in, multicast);
        } else {
            this.handleSingleMessage(in, multicast);
        }
    }

    public void receive(Address sender, DataInput in) throws Exception {
        boolean multicast;
        if (in == null) {
            return;
        }
        if (Objects.equals(this.local_physical_addr, sender)) {
            return;
        }
        short version = in.readShort();
        if (!this.versionMatch(version, sender)) {
            return;
        }
        byte flags = in.readByte();
        boolean is_message_list = (flags & 1) == 1;
        boolean bl = multicast = (flags & 2) == 2;
        if (is_message_list) {
            this.handleMessageBatch(in, multicast);
        } else {
            this.handleSingleMessage(in, multicast);
        }
    }

    protected void handleMessageBatch(DataInput in, boolean multicast) {
        try {
            MessageBatch[] batches = Util.readMessageBatch(in, multicast);
            MessageBatch batch = batches[0];
            MessageBatch oob_batch = batches[1];
            MessageBatch internal_batch_oob = batches[2];
            MessageBatch internal_batch = batches[3];
            this.processBatch(oob_batch, true, false);
            this.processBatch(batch, false, false);
            this.processBatch(internal_batch_oob, true, true);
            this.processBatch(internal_batch, false, true);
        }
        catch (Throwable t) {
            this.log.error(String.format(Util.getMessage("IncomingMsgFailure"), this.local_addr), t);
        }
    }

    protected void handleSingleMessage(DataInput in, boolean multicast) {
        try {
            Message msg = new Message(false);
            msg.readFrom(in);
            if (!multicast && this.unicastDestMismatch(msg.getDest())) {
                return;
            }
            boolean oob = msg.isFlagSet(Message.Flag.OOB);
            boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
            this.msg_processing_policy.process(msg, oob, internal);
        }
        catch (Throwable t) {
            this.log.error(String.format(Util.getMessage("IncomingMsgFailure"), this.local_addr), t);
        }
    }

    protected void processBatch(MessageBatch batch, boolean oob, boolean internal) {
        try {
            if (batch != null && !batch.isEmpty() && !this.unicastDestMismatch(batch.getDest())) {
                this.msg_processing_policy.process(batch, oob, internal);
            }
        }
        catch (Throwable t) {
            this.log.error("processing batch failed", t);
        }
    }

    public boolean unicastDestMismatch(Address dest) {
        return dest != null && !Objects.equals(dest, this.local_addr) && !Objects.equals(dest, this.local_physical_addr);
    }

    public boolean submitToThreadPool(Runnable task, boolean spawn_thread_on_rejection) {
        return this.submitToThreadPool(this.thread_pool, task, spawn_thread_on_rejection, true);
    }

    public boolean submitToThreadPool(Executor pool, Runnable task, boolean spawn_thread_on_rejection, boolean forward_to_internal_pool) {
        try {
            pool.execute(task);
        }
        catch (RejectedExecutionException ex) {
            if (!spawn_thread_on_rejection) {
                this.msg_stats.incrNumRejectedMsgs(1);
                if (this.thread_dumps.incrementAndGet() == this.thread_dumps_threshold) {
                    this.log.fatal("%s: thread pool is full (max=%d, active=%d); thread dump (dumped once, until thread_dump is reset):\n%s", this.local_addr, this.getThreadPoolMaxThreads(), this.getThreadPoolSize(), Util.dumpThreads());
                }
                return false;
            }
            if (forward_to_internal_pool && this.internal_pool != null) {
                return this.submitToThreadPool(this.internal_pool, task, true, false);
            }
            this.msg_stats.incrNumThreadsSpawned(1);
            return this.runInNewThread(task);
        }
        catch (Throwable t) {
            this.log.error("failure submitting task to thread pool", t);
            this.msg_stats.incrNumRejectedMsgs(1);
            return false;
        }
        return true;
    }

    protected boolean runInNewThread(Runnable task) {
        try {
            Thread thread = this.thread_factory != null ? this.thread_factory.newThread(task, "jgroups-temp-thread") : new Thread(task, "jgroups-temp-thread");
            thread.start();
            return true;
        }
        catch (Throwable t) {
            this.log.error("failed spawning new thread", t);
            return false;
        }
    }

    protected boolean versionMatch(short version, Address sender) {
        boolean match = Version.isBinaryCompatible(version);
        if (!match && this.log_discard_msgs_version && this.log.isWarnEnabled()) {
            if (this.suppress_log_different_version != null) {
                this.suppress_log_different_version.log(SuppressLog.Level.warn, sender, this.suppress_time_different_version_warnings, sender, Version.print(version), Version.printVersion());
            } else {
                this.log.warn(Util.getMessage("VersionMismatch"), sender, Version.print(version), Version.printVersion());
            }
        }
        return match;
    }

    protected void send(Message msg) throws Exception {
        Bundler tmp_bundler = this.bundler;
        if (tmp_bundler != null) {
            tmp_bundler.send(msg);
        }
    }

    public void doSend(byte[] buf, int offset, int length, Address dest) throws Exception {
        if (this.stats) {
            this.msg_stats.incrNumMsgsSent(1);
            this.msg_stats.incrNumBytesSent(length);
        }
        if (dest == null) {
            this.sendMulticast(buf, offset, length);
        } else {
            this.sendToSingleMember(dest, buf, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToSingleMember(Address dest, byte[] buf, int offset, int length) throws Exception {
        if (dest instanceof PhysicalAddress) {
            this.sendUnicast((PhysicalAddress)dest, buf, offset, length);
            return;
        }
        PhysicalAddress physical_dest = this.getPhysicalAddressFromCache(dest);
        if (physical_dest != null) {
            this.sendUnicast(physical_dest, buf, offset, length);
            return;
        }
        if (this.who_has_cache.addIfAbsentOrExpired(dest)) {
            Responses responses = this.fetchResponsesFromDiscoveryProtocol(Collections.singletonList(dest));
            try {
                for (PingData data : responses) {
                    if (data.getAddress() == null || !data.getAddress().equals(dest) || (physical_dest = data.getPhysicalAddr()) == null) continue;
                    this.sendUnicast(physical_dest, buf, offset, length);
                    return;
                }
                this.log.warn(Util.getMessage("PhysicalAddrMissing"), this.local_addr, dest);
            }
            finally {
                responses.done();
            }
        }
    }

    protected void sendToMembers(Collection<Address> mbrs, byte[] buf, int offset, int length) throws Exception {
        ArrayList<Address> missing = null;
        if (mbrs == null || mbrs.isEmpty()) {
            mbrs = this.logical_addr_cache.keySet();
        }
        for (Address mbr : mbrs) {
            PhysicalAddress target;
            PhysicalAddress physicalAddress = target = mbr instanceof PhysicalAddress ? (PhysicalAddress)mbr : this.logical_addr_cache.get(mbr);
            if (target == null) {
                if (missing == null) {
                    missing = new ArrayList<Address>(mbrs.size());
                }
                missing.add(mbr);
                continue;
            }
            try {
                if (Objects.equals(this.local_physical_addr, target)) continue;
                this.sendUnicast(target, buf, offset, length);
            }
            catch (SocketException | SocketTimeoutException sock_ex) {
                this.log.debug(Util.getMessage("FailureSendingToPhysAddr"), this.local_addr, mbr, sock_ex);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailureSendingToPhysAddr"), this.local_addr, mbr, t);
            }
        }
        if (missing != null) {
            this.fetchPhysicalAddrs(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchPhysicalAddrs(List<Address> missing) {
        long current_time = 0L;
        boolean do_send = false;
        TP tP = this;
        synchronized (tP) {
            if (this.last_discovery_request == 0L || (current_time = this.timestamp()) - this.last_discovery_request >= MIN_WAIT_BETWEEN_DISCOVERIES) {
                this.last_discovery_request = current_time == 0L ? this.timestamp() : current_time;
                do_send = true;
            }
        }
        if (do_send) {
            missing.removeAll(this.logical_addr_cache.keySet());
            if (!missing.isEmpty()) {
                Responses rsps = this.fetchResponsesFromDiscoveryProtocol(missing);
                rsps.done();
            }
        }
    }

    protected Responses fetchResponsesFromDiscoveryProtocol(List<Address> missing) {
        return (Responses)this.up_prot.up(new Event(11, missing));
    }

    protected long timestamp() {
        return this.time_service != null ? this.time_service.timestamp() : System.nanoTime();
    }

    protected void registerLocalAddress(Address addr) {
        PhysicalAddress physical_addr = this.getPhysicalAddress();
        if (physical_addr == null) {
            return;
        }
        this.local_physical_addr = physical_addr;
        if (addr != null) {
            if (this.use_ip_addrs && this.local_addr instanceof IpAddressUUID) {
                this.addPhysicalAddressToCache(addr, (PhysicalAddress)this.local_addr, true);
            } else {
                this.addPhysicalAddressToCache(addr, physical_addr, true);
            }
        }
    }

    protected void fetchLocalAddresses() {
        if (this.local_addr != null) {
            this.registerLocalAddress(this.local_addr);
        } else {
            Address addr;
            this.local_addr = addr = (Address)this.up_prot.up(new Event(91));
            this.registerLocalAddress(addr);
        }
    }

    protected void setThreadNames() {
        if (this.diag_handler != null) {
            this.diag_handler.setThreadNames();
        }
        if (this.bundler instanceof TransferQueueBundler) {
            this.thread_factory.renameThread("TQ-Bundler", ((TransferQueueBundler)this.bundler).getThread());
        }
    }

    protected void unsetThreadNames() {
        Thread thread;
        if (this.diag_handler != null) {
            this.diag_handler.unsetThreadNames();
        }
        if (this.bundler instanceof TransferQueueBundler) {
            Thread thread2 = ((TransferQueueBundler)this.bundler).getThread();
            if (thread2 != null) {
                this.thread_factory.renameThread("TQ-Bundler", thread2);
            }
        } else if (this.bundler instanceof RingBufferBundler && (thread = ((RingBufferBundler)this.bundler).getThread()) != null) {
            this.thread_factory.renameThread("RingBufferBundler", thread);
        }
    }

    protected void setInAllThreadFactories(String cluster_name, Address local_address, String pattern) {
        ThreadFactory[] factories;
        for (ThreadFactory factory : factories = new ThreadFactory[]{this.thread_factory, this.internal_thread_factory}) {
            if (pattern != null) {
                factory.setPattern(pattern);
            }
            if (cluster_name != null) {
                factory.setClusterName(cluster_name);
            }
            if (local_address == null) continue;
            factory.setAddress(local_address.toString());
        }
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory, Log log, boolean use_fork_join_pool, boolean use_common_fork_join_pool) {
        if (use_fork_join_pool) {
            if (use_common_fork_join_pool) {
                return ForkJoinPool.commonPool();
            }
            int num_cores = Runtime.getRuntime().availableProcessors();
            if (max_threads > num_cores) {
                log.warn("max_threads (%d) is higher than available cores (%d)", max_threads, num_cores);
            }
            return new ForkJoinPool(max_threads, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue, factory);
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        return pool;
    }

    protected static void shutdownThreadPool(Executor thread_pool) {
        if (thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr) {
        return this.addPhysicalAddressToCache(logical_addr, physical_addr, true);
    }

    protected boolean addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr, boolean overwrite) {
        return logical_addr != null && physical_addr != null && overwrite ? this.logical_addr_cache.add(logical_addr, physical_addr) : this.logical_addr_cache.addIfAbsent(logical_addr, physical_addr);
    }

    protected PhysicalAddress getPhysicalAddressFromCache(Address logical_addr) {
        return logical_addr != null ? this.logical_addr_cache.get(logical_addr) : null;
    }

    protected Collection<PhysicalAddress> getAllPhysicalAddressesFromCache() {
        return this.logical_addr_cache.nonRemovedValues();
    }

    protected void removeLogicalAddressFromCache(Address logical_addr) {
        if (logical_addr != null) {
            this.logical_addr_cache.remove(logical_addr);
            this.fetchLocalAddresses();
        }
    }

    @ManagedOperation(description="Clears the logical address cache; only used for testing")
    public void clearLogicalAddressCache() {
        this.logical_addr_cache.clear(true);
        this.fetchLocalAddresses();
    }

    protected abstract PhysicalAddress getPhysicalAddress();
}

