/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.local;

import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.RoleServiceClient;
import ai.digital.deploy.permissions.client.configuration.PermissionServiceEntityNotFoundError;
import ai.digital.deploy.permissions.client.util.SortOrder;
import ai.digital.deploy.permissions.client.util.SortOrder$;
import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Component
@ConditionalOnProperty(name={"xl.permission-service.enabled"}, havingValue="true", matchIfMissing=true)
@Profile(value={"permission-service"})
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\t-b\u0001B\u000b\u0017\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")\u0011\u000b\u0001C!%\")\u0001\u000f\u0001C!c\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u0019\u0001\b\u0001\"\u0011\u00026!9\u0011Q\u0002\u0001\u0005B\u0005e\u0002bBA)\u0001\u0011\u0005\u00131\u000b\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\t\t\u0007\u0001C!\u0003GBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005]\u0004\u0001\"\u0011\u0002\u0000!9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\t9\r\u0001C!\u0003\u0013\u0014a\u0003T8dC2\u0014v\u000e\\3TKJ4\u0018nY3DY&,g\u000e\u001e\u0006\u0003/a\tQ\u0001\\8dC2T!!\u0007\u000e\u0002\r\rd\u0017.\u001a8u\u0015\tYB$A\u0006qKJl\u0017n]:j_:\u001c(BA\u000f\u001f\u0003\u0019!W\r\u001d7ps*\u0011q\u0004I\u0001\bI&<\u0017\u000e^1m\u0015\u0005\t\u0013AA1j\u0007\u0001\u00192\u0001\u0001\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111\u0006L\u0007\u00021%\u0011Q\u0006\u0007\u0002\u0012%>dWmU3sm&\u001cWm\u00117jK:$\u0018a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u000e\u0002\u000fM,'O^5dK&\u0011A'\r\u0002\f%>dWmU3sm&\u001cW\r\u000b\u0002\u0002mA\u0011qGQ\u0007\u0002q)\u0011\u0011HO\u0001\u000bC:tw\u000e^1uS>t'BA\u001e=\u0003\u001d1\u0017m\u0019;pefT!!\u0010 \u0002\u000b\t,\u0017M\\:\u000b\u0005}\u0002\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019\u0005HA\u0005BkR|w/\u001b:fI\u0006!\"o\u001c7f!JLgnY5qC2\u001cVM\u001d<jG\u0016\u0004\"\u0001\r$\n\u0005\u001d\u000b$\u0001\u0006*pY\u0016\u0004&/\u001b8dSB\fGnU3sm&\u001cW\r\u000b\u0002\u0003m\u00051A(\u001b8jiz\"2aS'P!\ta\u0005!D\u0001\u0017\u0011\u0015q3\u00011\u00010Q\tie\u0007C\u0003E\u0007\u0001\u0007Q\t\u000b\u0002Pm\u00051q-\u001a;BY2,\u0012a\u0015\t\u0004)r{fBA+[\u001d\t1\u0016,D\u0001X\u0015\tA&%\u0001\u0004=e>|GOP\u0005\u0002O%\u00111LJ\u0001\ba\u0006\u001c7.Y4f\u0013\tifL\u0001\u0003MSN$(BA.'!\t\u0001w-D\u0001b\u0015\t\u00117-A\u0002ei>T!\u0001Z3\u0002\tI,7\u000f\u001e\u0006\u0003Mj\t1!\u00199j\u0013\tA\u0017MA\u0004S_2,G\t^8)\u0005\u0011Q\u0007CA6o\u001b\u0005a'BA7\u001b\u0003\rQ\u0007/Y\u0005\u0003_2\u0014aEU3bI>sG.\u001f+sC:\u001c\u0018m\u0019;j_:\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f\u0003\u0019\u0019'/Z1uKR\u0019!/^@\u0011\u0005\u0001\u001c\u0018B\u0001;b\u0005U\u0011v\u000e\\3XSRD\u0007K]5oG&\u0004\u0018\r\\:Ei>DQA^\u0003A\u0002]\fAA\\1nKB\u0011\u0001\u0010 \b\u0003sj\u0004\"A\u0016\u0014\n\u0005m4\u0013A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f\u0014\t\u000f\u0005\u0005Q\u00011\u0001\u0002\u0004\u0005Q\u0001O]5oG&\u0004\u0018\r\\:\u0011\u0007Qcv/\u0001\bde\u0016\fG/Z(s+B$\u0017\r^3\u0015\u0007}\u000bI\u0001\u0003\u0004\u0002\f\u0019\u0001\raX\u0001\u0005e>dW-\u0001\u0004va\u0012\fG/\u001a\u000b\ne\u0006E\u0011QCA\r\u0003GAa!a\u0005\b\u0001\u00049\u0018\u0001E8sS\u001eLg.\u00197S_2,g*Y7f\u0011\u0019\t9b\u0002a\u0001o\u0006yQ\u000f\u001d3bi\u0016$'k\u001c7f\u001d\u0006lW\rC\u0004\u0002\u001c\u001d\u0001\r!!\b\u0002%A\u0014\u0018N\\2ja\u0006d7\u000fV8De\u0016\fG/\u001a\t\u0005q\u0006}q/C\u0002\u0002\"y\u00141aU3u\u0011\u001d\t)c\u0002a\u0001\u0003;\t!\u0003\u001d:j]\u000eL\u0007/\u00197t)>$U\r\\3uK\u0006\u0019\"/Z7pm\u0016\fE\u000e\u001c*fM\u0016\u0014XM\\2fgR!\u00111FA\u0019!\r)\u0013QF\u0005\u0004\u0003_1#\u0001B+oSRDa!a\r\t\u0001\u00049\u0018\u0001\u0003:pY\u0016t\u0015-\\3\u0015\u0007}\u000b9\u0004C\u0003w\u0013\u0001\u0007q\u000fF\u0003`\u0003w\ty\u0005C\u0004\u0002>)\u0001\r!a\u0010\u0002\u0005%$\u0007\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005kRLGN\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\tU+\u0016\n\u0012\u0005\u0007\u0003gQ\u0001\u0019A<\u0002\rI,g.Y7f)\u0015y\u0016QKA,\u0011\u001518\u00021\u0001x\u0011\u0019\tIf\u0003a\u0001o\u00069a.Z<OC6,\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002,\u0005}\u0003BBA\u001a\u0019\u0001\u0007q/\u0001\u0006eK2,G/\u001a\"z\u0013\u0012$B!a\u000b\u0002f!1\u0011qM\u0007A\u0002]\faA]8mK&#\u0017\u0001\u0003:fC\u0012\u0014\u00150\u00133\u0015\t\u00055\u00141\u000f\t\u0005K\u0005=t,C\u0002\u0002r\u0019\u0012aa\u00149uS>t\u0007BBA4\u001d\u0001\u0007q\u000f\u000b\u0002\u000fU\u0006!!/Z1e)\u0011\ti'a\u001f\t\r\u0005Mr\u00021\u0001xQ\ty!\u000e\u0006\u0007\u0002\u0002\u0006\u001d\u00151RAK\u00033\u000b9\u000b\u0005\u0003,\u0003\u0007{\u0016bAAC1\t\t\u0002+Y4j]\u0006$X\r\u001a*fgB|gn]3\t\r\u0005%\u0005\u00031\u0001x\u0003-q\u0017-\\3QCR$XM\u001d8\t\u000f\u00055\u0005\u00031\u0001\u0002\u0010\u0006!\u0001/Y4f!\r)\u0013\u0011S\u0005\u0004\u0003'3#aA%oi\"9\u0011q\u0013\tA\u0002\u0005=\u0015\u0001B:ju\u0016Dq!a'\u0011\u0001\u0004\ti*A\u0003pe\u0012,'\u000f\u0005\u0003\u0002 \u0006\rVBAAQ\u0015\r\t)\u0005G\u0005\u0005\u0003K\u000b\tKA\u0005T_J$xJ\u001d3fe\"1\u0011\u0011\u0016\tA\u0002]\fQAZ5fY\u0012D#\u0001\u00056\u0002#I,\u0017\r\u001a\"z%>dW\rU1ui\u0016\u0014h\u000eF\u0002T\u0003cCa!!#\u0012\u0001\u00049\bFA\tk\u0003%\u0011X-\\8wK\u0006cG\u000e\u0006\u0002\u0002,\u0005Q!o\u001c7f\u000bbL7\u000f^:\u0015\t\u0005u\u00161\u0019\t\u0004K\u0005}\u0016bAAaM\t9!i\\8mK\u0006t\u0007BBA\u001a'\u0001\u0007q\u000f\u000b\u0002\u0014U\u0006Q1m\\;oiJ{G.Z:\u0015\t\u0005-\u0017\u0011\u001b\t\u0004K\u00055\u0017bAAhM\t!Aj\u001c8h\u0011\u0019\t\u0019\u000e\u0006a\u0001o\u0006y!o\u001c7f\u001d\u0006lW\rU1ui\u0016\u0014h\u000e\u000b\u0002\u0015U\"\u001a\u0001!!7\u0011\u0007-\fY.C\u0002\u0002^2\u0014a\u0004\u0016:b]N\f7\r^5p]\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3)\u000f\u0001\t\t/a<\u0002rB!\u00111]Av\u001b\t\t)OC\u0002:\u0003OT1!!;?\u0003\u001d\u0019wN\u001c;fqRLA!!<\u0002f\n9\u0001K]8gS2,\u0017!\u0002<bYV,GFAAzC\t\t)0\u0001\nqKJl\u0017n]:j_:l3/\u001a:wS\u000e,\u0007F\u0004\u0001\u0002zZ\u0014iAa\u0005\u0003\u0016\te!1\u0004\t\u0005\u0003w\u0014I!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003%\u0019wN\u001c3ji&|gN\u0003\u0003\u0003\u0004\t\u0015\u0011!D1vi>\u001cwN\u001c4jOV\u0014XMC\u0002\u0003\by\nAAY8pi&!!1BA\u007f\u0005U\u0019uN\u001c3ji&|g.\u00197P]B\u0013x\u000e]3sifd#Aa\u0004\"\u0005\tE\u0011!\b=m]A,'/\\5tg&|g.L:feZL7-\u001a\u0018f]\u0006\u0014G.\u001a3\u0002\u0017!\fg/\u001b8h-\u0006dW/Z\u0011\u0003\u0005/\tA\u0001\u001e:vK\u0006qQ.\u0019;dQ&3W*[:tS:<\u0017$A\u0001)\u0007\u0001\u0011y\u0002\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\r\u0011)CP\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B\u0015\u0005G\u0011\u0011bQ8na>tWM\u001c;")
public class LocalRoleServiceClient
implements RoleServiceClient {
    @Autowired
    private final RoleService roleService;
    @Autowired
    private final RolePrincipalService rolePrincipalService;

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<RoleDto> getAll() {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readAll());
    }

    @Override
    public RoleWithPrincipalsDto create(String name, List<String> principals) {
        this.roleService.create(name);
        Tuple2 tuple2 = this.rolePrincipalService.add(name, principals);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Role role = (Role)tuple2._1();
        List rolePrincipals = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)role, (Object)rolePrincipals);
        Tuple2 tuple23 = tuple22;
        Role role2 = (Role)tuple23._1();
        List rolePrincipals2 = (List)tuple23._2();
        return new RoleWithPrincipalsDto(RoleConverter$.MODULE$.roleToDto(role2), rolePrincipals2.map((Function1 & Serializable)x$2 -> x$2.principalName()));
    }

    @Override
    public RoleDto createOrUpdate(RoleDto role) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.createOrUpdate(Role$.MODULE$.apply(role.id(), role.name())));
    }

    @Override
    public RoleWithPrincipalsDto update(String originalRoleName, String updatedRoleName, Set<String> principalsToCreate, Set<String> principalsToDelete) {
        this.rolePrincipalService.edit(originalRoleName, principalsToCreate.toList(), principalsToDelete.toList());
        Role role = (Role)this.roleService.read(originalRoleName).getOrElse((Function0 & Serializable)() -> {
            throw new PermissionServiceEntityNotFoundError(new StringBuilder(45).append("Couldn't update role ").append(originalRoleName).append(" - role entity not found").toString());
        });
        role.name_$eq(updatedRoleName);
        Role updatedRole = this.roleService.update(role);
        return new RoleWithPrincipalsDto(RoleConverter$.MODULE$.roleToDto(updatedRole), ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(updatedRole.principals()).asScala().map((Function1 & Serializable)x$3 -> x$3.principalName())).toList());
    }

    @Override
    public void removeAllReferences(String roleName) {
        this.roleService.deleteAllRoleReferences(roleName);
    }

    @Override
    public RoleDto create(String name) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.create(name));
    }

    @Override
    public RoleDto update(UUID id, String roleName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.update(Role$.MODULE$.apply(id, roleName)));
    }

    @Override
    public RoleDto rename(String name, String newName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.rename(name, newName));
    }

    @Override
    public void delete(String roleName) {
        this.roleService.delete(roleName);
    }

    @Override
    public void deleteById(String roleId) {
        this.roleService.delete(UUID.fromString(roleId));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<RoleDto> readById(String roleId) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(UUID.fromString(roleId)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<RoleDto> read(String roleName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(roleName));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public PaginatedResponse<RoleDto> read(String namePattern, int page, int size, SortOrder order, String field) {
        Page rolePage = this.roleService.read(namePattern, (Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)SortOrder$.MODULE$.getSort(order, field)));
        return new PaginatedResponse<RoleDto>(RoleConverter$.MODULE$.roleToDto(CollectionConverters$.MODULE$.ListHasAsScala(rolePage.getContent()).asScala().toList()), rolePage.getTotalElements(), page, size, rolePage.hasNext());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<RoleDto> readByRolePattern(String namePattern) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readByRolePattern(namePattern));
    }

    @Override
    public void removeAll() {
        this.roleService.removeAll();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean roleExists(String roleName) {
        return this.roleService.read(roleName).isDefined();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public long countRoles(String roleNamePattern) {
        return this.roleService.count(roleNamePattern);
    }

    public LocalRoleServiceClient(@Autowired RoleService roleService, @Autowired RolePrincipalService rolePrincipalService) {
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
    }
}

