/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.exception.RoleNameAlreadyExistsException;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.repository.GlobalPermissionRepository;
import ai.digital.deploy.permissions.repository.ReferencedPermissionRepository;
import ai.digital.deploy.permissions.repository.RolePrincipalRepository;
import ai.digital.deploy.permissions.repository.RoleRepository;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015)\u0007\u0001\"\u0011l\u0011\u00151\b\u0001\"\u0011x\u0011\u0015Q\b\u0001\"\u0011|\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u00033\u0001A\u0011IA\u0014\u0011\u001d\tI\u0002\u0001C!\u0003\u0007Bq!!\u0007\u0001\t\u0003\nY\u0007C\u0004\u0002\u001a\u0001!\t%!\u001d\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003'\u0003A\u0011IAK\u0005=\u0011v\u000e\\3TKJ4\u0018nY3J[Bd'B\u0001\u000e\u001c\u0003\u0011IW\u000e\u001d7\u000b\u0005qi\u0012aB:feZL7-\u001a\u0006\u0003=}\t1\u0002]3s[&\u001c8/[8og*\u0011\u0001%I\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\t\u001a\u0013a\u00023jO&$\u0018\r\u001c\u0006\u0002I\u0005\u0011\u0011-[\u0002\u0001'\r\u0001q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00059zS\"A\u000e\n\u0005AZ\"a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\faB]8mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00024m5\tAG\u0003\u00026;\u0005Q!/\u001a9pg&$xN]=\n\u0005]\"$A\u0004*pY\u0016\u0014V\r]8tSR|'/_\u0001\u0018e>dW\r\u0015:j]\u000eL\u0007/\u00197SKB|7/\u001b;pef\u0004\"a\r\u001e\n\u0005m\"$a\u0006*pY\u0016\u0004&/\u001b8dSB\fGNU3q_NLGo\u001c:z\u0003i9Gn\u001c2bYB+'/\\5tg&|gNU3q_NLGo\u001c:z!\t\u0019d(\u0003\u0002@i\tQr\t\\8cC2\u0004VM]7jgNLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006q\"/\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:\u0014V\r]8tSR|'/\u001f\t\u0003g\tK!a\u0011\u001b\u0003=I+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8o%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\bF\u0003G\u0011&S5\n\u0005\u0002H\u00015\t\u0011\u0004C\u00032\u000b\u0001\u0007!\u0007C\u00039\u000b\u0001\u0007\u0011\bC\u0003=\u000b\u0001\u0007Q\bC\u0003A\u000b\u0001\u0007\u0011)\u0001\u0004de\u0016\fG/\u001a\u000b\u0003\u001dR\u0003\"a\u0014*\u000e\u0003AS!!U\u000f\u0002\u000b5|G-\u001a7\n\u0005M\u0003&\u0001\u0002*pY\u0016DQ!\u0016\u0004A\u0002Y\u000bAA\\1nKB\u0011qK\u0018\b\u00031r\u0003\"!W\u0015\u000e\u0003iS!aW\u0013\u0002\rq\u0012xn\u001c;?\u0013\ti\u0016&\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/*\u00039\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016$\"AT2\t\u000b\u0011<\u0001\u0019\u0001(\u0002\tI|G.Z\u0001\u0007I\u0016dW\r^3\u0015\u0005\u001dT\u0007C\u0001\u0015i\u0013\tI\u0017F\u0001\u0003V]&$\b\"B+\t\u0001\u00041FCA4m\u0011\u0015i\u0017\u00021\u0001o\u0003\tIG\r\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006!Q\u000f^5m\u0015\u0005\u0019\u0018\u0001\u00026bm\u0006L!!\u001e9\u0003\tU+\u0016\nR\u0001\u0018I\u0016dW\r^3BY2\u0014v\u000e\\3SK\u001a,'/\u001a8dKN$\"a\u001a=\t\u000beT\u0001\u0019\u0001,\u0002\u0011I|G.\u001a(b[\u0016\faA]3n_Z,GCA4}\u0011\u0015!7\u00021\u0001O\u0003%\u0011X-\\8wK\u0006cG\u000eF\u0001h\u0003\u0019)\b\u000fZ1uKR\u0019a*a\u0001\t\u000b\u0011l\u0001\u0019\u0001(\u0002)I,\u0017\rZ(s)\"\u0014xn^#yG\u0016\u0004H/[8o)\rq\u0015\u0011\u0002\u0005\u0006+:\u0001\rA\u0016\u0015\u0004\u001d\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005MQ$A\u0002ka\u0006LA!a\u0006\u0002\u0012\t1#+Z1e\u001f:d\u0017\u0010\u0016:b]N\f7\r^5p]\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003;\t\u0019\u0003\u0005\u0003)\u0003?q\u0015bAA\u0011S\t1q\n\u001d;j_:DQ!V\bA\u0002YC3aDA\u0007)\u0011\tI#a\u000f\u0011\u000b\u0005-\u0012Q\u0007(\u000f\t\u00055\u0012\u0011\u0007\b\u00043\u0006=\u0012\"\u0001\u0016\n\u0007\u0005M\u0012&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0012\u0011\b\u0002\u0005\u0019&\u001cHOC\u0002\u00024%Bq!!\u0010\u0011\u0001\u0004\ty$A\u0003oC6,7\u000fE\u0003\u0002,\u0005Ub\u000bK\u0002\u0011\u0003\u001b!b!!\u0012\u0002^\u0005}\u0003#BA$\u00033rUBAA%\u0015\u0011\tY%!\u0014\u0002\r\u0011|W.Y5o\u0015\u0011\ty%!\u0015\u0002\t\u0011\fG/\u0019\u0006\u0005\u0003'\n)&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t9&A\u0002pe\u001eLA!a\u0017\u0002J\t!\u0001+Y4f\u0011\u001d\ti$\u0005a\u0001\u0003\u007fAq!!\u0019\u0012\u0001\u0004\t\u0019'\u0001\u0005qC\u001e,\u0017M\u00197f!\u0011\t9%!\u001a\n\t\u0005\u001d\u0014\u0011\n\u0002\t!\u0006<W-\u00192mK\"\u001a\u0011#!\u0004\u0015\t\u0005u\u0011Q\u000e\u0005\u0006[J\u0001\rA\u001c\u0015\u0004%\u00055ACBA#\u0003g\n9\b\u0003\u0004\u0002vM\u0001\rAV\u0001\f]\u0006lW\rU1ui\u0016\u0014h\u000eC\u0004\u0002bM\u0001\r!a\u0019)\u0007M\ti!A\tsK\u0006$')\u001f*pY\u0016\u0004\u0016\r\u001e;fe:$B!!\u000b\u0002\u0000!1\u0011Q\u000f\u000bA\u0002YC3\u0001FA\u0007\u0003\u001d\u0011X-\u00193BY2$\"!!\u000b)\u0007U\ti!\u0001\u0004sK:\fW.\u001a\u000b\u0006\u001d\u00065\u0015q\u0012\u0005\u0006+Z\u0001\rA\u0016\u0005\u0007\u0003#3\u0002\u0019\u0001,\u0002\u000f9,wOT1nK\u0006)1m\\;oiR!\u0011qSAO!\rA\u0013\u0011T\u0005\u0004\u00037K#\u0001\u0002'p]\u001eDa!a(\u0018\u0001\u00041\u0016a\u0004:pY\u0016t\u0015-\\3QCR$XM\u001d8)\u0007]\ti\u0001K\u0002\u0001\u0003K\u0003B!a\u0004\u0002(&!\u0011\u0011VA\t\u0005y!&/\u00198tC\u000e$\u0018n\u001c8bYB+'/\\5tg&|gnU3sm&\u001cW\rK\u0002\u0001\u0003[\u0003B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b\t&\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a.\u00022\n91+\u001a:wS\u000e,\u0007")
public class RoleServiceImpl
implements RoleService {
    private final RoleRepository roleRepository;
    private final RolePrincipalRepository rolePrincipalRepository;
    private final GlobalPermissionRepository globalPermissionRepository;
    private final ReferencedPermissionRepository referencedPermissionRepository;

    @Override
    public Role create(String name) {
        if (this.roleRepository.get(name).isDefined()) {
            throw new RoleNameAlreadyExistsException(name);
        }
        return this.roleRepository.add(Role$.MODULE$.apply(name));
    }

    @Override
    public Role createOrUpdate(Role role) {
        if (this.roleRepository.get(role.id()).isEmpty() && this.roleRepository.get(role.name()).isDefined()) {
            throw new RoleNameAlreadyExistsException(role.name());
        }
        return this.roleRepository.add(role);
    }

    @Override
    public void delete(String name) {
        this.readOrThrowException(name);
        this.roleRepository.removeByName(name);
    }

    @Override
    public void delete(UUID id) {
        this.roleRepository.removeById(id);
    }

    @Override
    public void deleteAllRoleReferences(String roleName) {
        Role role = (Role)this.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        this.rolePrincipalRepository.removeForRole(role);
        this.globalPermissionRepository.removeForRole(role);
        this.referencedPermissionRepository.removeForRole(role);
        this.remove(role);
    }

    @Override
    public void remove(Role role) {
        this.roleRepository.remove(role);
    }

    @Override
    public void removeAll() {
        this.rolePrincipalRepository.removeAll();
        this.roleRepository.removeAll();
    }

    @Override
    public Role update(Role role) {
        return this.roleRepository.add(role);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Role readOrThrowException(String name) {
        return (Role)this.read(name).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(name);
        });
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<Role> read(String name) {
        return this.roleRepository.get(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ReadOnlyTransactionalPermissionService
    public List<Role> read(List<String> names) {
        void var2_2;
        List<Role> roles = this.roleRepository.get(names);
        if (roles.size() != names.size()) {
            throw new RoleNameNotFoundException(((IterableOnceOps)names.diff((Seq)roles.map((Function1 & Serializable)x$1 -> x$1.name()))).mkString("[", ", ", "]"));
        }
        return var2_2;
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Page<Role> read(List<String> names, Pageable pageable) {
        return this.roleRepository.get(names, pageable);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<Role> read(UUID id) {
        return this.roleRepository.get(id);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Page<Role> read(String namePattern, Pageable pageable) {
        return (Page)package$.MODULE$.wrapNullablePatternSearch(namePattern, (Function1 & Serializable)p -> $this.roleRepository.listByNamePattern((String)p, pageable), (Function0 & Serializable)() -> $this.roleRepository.list(pageable));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<Role> readByRolePattern(String namePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(namePattern, (Function1 & Serializable)p -> $this.roleRepository.listByNamePattern((String)p), (Function0 & Serializable)() -> $this.roleRepository.getAll());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<Role> readAll() {
        return this.roleRepository.getAll();
    }

    @Override
    public Role rename(String name, String newName) {
        Role role = (Role)this.read(name).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(name);
        });
        return this.roleRepository.add(Role$.MODULE$.apply(role.id(), newName));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public long count(String roleNamePattern) {
        return BoxesRunTime.unboxToLong(package$.MODULE$.wrapNullablePatternSearch(roleNamePattern, (Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)this.roleRepository.countRolesByRoleNamePattern(p)), (JFunction0.mcJ.sp & Serializable)() -> $this.roleRepository.countAllRoles()));
    }

    public RoleServiceImpl(RoleRepository roleRepository, RolePrincipalRepository rolePrincipalRepository, GlobalPermissionRepository globalPermissionRepository, ReferencedPermissionRepository referencedPermissionRepository) {
        this.roleRepository = roleRepository;
        this.rolePrincipalRepository = rolePrincipalRepository;
        this.globalPermissionRepository = globalPermissionRepository;
        this.referencedPermissionRepository = referencedPermissionRepository;
    }
}

