/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.codec.protobuf;

import org.python.netty.buffer.ByteBuf;
import org.python.netty.channel.ChannelHandler;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg2, ByteBuf out) throws Exception {
        int bodyLen = msg2.readableBytes();
        int headerLen = ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size(bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        ProtobufVarint32LengthFieldPrepender.writeRawVarint32(out, bodyLen);
        out.writeBytes(msg2, msg2.readerIndex(), bodyLen);
    }

    static void writeRawVarint32(ByteBuf out, int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                out.writeByte(value);
                return;
            }
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }
}

