/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.javassist;

import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import org.hibernate.bytecode.enhance.internal.javassist.AttributeTypeDescriptor;
import org.hibernate.bytecode.enhance.internal.javassist.JavassistEnhancementContext;
import org.hibernate.bytecode.enhance.internal.javassist.MethodWriter;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesEnhancer;
import org.hibernate.engine.spi.ManagedMappedSuperclass;

public class MappedSuperclassEnhancer
extends PersistentAttributesEnhancer {
    public MappedSuperclassEnhancer(JavassistEnhancementContext context) {
        super(context);
    }

    @Override
    public void enhance(CtClass managedCtClass) {
        managedCtClass.addInterface(this.loadCtClassFromClass(ManagedMappedSuperclass.class));
        super.enhance(managedCtClass);
    }

    @Override
    protected CtMethod generateFieldReader(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String readerName = "$$_hibernate_read_" + fieldName;
        return MethodWriter.addGetter(managedCtClass, fieldName, readerName);
    }

    @Override
    protected CtMethod generateFieldWriter(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String writerName = "$$_hibernate_write_" + fieldName;
        return MethodWriter.addSetter(managedCtClass, fieldName, writerName);
    }
}

