/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.log;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class PatternFormatter
extends Formatter {
    SimpleFormatter sh;
    private String logPattern;
    private String exceptionPattern;
    private String timeFormat;
    private MessageFormat logMessageFormat;
    private MessageFormat exceptionMessageFormat;
    private DateFormat dateFormat;

    public PatternFormatter() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.timeFormat = manager.getProperty(cname + ".timeFormat");
        if (this.timeFormat == null) {
            this.timeFormat = "dd-MMM-yyy; HH:mm:ss";
        }
        this.setTimeFormat(this.timeFormat);
        this.logPattern = manager.getProperty(cname + ".logPattern");
        if (this.logPattern == null) {
            this.logPattern = "[{0} - {1}] {2}: {3} \n";
        }
        this.setLogPattern(this.logPattern);
        this.exceptionPattern = manager.getProperty(cname + ".exceptionPattern");
        if (this.exceptionPattern == null) {
            this.exceptionPattern = "[{0} - {1}] {2} {3} \nException in {4}: {6} \n{7} ";
        }
        this.setExceptionPattern(this.exceptionPattern);
        this.logMessageFormat = new MessageFormat(this.logPattern);
        this.exceptionMessageFormat = new MessageFormat(this.exceptionPattern);
        this.dateFormat = new SimpleDateFormat(this.timeFormat);
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.dateFormat = new SimpleDateFormat(timeFormat);
    }

    public void setLogPattern(String logFormat) {
        logFormat = logFormat.replace("%LOGGER%", "{0}");
        logFormat = logFormat.replace("%LEVEL%", "{1}");
        logFormat = logFormat.replace("%TIME%", "{2}");
        logFormat = logFormat.replace("%MESSAGE%", "{3}");
        logFormat = logFormat.replace("%SOURCECLASS%", "{4}");
        logFormat = logFormat.replace("%SOURCEMETHOD%", "{5}");
        logFormat = logFormat.replace("%PARAM0%", "{6}");
        this.logPattern = logFormat = logFormat.replace("%PARAM1%", "{7}");
        this.logMessageFormat = new MessageFormat(this.logPattern);
    }

    public void setExceptionPattern(String exceptionFormat) {
        exceptionFormat = exceptionFormat.replace("%LOGGER%", "{0}");
        exceptionFormat = exceptionFormat.replace("%LEVEL%", "{1}");
        exceptionFormat = exceptionFormat.replace("%TIME%", "{2}");
        exceptionFormat = exceptionFormat.replace("%MESSAGE%", "{3}");
        exceptionFormat = exceptionFormat.replace("%SOURCECLASS%", "{4}");
        exceptionFormat = exceptionFormat.replace("%SOURCEMETHOD%", "{5}");
        exceptionFormat = exceptionFormat.replace("%EXCEPTION%", "{6}");
        this.exceptionPattern = exceptionFormat = exceptionFormat.replace("%STACKTRACE%", "{7}");
        this.exceptionMessageFormat = new MessageFormat(this.logPattern);
    }

    @Override
    public String format(LogRecord record) {
        Date time = new Date(record.getMillis());
        String formattedTime = this.dateFormat.format(time);
        String logMessage = "";
        if (record.getThrown() == null) {
            Object[] log = new Object[]{record.getLoggerName(), record.getLevel(), formattedTime, record.getMessage(), record.getSourceClassName(), record.getSourceMethodName(), record.getParameters() == null ? "" : record.getParameters()[0], record.getParameters() == null ? "" : record.getParameters()[1]};
            logMessage = this.logMessageFormat.format(log);
        } else {
            String stack = this.getStackLayout(record.getThrown(), "");
            Object[] log = new Object[]{record.getLoggerName(), record.getLevel(), formattedTime, record.getMessage(), record.getSourceClassName(), record.getSourceMethodName(), record.getThrown().getMessage(), stack};
            logMessage = this.exceptionMessageFormat.format(log);
        }
        return logMessage;
    }

    private String getStackLayout(Throwable t, String indenter) {
        indenter = indenter + "  ";
        StackTraceElement[] ste = t.getStackTrace();
        String stack = indenter + ste[0].toString();
        for (int i = 1; i < ste.length; ++i) {
            stack = stack + "\n" + indenter + ste[i];
        }
        String innerStack = "";
        if (t.getCause() != null) {
            innerStack = indenter + "Caused by: " + t.getCause().getMessage() + "\n";
            innerStack = innerStack + this.getStackLayout(t.getCause(), indenter);
        }
        stack = stack + "\n" + innerStack;
        return stack;
    }

    public String getExceptionPattern() {
        return this.exceptionPattern;
    }

    public String getLogPattern() {
        return this.logPattern;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }
}

