/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class LengthOperatorNode
extends UnaryOperatorNode {
    private int parameterType;
    private int parameterWidth;

    LengthOperatorNode(ValueNode valueNode, ContextManager contextManager) throws StandardException {
        super(valueNode, contextManager);
        String string = "char_length";
        String string2 = "charLength";
        this.parameterType = 12;
        this.parameterWidth = 32672;
        this.setOperator(string);
        this.setMethodName(string2);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.bindOperand(fromList, subqueryList, list);
        TypeId typeId = this.operand.getTypeId();
        switch (typeId.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException("42X25", this.getOperatorString(), typeId.getSQLTypeName());
            }
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.operand.getTypeServices().isNullable()));
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.parameterType, true, this.parameterWidth));
    }

    @Override
    String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.ConcatableDataValue";
    }
}

