/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SftpFileSystem
extends AbstractFileSystem {
    private static final int SLEEP_MILLIS = 100;
    private static final int EXEC_BUFFER_SIZE = 128;
    private static final long LAST_MOD_TIME_ACCURACY = 1000L;
    private Session session;
    private ChannelSftp idleChannel;
    private int uid = -1;
    private int[] groupsIds;

    protected SftpFileSystem(GenericFileName rootName, Session session, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.session = session;
    }

    @Override
    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            this.idleChannel.disconnect();
            this.idleChannel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected ChannelSftp getChannel() throws IOException {
        this.ensureSession();
        try {
            ChannelSftp channel;
            if (this.idleChannel != null) {
                channel = this.idleChannel;
                this.idleChannel = null;
            } else {
                channel = (ChannelSftp)this.session.openChannel("sftp");
                channel.connect();
                Boolean userDirIsRoot = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                String workingDirectory = this.getRootName().getPath();
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue())) {
                    try {
                        channel.cd(workingDirectory);
                    }
                    catch (SftpException e) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", (Object)workingDirectory, (Throwable)e);
                    }
                }
            }
            String fileNameEncoding = SftpFileSystemConfigBuilder.getInstance().getFileNameEncoding(this.getFileSystemOptions());
            if (fileNameEncoding != null) {
                try {
                    channel.setFilenameEncoding(fileNameEncoding);
                }
                catch (SftpException e) {
                    throw new FileSystemException("vfs.provider.sftp/filename-encoding.error", (Object)fileNameEncoding);
                }
            }
            return channel;
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)e);
        }
    }

    private void ensureSession() throws FileSystemException {
        block4: {
            Session session;
            if (this.session != null && this.session.isConnected()) break block4;
            this.doCloseCommunicationLink();
            UserAuthenticationData authData = null;
            try {
                GenericFileName rootName = (GenericFileName)this.getRootName();
                authData = UserAuthenticatorUtils.authenticate(this.getFileSystemOptions(), SftpFileProvider.AUTHENTICATOR_TYPES);
                session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), this.getFileSystemOptions());
            }
            catch (Exception e) {
                try {
                    throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    UserAuthenticatorUtils.cleanup(authData);
                    throw throwable;
                }
            }
            UserAuthenticatorUtils.cleanup(authData);
            this.session = session;
        }
    }

    protected void putChannel(ChannelSftp channel) {
        if (this.idleChannel == null) {
            if (channel.isConnected() && !channel.isClosed()) {
                this.idleChannel = channel;
            }
        } else {
            channel.disconnect();
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(SftpFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new SftpFileObject(name, this);
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    public int[] getGroupsIds() throws JSchException, IOException {
        if (this.groupsIds == null) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand("id -G", output);
            if (code != 0) {
                throw new JSchException("Could not get the groups id of the current user (error code: " + code + ")");
            }
            String[] groups = output.toString().trim().split("\\s+");
            int[] groupsIds = new int[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                groupsIds[i] = Integer.parseInt(groups[i]);
            }
            this.groupsIds = groupsIds;
        }
        return this.groupsIds;
    }

    public int getUId() throws JSchException, IOException {
        if (this.uid < 0) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand("id -u", output);
            if (code != 0) {
                throw new FileSystemException("Could not get the user id of the current user (error code: " + code + ")");
            }
            this.uid = Integer.parseInt(output.toString().trim());
        }
        return this.uid;
    }

    private int executeCommand(String command, StringBuilder output) throws JSchException, IOException {
        this.ensureSession();
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        channel.setCommand(command);
        channel.setInputStream(null);
        try (InputStreamReader stream = new InputStreamReader(channel.getInputStream());){
            int read;
            channel.setErrStream((OutputStream)System.err, true);
            channel.connect();
            char[] buffer = new char[128];
            while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
                output.append(buffer, 0, read);
            }
        }
        while (!channel.isClosed()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        channel.disconnect();
        return channel.getExitStatus();
    }
}

