/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.file;

import java.io.Serializable;
import liquibase.util.file.FilenameUtils;

final class IOCase
implements Serializable {
    public static final IOCase SENSITIVE = new IOCase("Sensitive", true);
    public static final IOCase INSENSITIVE = new IOCase("Insensitive", false);
    public static final IOCase SYSTEM = new IOCase("System", !FilenameUtils.isSystemWindows());
    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean isSensitive;

    public static IOCase forName(String name) {
        if (IOCase.SENSITIVE.name.equals(name)) {
            return SENSITIVE;
        }
        if (IOCase.INSENSITIVE.name.equals(name)) {
            return INSENSITIVE;
        }
        if (IOCase.SYSTEM.name.equals(name)) {
            return SYSTEM;
        }
        throw new IllegalArgumentException("Invalid IOCase name: " + name);
    }

    private IOCase(String name, boolean isSensitive) {
        this.name = name;
        this.isSensitive = isSensitive;
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCaseSensitive() {
        return this.isSensitive;
    }

    public int checkCompareTo(String str1, String str2) {
        if (str1 == null || str2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        return this.isSensitive ? str1.compareTo(str2) : str1.compareToIgnoreCase(str2);
    }

    public boolean checkEquals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        return this.isSensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
    }

    public boolean checkStartsWith(String str, String start) {
        return str.regionMatches(!this.isSensitive, 0, start, 0, start.length());
    }

    public boolean checkEndsWith(String str, String end) {
        int endLen = end.length();
        return str.regionMatches(!this.isSensitive, str.length() - endLen, end, 0, endLen);
    }

    public boolean checkRegionMatches(String str, int strStartIndex, String search) {
        return str.regionMatches(!this.isSensitive, strStartIndex, search, 0, search.length());
    }

    String convertCase(String str) {
        if (str == null) {
            return null;
        }
        return this.isSensitive ? str : str.toLowerCase();
    }

    public String toString() {
        return this.name;
    }
}

