/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.CiRoots;
import com.xebialabs.deployit.booter.local.ConfigurationItemPostProcessors;
import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.GlobalContextInitializer;
import com.xebialabs.deployit.booter.local.GlobalContextManager;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.TypeSystemBootstrapper;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.VerificationConverter;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBooter {
    private static final AtomicBoolean isBooted = new AtomicBoolean(false);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Logger logger = LoggerFactory.getLogger(LocalBooter.class);

    public static void boot() {
        try {
            LocalBooter.boot(true, Collections.emptyList(), false);
        }
        catch (RuntimeException re) {
            logger.error("Quitting, could not boot plugins: ", (Throwable)re);
            throw re;
        }
    }

    public static void boot(File propertiesFile) {
        try {
            LocalBooter.boot(true, Collections.emptyList(), false, propertiesFile, null);
        }
        catch (RuntimeException re) {
            logger.error("Quitting, could not boot plugins: ", (Throwable)re);
            throw re;
        }
    }

    public static void boot(File propertiesFile, GlobalContextManager globalContextManager) {
        try {
            LocalBooter.boot(true, Collections.emptyList(), false, propertiesFile, globalContextManager);
        }
        catch (RuntimeException re) {
            logger.error("Quitting, could not boot plugins: ", (Throwable)re);
            throw re;
        }
    }

    public static void boot(List<String> packagesToScan) {
        try {
            LocalBooter.boot(true, packagesToScan, false);
        }
        catch (RuntimeException re) {
            logger.error("Quitting, could not boot plugins: ", (Throwable)re);
            throw re;
        }
    }

    public static void bootWithoutGlobalContext() {
        LocalBooter.boot(false, Collections.emptyList(), false);
    }

    public static void bootWithoutGlobalContext(List<String> packagesToScan) {
        LocalBooter.boot(false, packagesToScan, false);
    }

    public static void rebootWithoutGlobalContext(List<String> packagesToScan) {
        LocalBooter.unboot();
        LocalBooter.boot(false, packagesToScan, true);
    }

    public static void reboot(File propertiesFile, GlobalContextManager globalContextManager) {
        LocalBooter.unboot();
        LocalBooter.boot(true, Collections.emptyList(), true, propertiesFile, globalContextManager);
    }

    private static synchronized void unboot() {
        DescriptorRegistry.remove((DescriptorRegistryId)LocalDescriptorRegistry.LOCAL_ID);
        DelegateRegistry.unboot();
        isBooted.set(false);
        initialized.set(false);
    }

    private static void boot(boolean withGlobalContext, List<String> packagesToScan, Boolean forceScan) {
        LocalBooter.boot(withGlobalContext, packagesToScan, forceScan, null, null);
    }

    private static synchronized void boot(boolean withGlobalContext, List<String> packagesToScan, Boolean forceScan, File propertiesFile, GlobalContextManager globalContextManager) {
        if (!isBooted.getAndSet(true)) {
            try {
                TypeDefinitions typeDefinitions = LocalBooter.bootStage1(packagesToScan, forceScan);
                if (withGlobalContext) {
                    if (propertiesFile != null) {
                        GlobalContextInitializer.init(propertiesFile, globalContextManager);
                    } else {
                        GlobalContextInitializer.init();
                    }
                }
                LocalBooter.bootStage2(typeDefinitions);
            }
            catch (IllegalStateException e) {
                LocalBooter.unboot();
                throw e;
            }
        }
        if (!initialized.get()) {
            throw new IllegalStateException("The DescriptorRegistry has been booted, but is not initialized. Please check the logs for any errors.");
        }
    }

    private static synchronized TypeDefinitions bootStage1(List<String> packagesToScan, Boolean forceScan) {
        LocalDescriptorRegistry registry = new LocalDescriptorRegistry();
        DescriptorRegistry.add((DescriptorRegistry)registry);
        Scannit scannit = LocalBooter.getScannit(packagesToScan, forceScan);
        ValidationRuleConverter.initialize();
        VerificationConverter.initialize();
        DelegateRegistry.boot(scannit);
        TypeSystemBootstrapper typeSystemBootstrapper = new TypeSystemBootstrapper(registry, scannit);
        TypeDefinitions typeDefinitions = typeSystemBootstrapper.loadTypes();
        LocalBooter.verifyTypes();
        return typeDefinitions;
    }

    private static void verifyTypes() {
        Verifications verifications = new Verifications();
        DelegateRegistry.verify(verifications);
        DescriptorRegistry.getDescriptors().stream().filter(input -> !input.isVirtual()).forEach(d -> ((LocalDescriptor)d).verify(verifications));
        verifications.done();
    }

    private static synchronized void bootStage2(TypeDefinitions typeDefinitions) {
        PluginVersions.init();
        ConfigurationItemPostProcessors.registerPostProcessors();
        CiRoots.findRoots(typeDefinitions);
        initialized.set(true);
    }

    private static Scannit getScannit(List<String> packagesToScan, Boolean forceScan) {
        Configuration configuration = Configuration.config().scan("ai.digital").scan("com.xebialabs").scan("ext.deployit").with(new AbstractScanner[]{new TypeAnnotationScanner(), new MethodAnnotationScanner(), new SubTypeScanner()});
        for (String pkg : packagesToScan) {
            logger.debug("Scanning additional package '{}' for types, rules etc.", (Object)pkg);
            configuration.scan(pkg);
        }
        return Scannit.boot((Configuration)configuration, (boolean)forceScan);
    }
}

