/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.IRepositoryInitializer;
import com.xebialabs.deployit.upgrade.InitializationStrategy;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RepositoryInitializer
implements IRepositoryInitializer,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryInitializer.class);
    private ApplicationContext context;
    private final InitializationStrategy initializationStrategy;
    private final RepositoryVersionService repositoryVersionService;

    @Autowired
    public RepositoryInitializer(InitializationStrategy initializationStrategy, RepositoryVersionService repositoryVersionService) {
        this.initializationStrategy = initializationStrategy;
        this.repositoryVersionService = repositoryVersionService;
    }

    @Override
    public void initializeComponents() {
        Map<String, List<RepositoryInitialization>> initializations = this.getInitializations();
        for (String component : this.getRegisteredPlugins()) {
            this.initializeComponent(component, initializations);
        }
    }

    private void initializeComponent(String component, Map<String, List<RepositoryInitialization>> initializations) {
        Version componentVersion;
        try {
            componentVersion = this.repositoryVersionService.readVersionOfComponent(component);
        }
        catch (RuntimeException e) {
            logger.warn(String.format("Component [%s] has an invalid version", component), (Throwable)e);
            return;
        }
        if (componentVersion == null) {
            this.doInitializeComponent(component, initializations);
            this.repositoryVersionService.storeVersionOfComponent(Version.valueOf((String)component, (String)"0.0.0"));
        } else {
            logger.debug("Component {} is already initialized", (Object)component);
        }
    }

    private void doInitializeComponent(String component, Map<String, List<RepositoryInitialization>> initializations) {
        List<RepositoryInitialization> componentInitializations = initializations.get(component);
        if (componentInitializations != null && !componentInitializations.isEmpty()) {
            ArrayList<RepositoryInitialization> sortedInitializations = new ArrayList<RepositoryInitialization>(componentInitializations);
            sortedInitializations.sort(Comparator.comparing(o -> o.getClass().getSimpleName()));
            logger.info("Initializing repository for component [{}] using: {}", (Object)component, sortedInitializations);
            this.initializationStrategy.doInitializations(sortedInitializations);
        }
    }

    private Map<String, List<RepositoryInitialization>> getInitializations() {
        Collection<RepositoryInitialization> allInitializations = this.findAndInstantiateApplicableInitializers();
        logger.debug("Found the following initializations: [{}]", allInitializations);
        HashMap<String, List<RepositoryInitialization>> map = new HashMap<String, List<RepositoryInitialization>>();
        for (RepositoryInitialization init : allInitializations) {
            map.computeIfAbsent(init.getComponent(), i -> new ArrayList()).add(init);
        }
        return map;
    }

    Collection<RepositoryInitialization> findAndInstantiateApplicableInitializers() {
        Set initializerClasses = this.initializationStrategy.findApplicableInitializerTypes();
        return UpgraderHelper.instantiateClasses(initializerClasses, this.context);
    }

    Set<String> getRegisteredPlugins() {
        return PluginVersions.getRegisteredPlugins();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

