/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import java.util.Objects;

public class ObjLongPair<A>
implements Serializable {
    private static final long serialVersionUID = 7749478219139339853L;
    public static final long NIL = -1L;
    private A a;
    private long b;

    public ObjLongPair(A a, long b) {
        this.a = a;
        this.b = b;
        if (b < 0L && b != -1L) {
            throw new IllegalStateException("b must be >= 0 or == NIL = -1");
        }
    }

    public ObjLongPair(A a) {
        this.a = a;
        this.b = -1L;
    }

    public int hashCode() {
        if (this.a == null && this.b == -1L) {
            return super.hashCode();
        }
        return (this.a == null ? 0 : this.a.hashCode()) + 37 * Long.hashCode(this.b);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ObjLongPair)) {
            return false;
        }
        ObjLongPair pother = (ObjLongPair)other;
        return Objects.equals(pother.a, this.a) && pother.b == this.b;
    }

    public String toString() {
        return "ObjLongPair[a=" + this.a + ", b=" + (this.b == -1L ? "NIL" : Long.valueOf(this.b)) + "]";
    }

    public void setA(A a) {
        if (this.a == a) {
            return;
        }
        this.a = a;
    }

    public A getA() {
        return this.a;
    }

    public void setB(long b) {
        if (b < 0L && b != -1L) {
            throw new IllegalStateException("b must be >= 0 or == NIL = -1");
        }
        this.b = b;
    }

    public long getB() {
        return this.b;
    }
}

