/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.RingBuffer;
import org.jgroups.util.Runner;

@Experimental
public class RemoveQueueBundler
extends BaseBundler {
    protected RingBuffer<Message> rb;
    protected Runner runner;
    protected Message[] remove_queue;
    protected final AverageMinMax avg_batch_size = new AverageMinMax();
    protected int queue_size = 1024;

    @ManagedAttribute(description="Remove queue size")
    public int rqbRemoveQueueSize() {
        return this.remove_queue.length;
    }

    @ManagedAttribute(description="Sets the size of the remove queue; creates a new remove queue")
    public void rqbRemoveQueueSize(int size) {
        if (size == this.queue_size) {
            return;
        }
        this.queue_size = size;
        this.remove_queue = new Message[this.queue_size];
    }

    @ManagedAttribute(description="Average batch length")
    public String rqbAvgBatchSize() {
        return this.avg_batch_size.toString();
    }

    @ManagedAttribute(description="Current number of messages (to be sent) in the ring buffer")
    public int rqbRingBufferSize() {
        return this.rb.size();
    }

    @Override
    public Map<String, Object> getStats() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("avg-batch-size", this.avg_batch_size.toString());
        map.put("ring-buffer-size", this.rb.size());
        map.put("remove-queue-size", this.queue_size);
        return map;
    }

    @Override
    public void resetStats() {
        this.avg_batch_size.clear();
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
        this.rb = new RingBuffer<Message>(Message.class, transport.getBundlerCapacity());
        this.remove_queue = new Message[this.queue_size];
        this.runner = new Runner(new DefaultThreadFactory("aqb", true, true), "runner", this::run, null);
    }

    @Override
    public synchronized void start() {
        super.start();
        this.runner.start();
    }

    @Override
    public synchronized void stop() {
        this.runner.stop();
        super.stop();
    }

    @Override
    public void send(Message msg) throws Exception {
        this.rb.put(msg);
    }

    public void run() {
        try {
            int drained = this.rb.drainToBlocking((Message[])this.remove_queue);
            if (drained == 1) {
                this.output.position(0);
                this.sendSingleMessage(this.remove_queue[0]);
                return;
            }
            for (int i = 0; i < drained; ++i) {
                Message msg = this.remove_queue[i];
                long size = msg.size();
                if (this.count + size >= (long)this.transport.getMaxBundleSize()) {
                    this.sendBundledMessages();
                }
                this.addMessage(msg, msg.size());
            }
            this.sendBundledMessages();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getQueueSize() {
        return this.rb.size();
    }

    @Override
    public int size() {
        return this.rb.size();
    }

    @Override
    protected void sendMessageList(Address dest, Address src, List<Message> list) {
        super.sendMessageList(dest, src, list);
        this.avg_batch_size.add(list.size());
    }
}

