/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v1.impl;

import ai.digital.deploy.permissions.api.rest.dto.CreateRoleRequest;
import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleFilterDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleIdRequest;
import ai.digital.deploy.permissions.api.rest.dto.UpdateRoleRequest;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.exception.RoleIdNotFoundException;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.Function0;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@RestController
@RequestMapping(value={"/v1/roles"})
@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\u000b\u0016\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006i\u0001!\t!\u000e\u0005\ns\u0001\u0001\r\u00111A\u0005\u0002iB\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011A#\t\u0013-\u0003\u0001\u0019!A!B\u0013Y\u0004\"B,\u0001\t\u0003A\u0006\"B=\u0001\t\u0003Q\bbBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBAW\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\ti\u000f\u0001C\u0001\u0003_DqAa\u0001\u0001\t\u0003\u0011)\u0001C\u0004\u0003\u0018\u0001!\tA!\u0007\u0003\u001fI{G.Z:D_:$(o\u001c7mKJT!AF\f\u0002\t%l\u0007\u000f\u001c\u0006\u00031e\t!A^\u0019\u000b\u0005iY\u0012\u0001\u0002:fgRT!\u0001H\u000f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001f?\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0004eKBdw.\u001f\u0006\u0003E\r\nq\u0001Z5hSR\fGNC\u0001%\u0003\t\t\u0017n\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-A\u0006s_2,7+\u001a:wS\u000e,\u0007CA\u00183\u001b\u0005\u0001$BA\u0019\u001e\u0003\u001d\u0019XM\u001d<jG\u0016L!a\r\u0019\u0003\u0017I{G.Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005YB\u0004CA\u001c\u0001\u001b\u0005)\u0002\"B\u0017\u0003\u0001\u0004q\u0013aB2p]R,\u0007\u0010^\u000b\u0002wA\u0011AHQ\u0007\u0002{)\u0011\u0011H\u0010\u0006\u0003\u007f\u0001\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rk$AE!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\f1bY8oi\u0016DHo\u0018\u0013fcR\u0011a)\u0013\t\u0003Q\u001dK!\u0001S\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0015\u0012\t\t\u00111\u0001<\u0003\rAH%M\u0001\tG>tG/\u001a=uA!\u0012Q!\u0014\t\u0003\u001dVk\u0011a\u0014\u0006\u0003!F\u000b!\"\u00198o_R\fG/[8o\u0015\t\u00116+A\u0004gC\u000e$xN]=\u000b\u0005Qs\u0014!\u00022fC:\u001c\u0018B\u0001,P\u0005%\tU\u000f^8xSJ,G-A\u0004sK\u0006$\u0017\t\u001c7\u0015\u0003e\u00032A\u00172f\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_K\u00051AH]8pizJ\u0011AK\u0005\u0003C&\nq\u0001]1dW\u0006<W-\u0003\u0002dI\n!A*[:u\u0015\t\t\u0017\u0006\u0005\u0002gS6\tqM\u0003\u0002i3\u0005\u0019A\r^8\n\u0005)<'a\u0002*pY\u0016$Eo\u001c\u0015\u0005\r1,h\u000f\u0005\u0002ng6\taN\u0003\u0002Q_*\u0011\u0001/]\u0001\u0005E&tGM\u0003\u0002s}\u0005\u0019q/\u001a2\n\u0005Qt'AC$fi6\u000b\u0007\u000f]5oO\u0006)a/\u00197vK2\nq/I\u0001y\u0003\u0011y\u0013\r\u001c7\u0002\r\r\u0014X-\u0019;f)\t)7\u0010C\u0003}\u000f\u0001\u0007Q0A\tde\u0016\fG/\u001a*pY\u0016\u0014V-];fgR\u0004\"A\u001a@\n\u0005}<'!E\"sK\u0006$XMU8mKJ+\u0017/^3ti\"\u001a10a\u0001\u0011\u00075\f)!C\u0002\u0002\b9\u00141BU3rk\u0016\u001cHOQ8es\"\u001a10a\u0003\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u0005U\u0011!\u00026bm\u0006D\u0018\u0002BA\r\u0003\u001f\u0011QAV1mS\u0012D3aBA\u000f!\ri\u0017qD\u0005\u0004\u0003Cq'a\u0003)pgRl\u0015\r\u001d9j]\u001e\fab\u0019:fCR,wJ]+qI\u0006$X\rF\u0002f\u0003OAq!!\u000b\t\u0001\u0004\tY#A\tva\u0012\fG/\u001a*pY\u0016\u0014V-];fgR\u00042AZA\u0017\u0013\r\tyc\u001a\u0002\u0012+B$\u0017\r^3S_2,'+Z9vKN$\b\u0006BA\u0014\u0003\u0007AC!a\n\u0002\f!2\u0001\"!\bv\u0003oa#!!\u000f\"\u0005\u0005m\u0012!B\u0018tCZ,\u0017\u0001\u00043fY\u0016$XMQ=OC6,Gc\u0001$\u0002B!9\u00111I\u0005A\u0002\u0005\u0015\u0013\u0001\u00028b[\u0016\u0004B!a\u0012\u0002P9!\u0011\u0011JA&!\ta\u0016&C\u0002\u0002N%\na\u0001\u0015:fI\u00164\u0017\u0002BA)\u0003'\u0012aa\u0015;sS:<'bAA'S!\"\u0011\u0011IA,!\ri\u0017\u0011L\u0005\u0004\u00037r'\u0001\u0004)bi\"4\u0016M]5bE2,\u0007FB\u0005\u0002`U\f)\u0007E\u0002n\u0003CJ1!a\u0019o\u00055!U\r\\3uK6\u000b\u0007\u000f]5oO2\u0012\u0011qM\u0011\u0003\u0003S\nqaL>oC6,W0\u0001\u0006eK2,G/\u001a\"z\u0013\u0012$2ARA8\u0011\u001d\t\tH\u0003a\u0001\u0003g\nQB]8mK&#'+Z9vKN$\bc\u00014\u0002v%\u0019\u0011qO4\u0003\u001bI{G.Z%e%\u0016\fX/Z:uQ\u0011\ty'a\u0003)\r)\ty&^A?Y\t\ty(\t\u0002\u0002\u0002\u0006qq&\u001b30wJ|G.Z+vS\u0012l\u0018!\u00053fY\u0016$X-\u00117m%>dWMU3ggR\u0019a)a\"\t\u000f\u0005\r3\u00021\u0001\u0002F!\"\u0011qQA,Q\u0019Y\u0011qL;\u0002\u000e2\u0012\u0011qR\u0011\u0003\u0003#\u000b1bL>oC6,WpL1mY\u0006IA-\u001a7fi\u0016\fE\u000e\u001c\u000b\u0002\r\"2A\"a\u0018v\u00033c\u0013a^\u0001\u0007kB$\u0017\r^3\u0015\u0007\u0015\fy\nC\u0004\u0002*5\u0001\r!a\u000b)\t\u0005}\u00151\u0001\u0015\u0005\u0003?\u000bY\u0001K\u0002\u000e\u0003O\u00032!\\AU\u0013\r\tYK\u001c\u0002\u000b!V$X*\u00199qS:<\u0017\u0001\u0002:fC\u0012$2!ZAY\u0011\u001d\t\u0019E\u0004a\u0001\u0003\u000bBC!!-\u0002X!*a\u0002\\;\u000282\u0012\u0011q\r\u000b\u0007\u0003w\u000bY-!6\u0011\u000b\u0005u\u0016qY3\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\fa\u0001Z8nC&t'bAAc}\u0005!A-\u0019;b\u0013\u0011\tI-a0\u0003\tA\u000bw-\u001a\u0005\b\u0003\u001b|\u0001\u0019AAh\u0003\u00191\u0017\u000e\u001c;feB\u0019a-!5\n\u0007\u0005MwMA\u0007S_2,g)\u001b7uKJ$Eo\u001c\u0005\b\u0003/|\u0001\u0019AAm\u0003!\u0001\u0018mZ3bE2,\u0007\u0003BA_\u00037LA!!8\u0002@\nA\u0001+Y4fC\ndW\r\u000b\u0002\u0010Y\u0006A!/Z1e\u0005fLE\rF\u0002f\u0003KDq!!\u001d\u0011\u0001\u0004\t\u0019\b\u000b\u0003\u0002f\u0006-\u0001&\u0002\tmk\u0006-HFAA@\u0003\u0019\u0011XM\\1nKR)Q-!=\u0002v\"9\u00111I\tA\u0002\u0005\u0015\u0003\u0006BAy\u0003/BQ\u0001`\tA\u0002uDC!!>\u0002\u0004!\"\u0011Q_A\u0006Q\u0019\t\u0012qU;\u0002~2\u0012\u0011q`\u0011\u0003\u0005\u0003\tabL>oC6,Wp\f:f]\u0006lW-A\u0003d_VtG\u000f\u0006\u0003\u0003\b\t5\u0001c\u0001\u0015\u0003\n%\u0019!1B\u0015\u0003\t1{gn\u001a\u0005\b\u0003\u001b\u0014\u0002\u0019AAhQ\u0015\u0011B.\u001eB\tY\t\u0011\u0019\"\t\u0002\u0003\u0016\u00051qfY8v]R\f\u0011C]3bI\nK(k\u001c7f!\u0006$H/\u001a:o)\rI&1\u0004\u0005\b\u0003\u001b\u001c\u0002\u0019AAhQ\u0015\u0019B.\u001eB\u0010Y\t\u0011\t#\t\u0002\u0003$\u00059qFZ5mi\u0016\u0014\bF\u0002\u0001\u0003(U\u0014i\u0003E\u0002n\u0005SI1Aa\u000bo\u00059\u0011V-];fgRl\u0015\r\u001d9j]\u001ed#Aa\f\"\u0005\tE\u0012!C\u0018wc=\u0012x\u000e\\3tQ\r\u0001!Q\u0007\t\u0004[\n]\u0012b\u0001B\u001d]\nq!+Z:u\u0007>tGO]8mY\u0016\u0014\b")
public class RolesController {
    private final RoleService roleService;
    @Autowired
    private ApplicationContext context;

    public ApplicationContext context() {
        return this.context;
    }

    public void context_$eq(ApplicationContext x$1) {
        this.context = x$1;
    }

    @GetMapping(value={"/all"})
    public List<RoleDto> readAll() {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readAll());
    }

    @PostMapping
    public RoleDto create(@Valid @RequestBody CreateRoleRequest createRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.create(createRoleRequest.name()));
    }

    @PostMapping(value={"/save"})
    public RoleDto createOrUpdate(@Valid @RequestBody UpdateRoleRequest updateRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.createOrUpdate(Role$.MODULE$.apply(UUID.fromString(updateRoleRequest.id()), updateRoleRequest.name())));
    }

    @DeleteMapping(value={"/{name}"})
    public void deleteByName(@PathVariable String name) {
        this.roleService.delete(name);
    }

    @DeleteMapping(value={"/id/{roleUuid}"})
    public void deleteById(@Valid RoleIdRequest roleIdRequest) {
        this.roleService.delete(UUID.fromString(roleIdRequest.roleUuid()));
    }

    @DeleteMapping(value={"/{name}/all"})
    public void deleteAllRoleRefs(@PathVariable String name) {
        this.roleService.deleteAllRoleReferences(name);
    }

    @DeleteMapping(value={"/all"})
    public void deleteAll() {
        this.roleService.removeAll();
    }

    @PutMapping
    public RoleDto update(@Valid @RequestBody UpdateRoleRequest updateRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.update(Role$.MODULE$.apply(UUID.fromString(updateRoleRequest.id()), updateRoleRequest.name())));
    }

    @GetMapping(value={"/{name}"})
    public RoleDto read(@PathVariable String name) {
        return RoleConverter$.MODULE$.roleToDto((Role)this.roleService.read(name).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(name);
        }));
    }

    @GetMapping
    public Page<RoleDto> read(RoleFilterDto filter, Pageable pageable) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(filter.namePattern(), pageable));
    }

    @GetMapping(value={"/id/{roleUuid}"})
    public RoleDto readById(@Valid RoleIdRequest roleIdRequest) {
        return RoleConverter$.MODULE$.roleToDto((Role)this.roleService.read(UUID.fromString(roleIdRequest.roleUuid())).getOrElse((Function0 & Serializable)() -> {
            throw new RoleIdNotFoundException(roleIdRequest.roleUuid());
        }));
    }

    @PutMapping(value={"/{name}/rename"})
    public RoleDto rename(@PathVariable String name, @Valid @RequestBody CreateRoleRequest createRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.rename(name, createRoleRequest.name()));
    }

    @GetMapping(value={"/count"})
    public long count(RoleFilterDto filter) {
        return this.roleService.count(filter.namePattern());
    }

    @GetMapping(value={"/filter"})
    public List<RoleDto> readByRolePattern(RoleFilterDto filter) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readByRolePattern(filter.namePattern()));
    }

    public RolesController(RoleService roleService) {
        this.roleService = roleService;
    }
}

