/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.colors;

import com.jeta.forms.components.colors.ColorDefinitionView;
import com.jeta.forms.components.colors.ColorSelectorUtils;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.open.gui.framework.JETADialog;
import com.jeta.open.gui.utils.JETAToolbox;
import com.jeta.open.i18n.I18N;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ColorSelector
extends JComponent {
    private ColorProperty m_color_prop = new ColorProperty();
    private LinkedList m_listeners;
    private JTextField m_key_field;
    private Component m_color_well;
    private JButton m_definition_btn;
    private LinkedHashMap m_prepended_colors;
    private ColorSelectorController m_controller;

    public ColorSelector() {
        try {
            JButton jButton;
            FormLayout formLayout = new FormLayout("center:pref,2dlu,pref,70dlu,24px,10px", "fill:pref");
            this.setLayout(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            Class<?> clazz = Class.forName("com.jeta.forms.components.colors.JETAColorWell");
            this.m_color_well = (Component)clazz.newInstance();
            this.m_color_well.setName("color.inkwell");
            this.add(this.m_color_well, cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.CENTER));
            this.add((Component)new JLabel("L&F"), cellConstraints.xy(3, 1));
            this.m_key_field = new JTextField();
            this.m_key_field.setEnabled(false);
            this.m_key_field.setName("color.field");
            this.m_key_field.setText("constant");
            this.add((Component)this.m_key_field, cellConstraints.xy(4, 1));
            this.m_definition_btn = jButton = new JButton();
            try {
                jButton.setIcon(new ImageIcon(ColorSelector.class.getClassLoader().getResource("jeta.resources/images/forms/16x16/palette.png")));
                jButton.setPreferredSize(new Dimension(24, 10));
            }
            catch (Exception exception) {
                jButton.setText("...");
            }
            this.add((Component)jButton, cellConstraints.xy(5, 1));
            this.m_controller = new ColorSelectorController();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList();
        }
        this.m_listeners.add(actionListener);
    }

    public ColorProperty getColorProperty() {
        try {
            ColorProperty colorProperty = new ColorProperty();
            colorProperty.setValue(this.m_color_prop);
            colorProperty.setConstantColor(ColorSelectorUtils.getColor(this.m_color_well));
            colorProperty.setColorKey(this.getSelectedColorKey());
            return colorProperty;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.m_color_prop;
        }
    }

    public String getSelectedColorKey() {
        return this.m_key_field.getText();
    }

    public void notifyListeners() {
        if (this.m_listeners != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.getName());
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public void prependColor(String string, Color color) {
        if (string == null) {
            return;
        }
        if (this.m_prepended_colors == null) {
            this.m_prepended_colors = new LinkedHashMap();
        }
        this.m_prepended_colors.put(string, color);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(actionListener);
        }
    }

    public void setColorProperty(ColorProperty colorProperty) {
        try {
            this.m_color_prop.setValue(colorProperty);
            String string = colorProperty.getColorKey();
            this.setSelectedColor(string);
            ColorSelectorUtils.setColor(this.m_color_well, colorProperty.getColor());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSelectedColor(String string) {
        if (string == null) {
            this.m_key_field.setText("constant");
        } else {
            this.m_key_field.setText(string);
        }
    }

    private class ColorSelectorController {
        private boolean m_silent = false;

        public ColorSelectorController() {
            ColorSelectorUtils.addActionListener(ColorSelector.this.m_color_well, new ColorWellClicked());
            ColorSelector.this.m_definition_btn.addActionListener(new DefinitionListener());
        }

        public void setSilent(boolean bl) {
            this.m_silent = bl;
        }

        public class DefinitionListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                ColorDefinitionView colorDefinitionView = new ColorDefinitionView();
                if (ColorSelector.this.m_prepended_colors != null) {
                    object = ColorSelector.this.m_prepended_colors.keySet().iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        Color color = (Color)ColorSelector.this.m_prepended_colors.get(string);
                        colorDefinitionView.prependColor(string, color);
                    }
                }
                colorDefinitionView.setColorProperty(ColorSelector.this.getColorProperty());
                object = JETAToolbox.invokeDialog(colorDefinitionView, ColorSelector.this, I18N.getLocalizedMessage("Color Definition"));
                if (((JETADialog)object).isOk()) {
                    ColorSelector.this.setColorProperty(colorDefinitionView.getColorProperty());
                    ColorSelector.this.notifyListeners();
                }
            }
        }

        public class ColorWellClicked
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ColorSelectorController.this.m_silent;
                if (!bl) {
                    ColorSelectorController.this.setSilent(true);
                    ColorSelector.this.m_key_field.setText("constant");
                    ColorSelector.this.m_color_prop.setBrightness(0);
                    ColorSelector.this.m_color_prop.setBrightnessFactor(0.7f);
                    ColorSelectorController.this.setSilent(bl);
                    ColorSelector.this.notifyListeners();
                }
            }
        }
    }
}

