/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.HttpConnectionIdleTimeoutBidi$;
import akka.http.impl.engine.http2.FrameEvent;
import akka.http.impl.engine.http2.FrameLogger$;
import akka.http.impl.engine.http2.Http2$;
import akka.http.impl.engine.http2.Http2ClientDemux;
import akka.http.impl.engine.http2.Http2Protocol$;
import akka.http.impl.engine.http2.Http2ServerDemux;
import akka.http.impl.engine.http2.Http2SubStream;
import akka.http.impl.engine.http2.RequestParsing$;
import akka.http.impl.engine.http2.RequestRendering;
import akka.http.impl.engine.http2.ResponseRendering;
import akka.http.impl.engine.http2.TelemetrySpi;
import akka.http.impl.engine.http2.client.ResponseParsing$;
import akka.http.impl.engine.http2.framing.Http2FrameParsing;
import akka.http.impl.engine.http2.framing.Http2FrameRendering;
import akka.http.impl.engine.http2.hpack.HeaderCompression$;
import akka.http.impl.engine.http2.hpack.HeaderDecompression$;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.HttpHeaderParser$;
import akka.http.impl.util.JavaMapping$;
import akka.http.impl.util.LogByteStringTools$;
import akka.http.impl.util.StreamUtils$;
import akka.http.javadsl.model.AttributeKey;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.settings.ClientConnectionSettings;
import akka.http.scaladsl.settings.Http2CommonSettings;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Full$;
import akka.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Off$;
import akka.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Simple$;
import akka.http.scaladsl.settings.ServerSettings;
import akka.http.scaladsl.settings.ServerSettings$;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class Http2Blueprint$ {
    public static final Http2Blueprint$ MODULE$ = new Http2Blueprint$();
    private static final BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, ByteString, NotUsed> unwrapTls = BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1)TLSProtocol.SendBytes$.MODULE$), (Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            Object object;
            A1 A1 = x1;
            if (A1 instanceof TLSProtocol.SessionBytes) {
                TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)A1;
                ByteString bytes = sessionBytes.bytes();
                object = bytes;
            } else {
                object = function1.apply(x1);
            }
            return (B1)object;
        }

        public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
            TLSProtocol.SslTlsInbound sslTlsInbound = x1;
            boolean bl = sslTlsInbound instanceof TLSProtocol.SessionBytes;
            return bl;
        }
    }));

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, NotUsed> serverStackTls(ServerSettings settings, LoggingAdapter log, TelemetrySpi telemetry) {
        ServerSettings x$1 = settings;
        LoggingAdapter x$2 = log;
        TelemetrySpi x$3 = telemetry;
        Seq<FrameEvent.Setting> x$4 = this.serverStack$default$3();
        boolean x$5 = this.serverStack$default$4();
        return this.serverStack(x$1, x$2, x$4, x$5, x$3).atop(this.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<HttpResponse, ByteString, ByteString, HttpRequest, NotUsed> serverStack(ServerSettings settings, LoggingAdapter log, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded, TelemetrySpi telemetry) {
        return telemetry.serverConnection().atop(this.httpLayer(settings, log)).atop(this.serverDemux(settings.http2Settings(), initialDemuxerSettings, upgraded)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding()).atop(this.framing(log)).atop(this.idleTimeoutIfConfigured(ServerSettings$.MODULE$.timeoutsShortcut(settings).idleTimeout()));
    }

    public Seq<FrameEvent.Setting> serverStack$default$3() {
        return Nil$.MODULE$;
    }

    public boolean serverStack$default$4() {
        return false;
    }

    public BidiFlow<HttpRequest, ByteString, ByteString, HttpResponse, NotUsed> clientStack(ClientConnectionSettings settings, LoggingAdapter log, TelemetrySpi telemetry) {
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log);
        return telemetry.client().atop(this.httpLayerClient(masterHttpHeaderParser, settings, log)).atop(this.clientDemux(settings.http2Settings(), masterHttpHeaderParser)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding()).atop(this.framingClient(log)).atop(this.idleTimeoutIfConfigured(settings.idleTimeout()));
    }

    public BidiFlow<HttpRequest, Http2SubStream, Http2SubStream, HttpResponse, NotUsed> httpLayerClient(HttpHeaderParser masterHttpHeaderParser, ClientConnectionSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().statefulMapConcat((Function0 & Serializable)() -> {
            RequestRendering renderer = new RequestRendering(settings, log);
            return (Function1 & Serializable)request -> {
                Http2SubStream http2SubStream = renderer.apply(request);
                return Nil$.MODULE$.$colon$colon((Object)http2SubStream);
            };
        }), StreamUtils$.MODULE$.statefulAttrsMap((Function1 & Serializable)attrs -> {
            HttpHeaderParser headerParser = masterHttpHeaderParser.createShallowCopy();
            return (Function1 & Serializable)stream -> (HttpResponse)ResponseParsing$.MODULE$.parseResponse(headerParser, settings.parserSettings(), (Attributes)attrs).apply(stream);
        }));
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> idleTimeoutIfConfigured(Duration timeout) {
        BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> bidiFlow;
        Duration duration = timeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            bidiFlow = HttpConnectionIdleTimeoutBidi$.MODULE$.apply(finiteDuration, (Option<InetSocketAddress>)None$.MODULE$);
        } else {
            bidiFlow = BidiFlow$.MODULE$.identity();
        }
        return bidiFlow;
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framing(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameRendering()), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(true, log)));
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framingClient(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameRendering()).prepend((Graph)Source$.MODULE$.single((Object)Http2Protocol$.MODULE$.ClientConnectionPreface())), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(false, log)));
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> hpackCoding() {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().via((Graph)HeaderCompression$.MODULE$), (Graph)Flow$.MODULE$.apply().via((Graph)HeaderDecompression$.MODULE$));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, NotUsed> serverDemux(Http2CommonSettings settings, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ServerDemux(settings, initialDemuxerSettings, upgraded));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, NotUsed> clientDemux(Http2CommonSettings settings, HttpHeaderParser masterHttpHeaderParser) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ClientDemux(settings, masterHttpHeaderParser));
    }

    public BidiFlow<HttpResponse, Http2SubStream, Http2SubStream, HttpRequest, NotUsed> httpLayer(ServerSettings settings, LoggingAdapter log) {
        ParserSettings parserSettings = settings.parserSettings();
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(parserSettings, log);
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1)new ResponseRendering(settings, log)), (Graph)Flow$.MODULE$.apply().via(StreamUtils$.MODULE$.statefulAttrsMap((Function1 & Serializable)attrs -> {
            HttpHeaderParser headerParser = masterHttpHeaderParser.createShallowCopy();
            return RequestParsing$.MODULE$.parseRequest(headerParser, settings, (Attributes)attrs);
        })));
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> handleWithStreamIdHeader(int parallelism, Function1<HttpRequest, Future<HttpResponse>> handler, ExecutionContext ec) {
        return (Flow)Flow$.MODULE$.apply().mapAsyncUnordered(parallelism, (Function1 & Serializable)req -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Future future;
            Future response = (Future)handler.apply(req);
            Option<Object> option = req.attribute(Http2$.MODULE$.streamId(), JavaMapping$.MODULE$.attributeKey());
            if (option instanceof Some) {
                Some some = (Some)option;
                int streamIdHeader = BoxesRunTime.unboxToInt((Object)some.value());
                future = response.map((Function1 & Serializable)x$1 -> (HttpResponse)x$1.addAttribute((AttributeKey)Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger((int)streamIdHeader)), ec);
            } else if (None$.MODULE$.equals(option)) {
                future = response;
            } else {
                throw new MatchError(option);
            }
            return future;
        }, ec).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void logParsingError(ErrorInfo info, LoggingAdapter log, ParserSettings.ErrorLoggingVerbosity setting) {
        ParserSettings.ErrorLoggingVerbosity errorLoggingVerbosity = setting;
        if (ParserSettings$ErrorLoggingVerbosity$Off$.MODULE$.equals(errorLoggingVerbosity)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ParserSettings$ErrorLoggingVerbosity$Simple$.MODULE$.equals(errorLoggingVerbosity)) {
            log.warning(info.summary());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ParserSettings$ErrorLoggingVerbosity$Full$.MODULE$.equals(errorLoggingVerbosity)) {
            log.warning(info.formatPretty());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)errorLoggingVerbosity);
        }
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, ByteString, NotUsed> unwrapTls() {
        return unwrapTls;
    }

    private Http2Blueprint$() {
    }
}

