/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.neo4j;

import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.StringUtils;

class Neo4jHealthDetailsHandler {
    Neo4jHealthDetailsHandler() {
    }

    void addHealthDetails(Health.Builder builder, String edition, ResultSummary resultSummary) {
        ServerInfo serverInfo = resultSummary.server();
        builder.up().withDetail("server", serverInfo.version() + "@" + serverInfo.address()).withDetail("edition", edition);
        DatabaseInfo databaseInfo = resultSummary.database();
        if (StringUtils.hasText((String)databaseInfo.name())) {
            builder.withDetail("database", databaseInfo.name());
        }
    }
}

